﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class CustomerHierarchyModel
    {
        public int ChannelId { get; set; }
        public int SubChannelId { get; set; }
        public int GroupId { get; set; }
        public int organizationId { get; set; }
        public string Code { get; set; }
        public bool IsEditMode { get; set; }
        public bool DeleteCustomersFromGroup { get; set; }
        public CustomersHierarchyLevel CustomersHierarchyLevel { get; set; }
        public List<TextLanguage> Descriptions { get; set; }

        public CustomerHierarchyModel()
        {
            organizationId = -1;
            ChannelId = -1;
            SubChannelId = -1;
            GroupId = -1;
            IsEditMode = false;
            Code = string.Empty;
            Descriptions = new List<TextLanguage>();
            DeleteCustomersFromGroup = false;
        }

    }

    public class CustomersGroup
    {
        public int GroupId { get; set; }
        public List<SimpleCustomerModel> Customers { get; set; }
        public List<SimpleCustomerModel> DeletedCustomers { get; set; }
        public List<SimpleCustomerModel> NewCustomers { get; set; }
        public List<Promotion> IncludedAchievementPromotions { get; set; }
        public List<Promotion> ExcludedAchievementPromotions { get; set; }
        public bool IsThereAnyAchievementPromotions { get; set; }
    }
}
