﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class CustomerMappingFilter
    {
        private DateTime _routeDate;
        public int GroupId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public bool AllGroups { get; set; }
        public bool AllCustomers { get; set; }
        public int RouteId { get; set; }
        public bool AllRoutes { get; set; }
        public bool IsRouteCustomer { get; set; }
        public bool IsRouteHistory { get; set; }
        public int RouteHistoryId { get; set; }
        public DateModel RouteDateModel { get; set; }
        public DateTime RouteDate
        {
            get { return _routeDate; }
            set
            {
                _routeDate = value;
                if (_routeDate != null)
                    RouteDateModel = new DateModel(_routeDate);
            }
        }
        public int SalesManagerId { get; set; }
        public int SupervisorId { get; set; }
        public int SalespersonId { get; set; }
        public bool AllSalesManagers { get; set; }
        public bool AllSupervisors { get; set; }
        public bool AllSalespersons { get; set; }
        public int MasterTerritoryId { get; set; }
        public int TerritoryId { get; set; }
        public bool AllMasterTerritories { get; set; }
        public bool AllTerritories { get; set; }
        public bool IsOutletWithDisplayUnit { get; set; }
        public int DisplayUnitMasterGroupId { get; set; }
        public int DisplayUnitTypeId { get; set; }
        public bool AllDisplayUnitMasterGroups { get; set; }
        public bool AllDisplayUnitTypes { get; set; }
        public bool IsClassification { get; set; }
        public int CustomerClassId { get; set; }
        public int CustomerSubClassId { get; set; }
        public bool AllSubClasses { get; set; }
        public bool IsDirectSales { get; set; }
        public bool IsNonDirectSales { get; set; }
        public bool OutletsWithCOS { get; set; }
        public bool OnHoldOutlets { get; set; }
        public int CustomerTypeId { get; set; }
        public bool AllCustomerTypes { get; set; }

    }
}
