﻿using InCube.Security;
using Newtonsoft.Json;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using static EchoCustomerOutletModel;

namespace Sonic.Web.Model
{
    public class CustomerModel
    {
        int _customerId = -1;

        public int CustomerId
        {
            get
            {
                if (_customerId == -1 && !string.IsNullOrEmpty(CustomerIdSignature))
                {
                    _customerId = int.Parse(EncryptionManager.Instance.DecryptData(CustomerIdSignature));
                }
                return _customerId;
            }
            set
            {
                _customerId = value;
                CustomerIdSignature = EncryptionManager.Instance.EncryptData(_customerId.ToString());
            }
        }
        public string CustomerIdSignature { get; set; }
        public string CustomerCode { get; set; }

        public string CustomerCodeName { get; set; }
        public string OutletCodeName { get; set; }
        public string OrganizationCodeName { get; set; }
        public string CustomerName { get; set; }
        public string CustomerID_OutletID { get; set; }
        public string OutletCustomerName { get; set; }
        public string Phone { get; set; }
        public string Fax { get; set; }
        public string Email { get; set; }
        public int StreetId { get; set; }
        public int StreetNumber { get; set; }
        public bool IsNewCustomer { get; set; }
        public string ContractNumber { get; set; }
        public int CollectorId { get; set; }
        public int CurrencyId { get; set; }
        public bool IsDirectSales { get; set; }
        public string CurrencyDescription { get; set; }
        public List<CustomerOutletModel> Outlets { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public CustomerValidationsModel CustomerValidations { get; set; }
        public List<AccountModel> AccountsList { get; set; }
        public string CustomerAttachmentsBasePath { get; set; }
        public int TerritoryId { get; set; }
        public int OutletId { get; set; }
        public bool IsDefault { get; set; }
        public bool AllowPayAllOutlets { get; set; }
        public bool ExportCustomer { get; set; }
        public int EmployeeId { get; set; }
        public int RouteID { get; set; }
        public bool InactiveOutlet { get; set; }
        public bool HasPrivilegeOnPaymentTermDivision { set; get; }
        public bool HasPrivilegeOnOnHoldDivision { set; get; }
        public List<ItemPackModel>CustomerPackBarcodeList { set; get; }
        public List<PayerAccountModel> OutletPayersList { get; set; }
        public string AchievementAndTargetPromotionIds { set; get; }
        public int PromotionId { set; get; }
        public int PaymentTermId { get; set; }
        public bool ShowStockBtn { get; set; }

        public CustomerModel()
        {
            AccountsList = new List<AccountModel>();
            Outlets = new List<CustomerOutletModel>();
            DescriptionLanguages = new List<TextLanguage>();
            OutletPayersList = new List<PayerAccountModel>();
            IsDefault = false;
            AllowPayAllOutlets = false;
            EmployeeId = -1;
            CurrencyId = -1;
            CollectorId = -1;
            RouteID = -1;
            InactiveOutlet = false;
            CustomerPackBarcodeList = new List<ItemPackModel>();
            AchievementAndTargetPromotionIds = string.Empty;
            PromotionId = -1;
            PaymentTermId = -1;
            ShowStockBtn = false;
            ExportCustomer = false;
        }
    }
    public class CustomerOutletModel
    {
        private int _customerId = -1;
        private int _outletId = -1;
        private string _outletName;
        private string _address1;
        private string _address2;      
        public CustomerOutletModel()
        {
            OutletDivisionPaymentTermList = new List<OutletDivisionPaymentTermModel>();
            HasICashBalance = false;
            ICashBalance = 0;
            groupIds = string.Empty;

            AccountsList = new List<AccountModel>();
            Account = new AccountModel();
            CustOutPaymentTerm = new PaymentTermModel();
            DivisionsPaymentTerm = new Dictionary<int, PaymentTermModel>();
            OnHoldDivisions = new List<int>();
            CustomerValidations = new CustomerValidationsModel();
            Transactions = new Dictionary<string, TransactionModel>();
            SubChannelData = new CustomerSubChannelModel();
            CustomerLanguages = new List<TextLanguage>();
            OutletLanguages = new List<TextLanguage>();
            OutletContacts = new List<CustomerContact>();
            DateOfBirthModel = new DateModel();
            DescriptionLanguages = new List<TextLanguage>();
            CreditLimitCreditRelease = new CustomerCreditReleaseModel();
            PaymentTermCreditRelease = new CustomerCreditReleaseModel();
            PaymentTermId = -1;
            StreetId = string.Empty;
            CustomerTypeId = -1;
            CustomerStatusId = -1;
            CustomerClassId = -1;
            CustomerSubClassId = -1;
            DiscountGroupId = -1;
            DiscountPriceListId = -1;
            territoryDesc = string.Empty;
            isValidDelete = true;
            HHGroupId = -1;
            ExtraInfoLink = string.Empty;
            CountryId = string.Empty;
            StateId = string.Empty;
            CityId = string.Empty;
            AreaId = string.Empty;
            Gender = -1;
            NationalityId = -1;
            CustomerSourceId = -1;
            MatchCustomerId = -1;
            MatchOutletId = -1;
            ZipCode = string.Empty;
            GLN = string.Empty;
            IsNewCustomer = false;
            OperatorId = -1;
            CustomerOutletContacts = new List<CustomerOutletContactModel>();
            OutletAttachments = new List<string>();
            IsMain = false;
            RouteHistoryDetailsList = new List<RouteHistoryDetailsModel>();
            OrganizationId = -1;
            OnHoldDivisionsList = new List<DivisionModel>();  // this is used to define on hold divisions in customer screen
            IsThereAnyGroupAchievementPromotions = false;
            SelectedSalesMode = -1;
            Landmark = string.Empty;
            TerritoryId = -1;
            IsFromSupervisor = false;

            SalesDistributionChannels = new List<SalesDistributionChannelModel>();
            CallStatus = string.Empty; // FOR CRM
            VisitId = -1;
            BuildingNumber = string.Empty;
            WarehouseId = -1;
            WarehouseOrganizationId = -1;
            CompanyPrefix = -1;
            IsBusinessCustomer = false;
            IsVendingMachine = false;
            EmployeeId = -1;
            TradeLicenceExpiryDateModel = new DateModel();
            NewCustomerTemplateId = -1;
            PoBox = string.Empty;
            TelephoneNumber = string.Empty;
            ContactName = string.Empty;
            DivisionName = string.Empty;
            Sequence = -1;
            GroupName = string.Empty;
            SubClassName = string.Empty;
            OpenTime = string.Empty;
            CloseTime = string.Empty;
            IsVisitPattern = false;
            RouteHistoryId = -1;
            DeviceSerial = string.Empty;
            TemplateImages = new List<CustomerTemplateField>();
        }
        public bool isValidDelete { get; set; }
        public int VisitId { get; set; }
        public string Landmark { get; set; }
        public string groupIds { set; get; }
        private bool IsFromSupervisor { set; get; }

        public int TerritoryId { set; get; }
        public bool HasPrivilegeOnPaymentTermDivision { set; get; }
        public bool HasPrivilegeOnOnHoldDivision { set; get; }
        public int CustomerId
        {
            get
            {
                if (_customerId == -1 && !string.IsNullOrEmpty(CustomerIdSignature))
                {
                    _customerId = int.Parse(EncryptionManager.Instance.DecryptData(CustomerIdSignature));
                }
                return _customerId;
            }
            set
            {
                _customerId = value;
                CustomerIdSignature = EncryptionManager.Instance.EncryptData(_customerId.ToString());
            }
        }


        public int OutletId
        {
            get
            {
                if (_outletId == -1 && !string.IsNullOrEmpty(OutletIdSignature))
                {
                    _outletId = int.Parse(EncryptionManager.Instance.DecryptData(OutletIdSignature));
                }
                return _outletId;
            }
            set
            {
                _outletId = value;
                OutletIdSignature = EncryptionManager.Instance.EncryptData(_outletId.ToString());
            }
        }
        public string Token { get; set; }
        public List<OutletDivisionPaymentTermModel> OutletDivisionPaymentTermList { get; set; }
        public List<int> outletTerritories { get; set; }
        public List<string> AttachedFiles { get; set; }
        public string CustomerIdSignature { get; set; }
        public string ExtraInfoLink { get; set; }
        public int DummyOutletID { get; set; }

        public string OutletIdSignature { get; set; }

        public string CustomerOutletSignature
        {
            get
            {
                return EncryptionManager.Instance.EncryptData(CustomerId + EncryptionManager.Instance.SignatureSeparator + OutletId);
                //return CustomerIdSignature + EncryptionManager.Instance.SignatureSeparator+ OutletIdSignature;
            }
            set
            {
                if (value != null)
                {
                    var _decreptedCustomerOutletIds = EncryptionManager.Instance.DecryptData(value);
                    CustomerId = int.Parse(_decreptedCustomerOutletIds.Split(EncryptionManager.Instance.SignatureSeparator)[0]);
                    OutletId = int.Parse(_decreptedCustomerOutletIds.Split(EncryptionManager.Instance.SignatureSeparator)[1]);
                    //CustomerIdSignature = value.Split(EncryptionManager.Instance.SignatureSeparator)[0];
                    //OutletIdSignature = value.Split(EncryptionManager.Instance.SignatureSeparator)[1];
                }

            }
        }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public string OutletCode { get; set; }

        public string OutletCodeName { get; set; }

        public string OutletName
        {
            get
            {
                return _outletName;
            }

            set
            {
                if (string.IsNullOrEmpty(value))
                    this._outletName = "---";
                else
                    this._outletName = value;
            }
        }

        public bool HasICashBalance { get; set; }

        public bool IsCredit { get; set; }

        public AccountModel Account { get; set; }

        public PaymentTermModel CustOutPaymentTerm { get; set; }

        public CustomerCreditReleaseModel PaymentTermCreditRelease { get; set; }

        public CustomerCreditReleaseModel CreditLimitCreditRelease { get; set; }

        public string CustomerGroupsIdsString { get; set; }

        public string CustomerChannelIdsString { get; set; }

        public string CustomerSubChannelIdsString { get; set; }

        public string CurrencyDescription { get; set; }

        public bool Taxable { get; set; }

        public bool OnHold { get; set; }

        public bool CustomerOnHold { get; set; }

        public string CustomerCode { get; set; }

        public string CustomerName { get; set; }

        public string Barcode { get; set; }

        public string Phone { get; set; }

        public string Fax { get; set; }

        public string Email { get; set; }

        public int CurrencyId { get; set; }

        public string TaxNumber { get; set; }

        public int CustomerTypeId { get; set; }
        public int CustomerStatusId { get; set; }

        public int PaymentTermId { get; set; }

        public bool Inactive { get; set; }

        public bool IsHighlighted { get; set; }
        public bool IsBusinessCustomer { get; set; }
        public bool IsVendingMachine { get; set; }
        public string Notes { get; set; }

        public string TradeLicenceNumber { get; set; }

        public int BillsNumber { get; set; }
        public int NumberOfDigits { get; set; }

        public string StreetId { get; set; }

        public string Address
        {
            get
            {
                return string.IsNullOrEmpty(_address1) ? string.Empty : _address1;
            }
            set
            {
                _address1 = value;
            }
        }

        public int CustomerClassId { get; set; }

        public int CustomerSubClassId { get; set; }

        public string VendorNumber { get; set; }

        public string CreditCardNumber { get; set; }

        public DateTime CreatedDate { get; set; }

        public string CommissionerOfReceipt { get; set; }

        public Dictionary<int, PaymentTermModel> DivisionsPaymentTerm; //DONT put { get; set; } To Avoid Not Supported Error

        public List<int> OnHoldDivisions { get; set; }

        public CustomerValidationsModel CustomerValidations { get; set; }

        public Dictionary<string, TransactionModel> Transactions;

        public List<CustomerGroupModel> Groups { get; set; }

        public List<priceListModel> PriceLists { get; set; }

        public DataActions DataAction { get; set; }

        public string CustomerCodeName { get; set; }
        public string CustomerOutletName { get; set; }
        public string CustomerOutletIds { get; set; }
        public string PaymentTerm { get; set; }

        public string CustomerType { get; set; }
        public string CustomerClass { get; set; }

        public decimal CreditLimit { get; set; }

        public decimal Balance { get; set; }
        public decimal ICashBalance { get; set; }
        public double Longitude { get; set; }
        public double Latitude { get; set; }

        public List<TextLanguage> CustomerLanguages { get; set; }
        public bool IsNewCustomer { get; set; }
        public List<TextLanguage> OutletLanguages { get; set; }

        public List<CustomerContact> OutletContacts { get; set; }

        public int MachineTypeId { set; get; }
        public int MatchCustomerId { set; get; }
        public int MatchOutletId { set; get; }


        public List<AccountModel> AccountsList { set; get; }


        public List<RouteHistoryDetailsModel> RouteHistoryDetailsList { get; set; }
        public string GLN { get; set; }
        public double GPSLongitude { set; get; }
        public double GPSLatitude { set; get; }
        public string AreaId { get; set; }
        public string CityId { get; set; }
        public string StateId { get; set; }
        public string CountryId { get; set; }
        public List<TextLanguage> AddressLanguages { get; set; }
        public List<TextLanguage> Address2Languages { get; set; }
        public string ZipCode { set; get; }
        public string OperatorName { set; get; }
        public string OperatorPassword { set; get; }
        public bool IsLockedOperator { set; get; }
        public int OperatorId { set; get; }
        public bool IsNeedToSaveOperator { set; get; }
        public bool MatchWithExistsOperator { set; get; }
        public bool IsMain { get; set; }
        public int TempOperatorId { set; get; }
        public int OrganizationId { set; get; }
        public bool IsFromSuperVisorApp { set; get; }

        public bool IsThereAnyGroupAchievementPromotions { set; get; }
        public List<Promotion> IncludedGroupAchievementPromotions { get; set; }
        public List<Promotion> ExcludedGroupAchievementPromotions { get; set; }
        public int SelectedSalesMode { get; set; }
        public List<SalesDistributionChannelModel> SalesDistributionChannels { get; set; }
        public string BuildingNumber { get; set; }
        public int WarehouseId { get; set; }
        public int WarehouseOrganizationId { get; set; }
        public List<CustomerStatusModel> CustomerStatus { set; get; }
        public int CompanyPrefix { set; get; }
        public DateModel TradeLicenceExpiryDateModel { get; set; }
        public DateTime? TradeLicenceExpiryDate { get; set; }
        #region[CRM Data]
        public string CountryName { get; set; }

        public string AreaName { get; set; }

        public string CityName { get; set; }

        public int EmployeeId { get; set; }

        public string EmployeeCodeName { get; set; }
        public string EmployeeName { get; set; } // FOR CRM

        public string EmployeePhone { get; set; } // FOR CRM


        public string Address2 // FOR CRM
        {
            get
            {
                return string.IsNullOrEmpty(_address2) ? string.Empty : _address2;
            }
            set
            {
                _address2 = value;
            }
        }

        public int CustomerSourceId { get; set; } // FOR CRM

        public string CustomerSource { get; set; } // FOR CRM

        public string CustomerCreationSource { get; set; } // FOR CRM

        public bool IsDiscounted { get; set; } // FOR CRM

        public string IdentificationNumber { get; set; } // FOR CRM

        public int NationalityId { get; set; } // FOR CRM

        public int Gender { get; set; } // FOR CRM

        public string CreatedByName { get; set; } // FOR CRM 

        public CustomerSubChannelModel SubChannelData { get; set; } // FOR CRM 

        public DateModel DateOfBirthModel { get; set; } // FOR CRM 

        public DateTime? DateOfBirth { get; set; } // FOR CRM 

        public string SubChannelName { get; set; } // FOR CRM 

        public string ChannelName { get; set; } // FOR CRM 

        public int DiscountGroupId { get; set; } // FOR CRM 
        public int DiscountPriceListId { get; set; } // FOR CRM 

        public int PriceListId { get; set; } // FOR CRM 
        public string PriceListName { get; set; } // FOR CRM 

        public int HHGroupId { get; set; } // FOR CRM 

        public string HHGroupName { get; set; } // FOR CRM 

        public string Status { get; set; }
        public string territoryDesc { get; set; }

        public string[] CustomerAttachments { get; set; }
        public List<string> OutletAttachments { get; set; }

        public List<CustomerOutletContactModel> CustomerOutletContacts { get; set; }
        public List<DivisionModel> OnHoldDivisionsList { set; get; }
        public string CallStatus { get; set; } // FOR CRM 
        public int NewCustomerTemplateId { get; set; }
        public string PoBox { get; set; }
        public string TelephoneNumber { get; set; }
        public string ContactName { get; set; }
        public string DivisionName { get; set; }
        public int Sequence { get; set; }
        public string GroupName { get; set; }
        public string SubClassName { get; set; }
        public string OpenTime { get; set; }
        public string CloseTime { get; set; }
        public string DeliveryStart { get; set; }
        public string DeliveryEnd { get; set; }
        public string Region { get; set; }
        public string StreetName { get; set; }
        public string BuildingName { get; set; }
        public string FlatNumber { get; set; }
        public string Compound { get; set; }
        public string BlockName { get; set; }
        public string CreditCardName { get; set; }
        public string CreditCardCVV { get; set; }
        public string CreditCardExpiryDate { get; set; }
        public string TradeLicenceName { get; set; }
        public bool IsVisitPattern { get; set; }
        public int RouteHistoryId { get; set; }
        public string DeviceSerial { get; set; }
        public int RouteId { get; set; }

        public List<CustomerTemplateField> TemplateImages { get; set; }
        #endregion
    }
    public class CustomerOutletOldAndNewModel
    {
        public CustomerOutletModel OldOutletData { get; set; }
        public CustomerOutletModel NewOutletData { get; set; }
    }
    public class NewCustomerTemplateAssignmentModel
    {
        public string TemplateName { get; set; }
        public int NewCustomerTemplateId { get; set; }
        public int IsDefault { get; set; }
        public int RouteId { get; set; }
    }



    public class CustomerTemplateModel
    {
        public string TemplateName { get; set; }
        public int NewCustomerTemplateId { get; set; }
        public int DefaultCustomerTypeId { get; set; }
        public int PriceListId { get; set; }
        public int PaymentTermId { get; set; }
        public bool IsVisitPatternChecked { get; set; }
        public int PromotionGroupId { get; set; }
        public int DiscountGroupId { get; set; }
        public int DefaultGroupId { get; set; }
        public decimal CreditLimit { get; set; }
        //public List<bool> FieldsList { get; set; }
        //public List<bool> DisplayFields { get; set; }
        public bool IsEditMode { get; set; }
        public string PriceList { get; set; }
        public string PromotionGroup { get; set; }
        public string DefaultGroup { get; set; }
        public string DiscountGroup { get; set; }
        public string DefaultCustomerType { get; set; }
        public List<int> DisplayFields { get; set; }
        public List<int> GeneralFields { get; set; }
        public List<int> AddressFields { get; set; }
        public List<int> DetailsFields { get; set; }
        public List<int> ImagesFields { get; set; }
        public List<int> AllImagesFields { get; set; }
        public List<int> GeneralMandatoryFields { get; set; }
        public List<int> DetailsMandatoryFields { get; set; }
        public List<int> AddressMandatoryFields { get; set; }
        public List<int> DisplayMandatoryFields { get; set; }
        public List<int> ImagesMandatoryFields { get; set; }

        public bool GeneralTabEnabled { get; set; }
        public bool DisplayTabEnabled { get; set; }
        public bool AddressTabEnabled { get; set; }
        public bool DetailsTabEnabled { get; set; }
        public bool ImagesTabEnabled { get; set; }
        public List<DivisionsCredits> DivisionsCredits { set; get; }
        public int OldCustomerTemplateID { get; set; }
        public bool IsDeleted { get; set; }

        public CustomerTemplateModel()
        {
            DivisionsCredits = new List<DivisionsCredits>();
            DisplayMandatoryFields = new List<int>();
            AddressMandatoryFields = new List<int>();
            DetailsMandatoryFields = new List<int>();
            GeneralMandatoryFields = new List<int>();
           ImagesMandatoryFields = new List<int>();
            DetailsFields = new List<int>();
            AddressFields = new List<int>();
            GeneralFields = new List<int>();
            DisplayFields = new List<int>();
            ImagesFields = new List<int>();
            AllImagesFields = new List<int>();
            NewCustomerTemplateId = -1;
            DefaultCustomerTypeId = -1;
            PriceListId  = -1;
            PaymentTermId = -1;
            PromotionGroupId = -1;
            DiscountGroupId = -1;
            DefaultGroupId = -1;
            OldCustomerTemplateID = -1;
            IsDeleted = false;
        }

    }
    public class DivisionsPaymentTerms
    {
        public int DivisionID { get; set; }
        public string DivisionMinDate { get; set; }
        public string OldestDueDate { get; set; }
        public DivisionsPaymentTerms()
        {
            DivisionID = -1;
            DivisionMinDate = string.Empty;
        }

    }
    public class DivisionsCredits
    {
        public int DivisionID { get; set; }
        public decimal CreditLimit { get; set; }
        public string DivisionCodeName { get; set; }
        public int CustomerTypeId { get; set; }

        public DivisionsCredits()
        {
            DivisionID = -1;
            CreditLimit = -1;
            DivisionCodeName = string.Empty;
            CustomerTypeId = -1;
        }

    }
    public class FieldsObject
    {

        public int TempletId { get; set; }
        public bool IsEditMode { get; set; }
        public int languageId { get; set; }
    }
    public class CustomerGroupModel
    {
        public int GroupId { get; set; }
        public string GroupName { get; set; }
        public string GroupCode { get; set; }
        public string GroupCodeName { get; set; }
        public int OrganizationId { get; set; }
        public int ChannelId { get; set; }
        public int SubChannelId { get; set; }
        public List<CustomerChannelModel> Channels { get; set; }
        public List<TextLanguage> Descriptions { get; set; }
        public int DivisionId { get; set; }
        public string DivisionCodeName { get; set; }
        public CustomerGroupModel()
        {
            Channels = new List<CustomerChannelModel>();
            Descriptions = new List<TextLanguage>();
        }
    }
    public class priceListModel
    {
        public int priceListId { get; set; }
        public string priceListName { get; set; }
    }
    public class CustomerChannelModel
    {
        public int ChannelId { get; set; }
        public string ChannelSubChannelIds { get; set; }
        public string ChannelCodeName { get; set; }
        public string ChannelName { get; set; }
        public string ChannelCode { get; set; }
        public string ChannelSubChannelDescriptions { get; set; }
        public List<CustomerSubChannelModel> SubChannels { get; set; }
        public List<TextLanguage> Descriptions { get; set; }
        public CustomerChannelModel()
        {
            SubChannels = new List<CustomerSubChannelModel>();
            Descriptions = new List<TextLanguage>();
        }
    }
    public class CustomerSubChannelModel
    {
        public int SubChannelId { get; set; }
        public string SubChannelName { get; set; }
        public string SubChannelCode { get; set; }
        public string SubChannelCodeName { get; set; }
        public int ChannelId { get; set; }
        public string ChannelName { get; set; }
        public List<TextLanguage> Descriptions { get; set; }

        public CustomerSubChannelModel()
        {
            Descriptions = new List<TextLanguage>();
        }
    }
    public class CustomerTypeModel
    {
        public int CustomerTypeId { get; set; }
        public string CustomerTypeName { get; set; }

    }
    public class CustomerStatusModel
    {
        public int CustomerStatusId { get; set; }
        public string CustomerStatusName { get; set; }
        public string organizationId { get; set; }

    }
    public class CustomerClassModel
    {
        public int CustomerClassId { get; set; }
        public string CustomerClassName { get; set; }
        public string CustomerClassCodeName { get; set; }
        public string CustomerClassCode { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }

    }
    public class CustomerSubClassModel
    {
        public int CustomerSubClassId { get; set; }
        public string CustomerSubClassName { get; set; }
        public string CustomerSubClassCodeName { get; set; }
        public string CustomerSubClassCode { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }

    }
    public class CreditReleaseModel
    {
        public int CreditReleaseId { get; set; }
        public string Code { get; set; }
        public int TypeId { get; set; }
        public string Type { get; set; }
        public decimal Value { get; set; }
        public string ValueString { get; set; }
        public string OrganizationCodeName { get; set; }
        public int Status { set; get; }
        public bool IsPending { set; get; }
        public List<string> AttachedFiles { get; set; }
        public List<string> DeletedFiles { get; set; }
        public string CreditReleaseStatusName { get; set; }

        private DateTime? _startDate;
        private DateTime? _endDate;
        private DateTime? _createdDate;
        public DateModel StartDateModel { get; set; }
        public DateModel EndDateModel { get; set; }
        public DateModel CreatedDateModel { get; set; }
        public DateTime? StartDate
        {
            get { return _startDate; }
            set
            {
                _startDate = value;
                if (_startDate != null)
                    StartDateModel = new DateModel(_startDate.Value);
            }
        }
        public DateTime? EndDate
        {
            get { return _endDate; }
            set
            {
                _endDate = value;
                if (_endDate != null)
                    EndDateModel = new DateModel(_endDate.Value);
            }
        }
        public DateTime? CreatedDate
        {
            get { return _createdDate; }
            set
            {
                _createdDate = value;
                if (_createdDate != null)
                    CreatedDateModel = new DateModel(_createdDate.Value);
            }
        }

        public bool AllCustomers { get; set; }
        public List<SimpleCustomerModel> AppliedCustomers { get; set; }
        public List<CustomerGroupModel> AppliedGroups { get; set; }
        public List<CustomerChannelModel> AppliedChannels { get; set; }
        public List<OrganizationModel> AppliedOrganizations { get; set; }
        //public List<CreditReleaseAssignmentModel> appliedToList { get; set; }
        public string Notes { get; set; }

        public CreditReleaseModel()
        {
            Code = string.Empty;
            AllCustomers = false;
            AppliedCustomers = new List<SimpleCustomerModel>();
            AppliedGroups = new List<CustomerGroupModel>();
            AppliedChannels = new List<CustomerChannelModel>();
            AppliedOrganizations = new List<OrganizationModel>();
        }
    }
    public class CreditReleaseDataModel
    {
        public List<CreditReleaseAssignmentModel> Groups { set; get; }
        public List<CreditReleaseAssignmentModel> Channels { set; get; }
        public List<CreditReleaseAssignmentModel> Customers { set; get; }
        public List<SecurityGroupModel> securityGroupsList { set; get; }
    }
    public class CreditReleaseAssignmentModel
    {
        //-----
        public int CustomerId { set; get; }
        public int OutletId { set; get; }
        public int GroupId { get; set; }
        public int ChannelId { get; set; }
        public int SubChannelId { get; set; }
        public int SecurityGroupId { get; set; }
        public string customerOutletName { get; set; }
        public string CustomerCodeName { get; set; }
        public string OutletCodeName { get; set; }
        public string channelName { get; set; }
        public string groupName { get; set; }
        public string SecurityGroupName { get; set; }
        public string ChannelSubChannelIds { get; set; }
        public string ChannelSubChannelDescriptions { get; set; }
        public bool AllSecurityGroups { get; set; }
        public bool useTranslate { get; set; }
        public string CustomerCode { get; set; }
        public string OutletCode { get; set; }
        public string OutletName { get; set; }
        public int OrganizationId { get; set; }
        public List<int> OrganizationIdsList { get; set; }

        public CreditReleaseAssignmentModel()
        {
            SecurityGroupId = -1;
            CustomerId = -1;
            OutletId = -1;
            GroupId = -1;
            ChannelId = -1;
            SubChannelId = -1;
            customerOutletName = "-----";
            SecurityGroupName = "-----";
            groupName = "-----";
            channelName = "-----";
            AllSecurityGroups = false;
            useTranslate = false;
            ChannelSubChannelIds = string.Empty;
            ChannelSubChannelDescriptions = string.Empty;
            CustomerCodeName = string.Empty;
            OutletCodeName = string.Empty;
            CustomerCode = string.Empty;
            OutletCode = string.Empty;
            OutletName = string.Empty;
            OrganizationId = -1;
            OrganizationIdsList = new List<int>();

        }
    }
    public class SimpleCustomerModel
    {
        public SimpleCustomerModel()
        {
            CustomerId = -1;
            OutletId = -1;
            CustomerCode = string.Empty;
            CustomerName = string.Empty;
            CustomerCodeName = string.Empty;
            OutletCode = string.Empty;
            OutletName = string.Empty;
            OutletCodeName = string.Empty;
            Sequence = -1;
            OrganizationId = -1;
            OrganizationIdsList = new List<int>();
            DivisionId = -1;
            DivisionCodeName = string.Empty;
            PriceListCode = string.Empty;
            PriceListID = -1;
            DescriptionLanguages = new List<TextLanguage>();
            CustomerOutletContacts = new List<CustomerOutletContactModel>();
        }

        public List<TextLanguage> DescriptionLanguages { get; set; }

        public List<CustomerOutletContactModel> CustomerOutletContacts { get; set; }

        public int PriceListID { get; set; }

        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public string CustomerCode { get; set; }
        public string CustomerName { get; set; }
        public string CustomerCodeName { get; set; }
        public int Sequence { get; set; }
        public string OutletCode { get; set; }
        public string OutletName { get; set; }
        public string OutletCodeName { get; set; }
        public string Phone { get; set; }
        public string Address { get; set; }
        public string TradeLicenceNumber { get; set; }
        public int OrganizationId { get; set; }
        public List<int> OrganizationIdsList { get; set; }
        public string PriceListCode { get; set; }
        public int DivisionId { get; set; }
        public string DivisionCodeName { get; set; }
        public int SDCId { get; set; }
        public List<int> SDCIdsList { get; set; }
    }
    public class CustomerOutletFilter
    {
        public CustomListFilters CustomListFilter { get; set; }
        public int TerritoryId { get; set; }
        public int RouteId { get; set; }
        public int CustomerTypeId { get; set; }
        public int ChannelId { get; set; }
        public int SubChannelId { get; set; }
        public int CustomerGroupId { get; set; }
        public int CustomerClassId { get; set; }
        public string SelectedOraganizationIds { get; set; }
        public bool ShowDefault { get; set; }
        public string CountryId { get; set; }
        public string StateID { get; set; }
        public string CityId { get; set; }
        public string AreaId { get; set; }
        public string StreetId { get; set; }
        public int DivisionId { get; set; }
        public bool GetAllData { get; set; }
        public bool FillCustomerOrganizationIds { get; set; }
        public bool FillCustomerSDCIds { get; set; }
        public List<SimpleCustomerModel> ExcludedCustomers { get; set; }
        public int TeleRepId { get; set; }
        public List<int> SDCIdsList { get; set; }
        public int SDCId { get; set; }
        public bool isCustomerOutletDivisionHasRecords { get; set; }
        public bool IsFromPayerAccountScreen { get; set; }
        public bool IsFromTerritoryScreen { get; set; }


        public CustomerOutletFilter()
        {
            TerritoryId = -1;
            RouteId = -1;
            CustomerTypeId = -1;
            ChannelId = -1;
            SubChannelId = -1;
            CustomerGroupId = -1;
            CustomerClassId = -1;
            SelectedOraganizationIds = string.Empty;
            ShowDefault = false;
            CountryId = string.Empty;
            StateID = string.Empty;
            CityId = string.Empty;
            AreaId = string.Empty;
            StreetId = string.Empty;
            DivisionId = -1;
            GetAllData = false;
            FillCustomerOrganizationIds = false;
            ExcludedCustomers = new List<SimpleCustomerModel>();
            TeleRepId = -1;
            FillCustomerSDCIds = false;
            SDCIdsList = new List<int>();
            SDCId = -1;
            isCustomerOutletDivisionHasRecords = false;
            IsFromPayerAccountScreen = false;
            IsFromTerritoryScreen = false;
        }
    }
    public class ComboBoxModel
    {
        public int Id { get; set; }
        public string Description { get; set; }
        public bool IsMandatory { get; set; }
        public bool IsVisable { get; set; }
    }
    public class CustomerPointsBalanceModel
    {
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public string CustomerCode { get; set; }
        public string CustomerName { get; set; }
        public string CustomerCodeName { get; set; }
        public string OutletCode { get; set; }
        public string OutletName { get; set; }
        public string OutletCodeName { get; set; }
        public decimal PointsBalance { get; set; }
        public int CreatedBy { get; set; }
        public DateTime CreatedDate { get; set; }
        public int UpdatedBy { get; set; }
        public DateTime UpdatedDate { get; set; }
        public string TransactionId { get; set; }
        public int ActionId { get; set; }
        public decimal OldPointsBalance { get; set; }
        public decimal NewPointsBalance { get; set; }
        public string Note { get; set; }
        public CustomerPointsBalanceModel()
        {
            CustomerId = -1;
            OutletId = -1;
            CustomerCode = string.Empty;
            CustomerName = string.Empty;
            CustomerCodeName = string.Empty;
            OutletCode = string.Empty;
            OutletName = string.Empty;
            OutletCodeName = string.Empty;
            PointsBalance = 0;
            CreatedBy = -1;
            CreatedDate = new DateTime();
            UpdatedBy = -1;
            UpdatedDate = new DateTime();
            TransactionId = string.Empty;
            ActionId = -1;
            OldPointsBalance = 0;
            NewPointsBalance = 0;
            Note = string.Empty;
        }
    }
    public class EchoCustomersModel
    {
        public int CustomerID { get; set; }
        public int OutletID { get; set; }
        public string CustomerCode { get; set; }
        public string OutletCode { get; set; }
        public string CustomerOutletIds { get; set; }
        public string CustomerOutletName { get; set; }

        public EchoCustomersModel()
        {
            CustomerID = -1;
            OutletID = -1;
            CustomerCode = string.Empty;
            OutletCode = string.Empty;
            CustomerOutletIds = string.Empty;
            CustomerOutletName = string.Empty;
        }
    }

}
public class EchoCustomerOutletModel
{
    public int CustomerId { get; set; }
    public int OutletId { get; set; }
    public string OutletCode { get; set; }
    public string OutletName { get; set; }
    public double GPSLongitude { set; get; }
    public double GPSLatitude { set; get; }

    EchoCustomerOutletModel()
    {
        CustomerId = -1;
        OutletId = -1;
        OutletCode = string.Empty;
        OutletName = string.Empty;
    }

    public class CustomerOutletContactModel
    {
        public CustomerOutletContactModel()
        {
            ContactId = -1;
            ContactName = string.Empty;
            Mobile = 0;
            Phone = 0;
            Fax = 0;
            Street = -1;
            StreetName = string.Empty;
            Address = string.Empty;
            Email = string.Empty;
            ContactDescriptionsLanguages = new List<TextLanguage>();
            AddressDescriptionsLanguages = new List<TextLanguage>();
            LanguageId = -1;
        }
        public int ContactId { get; set; }
        public string ContactName { get; set; }
        public long Mobile { get; set; }
        public long Phone { get; set; }
        public long Fax { get; set; }
        public int Street { get; set; }
        public string StreetName { get; set; }
        public string Address { get; set; }
        public string Email { get; set; }
        public List<TextLanguage> ContactDescriptionsLanguages { get; set; }
        public List<TextLanguage> AddressDescriptionsLanguages { get; set; }
        public int LanguageId { get; set; }
    }

    public class customerHierarchyModel
    {
        public string CompositeId { get; set; }
        public string ParentId { get; set; }
        public string Name { get; set; }
        public bool HasChild { get; set; }
    }
    public class CustomerTemplateField
    {
        public string Description { get; set; }
        public string Value { get; set; }
        public int Id { get; set; }
        public string Name { get; set; }
        public string ImagePath { get; set; }
        public string ImageName { get; set; }
        public string DeviceSerial { get; set; }
        public int RouteHistoryId { get; set; }

        public CustomerTemplateField()
        {
            Description = string.Empty;
            Value = string.Empty;
            Id = -1;
            Name = string.Empty;
            ImagePath = string.Empty;
            ImageName = string.Empty;
            DeviceSerial = string.Empty;
            RouteHistoryId = -1;
        }
    }
}

