﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class MustSellItems
    {
        private DateTime? _startDate;
        private DateTime? _endDate;
        public int MustSellItemId { get; set; }
        public List<ItemGroupModel> ItemGroups { set; get; }
        public List<ItemPackModel> Items { set; get; }
        public List<SimpleCustomerModel> AppliedCustomers { get; set; }
        public List<CustomerGroupModel> AppliedGroups { get; set; }
        public List<CustomerModel> ExcludeCustomers { set; get; }
        public bool AllCustomers { set; get; }
        public bool Inactive { set; get; }
        public bool Mandatory { set; get; }
        public bool ViewInSuggestedOrder { set; get; }
        public string MustSellItemName { set; get; }
        public string MustSellItemCode { set; get; }
        public List<EmployeeModel> Employees { set; get; }
        public List<SecurityGroupModel> SecurityGroups { set; get; }
        public List<TextLanguage> LanguageDescriptions { get; set; }
        public DateModel StartDateModel { get; set; }
        public DateModel EndDateModel { get; set; }
        public int AppliedOnLevelId { get; set; }
        public decimal QuantityLimit { get; set; }
        public string IsMandatory { get; set; }
        public string IsViewInSuggestedOrder { get; set; }
       
        public string ItemCodeName { get; set; }
        public string ItemGroupName { get; set; }
        public string GroupCodeName { get; set; }
        public string CustomerCodeName { get; set; }
        public string OutletCodeName { get; set; }
        public string EmployeeCodeName { get; set; }
        public string SecurityGroupName { get; set; }
        public string OrganizationCodeName { get; set; }
        public int ItemId { get; set; }
        public int ItemGroupId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int GroupId { get; set; }
        public int EmployeeId { get; set; }
        public int SecurityGroupId { get; set; }
        public int organizationId { get; set; }
        public bool IsActive { get; set; }
        public List<OrganizationModel> OrganizationList { set; get; }


        public DateTime? StartDate
        {
            get { return _startDate; }
            set
            {
                _startDate = value;
                if (_startDate != null)
                    StartDateModel = new DateModel(_startDate.Value);
            }
        }
        public DateTime? EndDate
        {
            get { return _endDate; }
            set
            {
                _endDate = value;
                if (_endDate != null)
                    EndDateModel = new DateModel(_endDate.Value);
            }
        }


        public MustSellItems()
        {
            Items = new List<ItemPackModel>();
            ItemGroups = new List<ItemGroupModel>();
            AppliedCustomers = new List<SimpleCustomerModel>();
            AppliedGroups = new List<CustomerGroupModel>();
            ExcludeCustomers = new List<CustomerModel>();
            Employees = new List<EmployeeModel>();
            SecurityGroups = new List<SecurityGroupModel>();
            OrganizationList = new List<OrganizationModel>();
            AllCustomers = false;
            Inactive = false;
            Mandatory = false;
            ViewInSuggestedOrder = false;   
            IsActive = false;
            MustSellItemName = string.Empty;
            MustSellItemCode = string.Empty;
            QuantityLimit = 0;
            IsMandatory = string.Empty;
            IsViewInSuggestedOrder = string.Empty;
            ItemCodeName = string.Empty;
            ItemGroupName = string.Empty;
            GroupCodeName = string.Empty;
            CustomerCodeName = string.Empty;
            OutletCodeName = string.Empty;
            EmployeeCodeName = string.Empty;
            SecurityGroupName = string.Empty;
            OrganizationCodeName = string.Empty;
            ItemId = -1;
            ItemGroupId = -1;
            CustomerId = -1;
            OutletId = -1;
            GroupId = -1;
            EmployeeId = -1;
            SecurityGroupId = -1;
            organizationId = -1;
        }
    }
}

