﻿using Microsoft.AspNetCore.Http;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class FCMNotificationModel
    {
        [JsonProperty(PropertyName = "to")]
        public string To { get; set; }        

        [JsonProperty(PropertyName = "notification")]
        public MessageModel Message { get; set; }        
        [JsonProperty(PropertyName = "data")]
        public NotificaitonDataModel data { get; set; }        
        [JsonProperty(PropertyName = "priority")]
        public string priority { get; set; }
    }
    public class MessageModel
    {
        [JsonProperty(PropertyName = "title")]
        public string title { get; set; }
        [JsonProperty(PropertyName = "body")]
        public string body { get; set; }
        [JsonProperty(PropertyName = "click_action")]
        public string click_action { get; set; }    
        [JsonProperty(PropertyName = "icon")]
        public string icon { get; set; }     
        [JsonProperty(PropertyName = "sound")]
        public string sound { get; set; }       
        [JsonProperty(PropertyName = "badge")]
        public string badge { get; set; }

    }
    public class NotificaitonDataModel
    {
        [JsonProperty(PropertyName = "orderId")]
        public string orderId { get; set; }     
        [JsonProperty(PropertyName = "employeeId")]
        public string employeeId { get; set; }       
        [JsonProperty(PropertyName = "statusId")]
        public string statusId { get; set; }
        [JsonProperty(PropertyName = "badge")]
        public string badge { get; set; }

    }
    public class MessageBodyModel
    {
        public int LanguageId { get; set; }
        public string BodyDescription { get; set; }
        public int KeyTypeID { get; set; }
    }
    public class NotificaitonsModel
    {
        public int NotificationId { get; set; }
        public int EmployeeId { get; set; }
        public int TypeId { get; set; }
        public List<EchoCustomers> Customers { get; set; }
        public List<EchoGroups> Groups { get; set; }
        public List<EchoChannels> Channels { get; set; }
        public string Subject { get; set; }
        public string Body { get; set; }  
        public string ArabicSubject { get; set; }
        public string ArabicBody { get; set; }
        public string ImageName { get; set; }
        public string VideoName { get; set; }
        public string OrderId { get; set; }
        public bool UnRead { get; set; }
        public DateTime CreatedDate { get; set; }
        public int OrderStatusId{ get; set; }
        public bool promotionNotification { get; set; }
        public NotificaitonsModel()
        {
            Customers = new List<EchoCustomers>();
            Channels = new List<EchoChannels>();
            Groups = new List<EchoGroups>();
        }
    }

    public class EchoCustomers
    {
        public string CustomerOutletIds { get; set; }
        public string CustomerOutletName { get; set; }
        public EchoCustomers()
        {
            CustomerOutletIds = string.Empty;
            CustomerOutletName = string.Empty;
        }
    }

    public class EchoChannels
    {
        public string ChannelSubChannelIds { get; set; }
        public string ChannelSubChannelDescriptions { get; set; }
    }

    public class EchoGroups
    {
        public int GroupId { get; set; }
        public string GroupCode { get; set; }
    }
}
