﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class PayerAccountModel
    {
        public int PayerId { get; set; }
        public int AccountId { get; set; }
        public List<SimpleCustomerModel> AppliedCustomers { get; set; }
        public List<CustomerGroupModel> AppliedGroups { get; set; }
        public List<DivisionModel> Divisions { get; set; }
        public string PayerName { set; get; }
        public string PayerCode { set; get; }
        public List<TextLanguage> LanguageDescriptions { get; set; }
        public decimal CreditLimit { get; set; }
        public decimal Balance { get; set; }
        public string GroupCodeName { get; set; }
        public string CustomerCodeName { get; set; }
        public string OutletCodeName { get; set; }
        public string DivisionCodeName { get; set; }
        public string OrganizationCodeName { get; set; }
        public string PayerCodeName { get; set; }
        public int CustomerId { get; set; }
        public int OrganizationId { get; set; }
        public int CurrencyId { get; set; }
        public int OutletId { get; set; }
        public int CustomerGroupId { get; set; }
        public int GroupId { get; set; }
        public int DivisionId { get; set; }
        public bool IsLinkedToTransaction { get; set; }
        public bool IsPayerOutOfAcess { get; set; }
        public bool IsDisabledInput { get; set; }
        public PayerAccountModel()
        {
            AppliedCustomers = new List<SimpleCustomerModel>();
            AppliedGroups = new List<CustomerGroupModel>();
            Divisions = new List<DivisionModel>();
            PayerName = string.Empty;
            PayerCode = string.Empty;
            CreditLimit = 0;
            Balance = 0;
            GroupCodeName = string.Empty;
            CustomerCodeName = string.Empty;
            OutletCodeName = string.Empty;
            DivisionCodeName = string.Empty;
            OrganizationCodeName = string.Empty;
            PayerCodeName = string.Empty;
            CustomerId = -1;
            OutletId = -1;
            CustomerGroupId = -1;
            DivisionId = -1;
            OrganizationId = -1;
            CurrencyId = -1;
            AccountId = -1;
            PayerId = -1;
            GroupId = -1;
            IsLinkedToTransaction = false;
            IsPayerOutOfAcess = false;
            IsDisabledInput = false;
        }
    }
}


