﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model.Customer
{
    public class PriceProtectionModel
    {
        public string RequestID { get; set; }
        public int CustomerID { set; get; }
        public string CustomerCodeName { set; get; }
        public int OutletID { set; get; }
        public string OutletCodeName { set; get; }
        public int EmployeeID { set; get; }
        public string EmployeeCodeName { set; get; }
        public int RouteHistoryID { get; set; }
        public DateTime CreationDate { get; set; }
        public DateTime UpdateDate { get; set; }
        public int StatusID { get; set; }
        public string RequestStatusDescription { set; get; }
        public bool ShowEditBtn { get; set; }
        public bool ShowApproveBtn { get; set; }
        public bool ShowRejectBtn { get; set; }
    }

    public class PriceProtectionDetailModel
    {
        public string RequestID { get; set; }
        public string FromSerial { get; set; }
        public string ToSerial { get; set; }
        public int PackID { get; set; }
        public decimal OldPrice { get; set; }
        public decimal Price { get; set; }
        public decimal NewPrice { get; set; }
        public int SalesTransactionTypeID { get; set; }
        public string ItemName { get; set; }
        public string Quantity { get; set; }
        public decimal PriceDifference { get; set; }
        public int DivisionID { get; set; }
        public bool Voided { get; set; }
        public int SerialSold { get; set; }
        public bool SerialExist { get; set; }
        PriceProtectionDetailModel()
        {
            Voided = false;
            DivisionID = -1;
            SerialSold = 2;
            SerialExist = false;
        }

    }

    public class PriceProtectionFilterModel
    {

        public int CustomerId { set; get; }
        public int OutletId { set; get; }
        public int EmployeeId { set; get; }
        public int StatusId { get; set; }
        public IList<DateModel> FromToDate { get; set; }
        public CustomListFilters CustomListFilter { get; set; }

    }

}
