﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class TeleRepFilter
    {
        public int EmployeeId { get; set; }
        public DateModel DateModel { get; set; }
        public TeleRepFilter()
        {
            EmployeeId = -1;
        }
    }
    public class TeleRepData
    {
        public int EmployeeId { get; set; }

        public List<SimpleCustomerModel> TeleRepCustomers { get; set; }
        public TeleRepData()
        {
            EmployeeId = -1;
            TeleRepCustomers = new List<SimpleCustomerModel>();
        }
    }
    public class TeleRepPlanModel
    {
        public int CallPlanId { get; set; }
        public DateModel DateModel { get; set; }
        public List<SimpleCustomerModel> Customers { get; set; }
        public int EmployeeId { get; set; }

        public TeleRepPlanModel()
        {
            CallPlanId = -1;
            EmployeeId = -1;
            Customers = new List<SimpleCustomerModel>();
        }
    }

    public class TeleRepVisitStatusModel
    {
        public int VisitStatusId { get; set; }
        public string VisitStatusDescription { get; set; }
        public TeleRepVisitStatusModel()
        {
            VisitStatusId = -1;
            VisitStatusDescription = string.Empty;
        }

    }
    public class TeleRepVisitModel
    {
        public TeleRepVisitModel()
        {
            VisitId = -1;
            EmployeeId = -1;
            CustomerId = -1;
            OutletId = -1;
            Note = string.Empty;
            NonProductiveReasonId = -1;
        }
        public int VisitId { get; set; }
        public int EmployeeId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public DateTime VisitDate { get; set; }
        public DateTime StartDate { get; set; }
        public DateTime EndDate { get; set; }
        public string IsEnded { get; set; }
        public TeleRepVisitStatus VisitStatusId { get; set; }
        public int NonProductiveReasonId { get; set; }
        public string Note { get; set; }
    }
}
