﻿using System.Collections.Generic;
using System.Dynamic;

namespace Sonic.Web.Model
{
    public class ChangeDescriptionsTable
    {
        public List<dynamic> TableData { get; set; }
        public List<LanguageModel> TableHeader { get; set; }
    }

    public class LanguageModel
    {
        public string Description { get; set; }
        public int LanguageId { get; set; }
        public bool RTL { get; set; }
        public string Code { get; set; }
        public bool Active { get; set; }
        public bool OldStatus { get; set; }
        public bool IsChecked { get; set; }
    }

    public class LanguageCaption
    {
        public string DescriptionKey { get; set; }
        public string DescriptionValue { get; set; }
        public bool IsEditable { get; set; }
        public bool isInEditeMode { get; set; }
        public int LanguageId { get; set; }
        public int ModuleId { get; set; }
    }
    public class UniqueDescriptionModel
    {
        public string tableName { get; set; }
        public string columnName { get; set; }
        public string insertedValue { get; set; }
        public string excludedString { get; set; }
        public List<TextLanguage> descriptionLanguages { get; set; }

    }

    public class TextLanguage
    {
        public string Description { get; set; }
        public string Remarks { get; set; }
        public int LanguageId { get; set; }
        public int Id { get; set; }

        public TextLanguage()
        {
            Remarks = string.Empty;
        }
    }
    public class FQAsTextLanguage
    {
        public string Description { get; set; }
        public int LanguageId { get; set; }
    }
        public class SonicModulesModel
    {
        public int ModuleID { get; set; }
        public string ModuleName { get; set; }
        public bool ApplyReset { get; set; }
    }
    public class DescriptionsData
    {
        public DescriptionsData() { }

        public List<ExpandoObject> captions { get; set; }
        public int moduleId { get; set; }
    }
}