﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class DiscountModel
    {
        public int DiscountAssignmentId { get; set; }
        public int DiscountId { get; set; }
        public string DiscountName { get; set; }
        public string DiscountCode { get; set; }
        public string DiscountNameCode { get; set; }
        public decimal Amount { get; set; }
        public string AmountString { get; set; }
        private DateTime? _startDate;
        private DateTime? _endDate;
        public int TypeId { get; set; }
        public string TypeName { get; set; }
        public int DiscountTypeId { get; set; }
        public string DiscountTypeName { get; set; }
        public int DivisionId { get; set; }
        public string DivisionCode { get; set; }
        public string Division { get; set; }
        public DateModel StartDateModel { get; set; }
        public DateModel EndDateModel { get; set; }
        public List<string> AttachedFiles { get; set; }
        public List<string> DeletedFiles { get; set; }
        public DateTime? StartDate
        {
            get { return _startDate; }
            set
            {
                _startDate = value;
                if (_startDate != null)
                    StartDateModel = new DateModel(_startDate.Value);
            }
        }
        public DateTime? EndDate
        {
            get { return _endDate; }
            set
            {
                _endDate = value;
                if (_endDate != null)
                    EndDateModel = new DateModel(_endDate.Value);
            }
        }
        public string AppliedOn { get; set; }
        public string ItemCode { get; set; }
        public string ItemName { get; set; }
        public string UOM { get; set; }
        public int ItemId { get; set; }
        public int PackId { get; set; }
        public bool Inactive { get; set; }
        public int Status { set; get; }
        public bool IsPending { set; get; }

        public bool AllItems { get; set; }
        public int appliedOnId { get; set; }
        public int OrganizationId { get; set; }
       // public Dictionary<int, string> DiscountDescriptionsList { get; set; }
        public int PackGroupId { get; set; }
        public string PackGroup { get; set; }
        public string DiscountType { get; set; }
        public List<TextLanguage> DiscountDescriptionLanguages { get; set; }
        public bool AllCustomers { get; set; }
        public List<SimpleCustomerModel> AppliedCustomers { get; set; }
        public List<CustomerGroupModel> AppliedGroups { get; set; }
        public List<CustomerChannelModel> AppliedChannels { get; set; }
        public string DiscountStatusName { get; set; }
        public string OfferAppliedOptions { get; set; }
        public bool IsRange { get; set; }
        public int FromValue { get; set; }
        public int ToValue { get; set; }
        public int SalesOrderTypeId { get; set; }
        public string SalesOrderTypeName { get; set; }
        public int Priority { get; set; }
        public List<SalesDistributionChannelModel> SDCSList { get; set; }
        public DiscountModel()
        {
            DiscountAssignmentId = -1;
            DiscountId = -1;
            DiscountName = string.Empty;
            DiscountCode = string.Empty;
            Amount = 0;
            AmountString = string.Empty;
            TypeId = -1;
            TypeName = string.Empty;
            DiscountNameCode = string.Empty;
            DiscountTypeId = -1;
            DiscountTypeName = string.Empty;
            DivisionId = -1;
            DivisionCode = string.Empty;
            Division = string.Empty;
            AppliedOn = string.Empty;
            ItemCode = string.Empty;
            ItemName = string.Empty;
            UOM = string.Empty;
            ItemId = -1;
            PackId = -1;
            Inactive = false;
            AllItems = false;
            appliedOnId = -1;
            OrganizationId = -1;
           // DiscountDescriptionsList = new Dictionary<int, string>();
            PackGroupId = -1;
            PackGroup = string.Empty;
            DiscountType = string.Empty;
            DiscountDescriptionLanguages = new List<TextLanguage>();
            AllCustomers = false;
            AppliedCustomers = new List<SimpleCustomerModel>();
            AppliedGroups = new List<CustomerGroupModel>();
            AppliedChannels = new List<CustomerChannelModel>();
            DiscountStatusName = string.Empty;
            AttachedFiles = new List<string>();
            DeletedFiles = new List<string>();
            IsRange = false;
            FromValue = -1;
            ToValue = -1;
            SalesOrderTypeId = -1;
            SalesOrderTypeName = string.Empty;
            Priority = -1;
            SDCSList = new List<SalesDistributionChannelModel>();
        }
    }
    public class DiscountTypesModel
    {
        public int DiscountTypeId { get; set; }
        public string DiscountTypeName { get; set; }
    }
}
  
