﻿using System.Collections.Generic;

namespace Sonic.Web.Model
{
    public class DynamicProperty
    {
        public Dictionary<string, object> Properties = new Dictionary<string, object>();
        public object this[string name]
        {
            get
            {
                if (Properties.ContainsKey(name))
                {
                    return Properties[name];
                }
                return null;
            }
            set
            {
                Properties[name] = value;
            }
        }
    }
}