﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.Json.Serialization;

namespace Sonic.Web.Model
{
    public class DynamicReportModel
    {
        public int ReportId { get; set; }        
        public string ReportName { get; set; }
        public string FileName { get; set; }
        public List<ReportFilterModel> ReportFilters { get; set; }
        public List<KeyValueModel> FiltersData { set; get; }
        public List<dynamic> ReportData { get; set; }
        [JsonIgnore]
        public string QueryString { get; set; }
        public int ScheduleId { get; set; }
        public int ReportScheduleAssignmentId { get; set; }
        public string HeaderFilterString { get; set; }
        public int PeriodTypeId { get; set; }
        public DynamicReportModel()
        {
            QueryString = string.Empty;
            FileName = string.Empty;
            ReportFilters = new List<ReportFilterModel>();
            FiltersData = new List<KeyValueModel>();
            ReportData = new List<dynamic>();
            ReportId = -1;
            ScheduleId = -1;
            PeriodTypeId = -1;
        }
    }
    public class ReportFilterModel
    {
        public int ReportId { get; set; }
        public int ScheduleId { get; set; }
        public int ReportFilterId { get; set; }
        public ReportFilterTypes ReportFilterTypeId { get; set; }
        [JsonIgnore]
        public string QueryString { get; set; }
        public int ReportScheduleAssignmentId { get; set; }
        public string DisplayMember1 { get; set; }
        public string DisplayMember2 { get; set; }
        public string ValueMember { get; set; }
        public bool BuiltIn { get; set; }
        public string Description { get; set; }
        public int ReportParameterId { get; set; }
        public int SequenceId { get; set; }
        public string ParameterName { get; set; }
        public bool IsDateFilter { get; set; }
        public bool IsDateTimeFilter { get; set; }
        public bool AllowDisableDateFilter { get; set; }
        public bool Disabled { get; set; }
        public string ReportValue1 { get; set; }
        public string ReportValue2 { get; set; }
        public string ParameterDescription { get; set; }
        public string SelectedValue { get; set; }
        public string SelectedText { get; set; }
        public List<ReportFilterDataSourceModel> FilterData { get; set; }
        public int FilterIndex { get; set; }
        public string FormControlName { get; set; }
        public string CheckAllFormControlName { get; set; }
        public int ParentFilterIndex { get; set; }
        public string ParentFilterValue { get; set; }
        public string ParentFilterParameterName { get; set; }
        public ReportFilterTypes ParentFilterTypeId { get; set; }

        private DateTime? _selectedDateValue;
        public DateTime? SelectedDateValue
        {
            get { return _selectedDateValue; }
            set
            {
                _selectedDateValue = value;
                if (_selectedDateValue != null)
                    SelectedDateModelValue = new DateModel(_selectedDateValue.Value);
            }
        }
        public DateModel SelectedDateModelValue { get; set; }
        public string FileName { get; set; }
        public ReportFilterModel()
        {
            QueryString = string.Empty;
            ParameterName = string.Empty;
            FilterData = new List<ReportFilterDataSourceModel>();
            FilterIndex = -1;
            ParentFilterIndex = -1;
            ReportParameterId = -1;
            ReportFilterId = -1;
            FileName = string.Empty;
            ValueMember = string.Empty;
            DisplayMember1 = string.Empty;
            DisplayMember2 = string.Empty;
        }
    }
    public class ReportFilterDataSourceModel
    {
        public ReportFilterDataSourceModel() { }
        public string BindValue { set; get; }
        public string BindLabel { set; get; }
    }
    public class KeyValueModel
    {
        public KeyValueModel(bool _isEven, string _key, string _value)
        {
            isEven = _isEven;
            Key = _key;
            Value = _value;
        }
        public string Key { set; get; }
        public string Value { set; get; }
        public bool isEven { set; get; }
    }
    public class ReportScheduleModel
    {
        public int ScheduleId { get; set; }
        public string ReportScheduleDescription { set; get; }
        public string PeriodTypeDescription { set; get; }
        public int PeriodTypeId { get; set; }
        public int ReportScheduleAssignmentId { get; set; }
        public bool SendAtFirstDayOfNextPeriod { get; set; }
        public bool IsEndOfDaySubmission { get; set; }
        public DateTime TimeToRun { get; set; }
    }

    public class EODModel
    {
        public int EmployeeId { get; set; }
        public int RouteHistoryId { get; set; }
        public int ScheduleId { get; set; }
        public DateTime ActualEnd { get; set; }
        public DateTime ActualStart { get; set;}   
    }
}
