﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class CustAppPropertiesModel
    {
        public List<TextLanguage> AboutUsLanguages { get; set; }
        public List<TextLanguage> PrivacyPolicyLanguages { get; set; }
        public string ComplaintURL { get; set; }
        public CustAppPropertiesModel()
        {
            AboutUsLanguages = new List<TextLanguage>();
            PrivacyPolicyLanguages = new List<TextLanguage>();
        }
    }
    public class ContactUsModel
    {
        public string Subject { get; set; }
        public string Message { get; set; }
        public ContactUsModel()
        {
            Subject = string.Empty;
            Message = string.Empty;
        }
    }
    public class FeedbackModel
    {
        public string Subject { get; set; }
        public string Message { get; set; }
        public string CustomerName { get; set; }
        public string CustomerCode { get; set; }
        public DateTime CreatedDate { get; set; }
        public int Id { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public string Status { get; set; }
        public int StatusId { get; set; }
        public int ReplyBy { get; set; }
        public DateTime ReplyDate { get; set; }
        public string ReplyBody { get; set; }
        public int MessageID { get; set; }
        public FeedbackModel()
        {
            CustomerCode = string.Empty;
            CustomerName = string.Empty;
            Subject = string.Empty;
            Message = string.Empty;
            Status = string.Empty;
            StatusId = -1;
            ReplyBy = -1;
            ReplyBody = string.Empty;
        }
    }
    public class FeedbackFilterModel
    {
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public List<DateModel> DateRange { get; set; }
        public CustomListFilters CustomListFilter { get; set; }

        public FeedbackFilterModel()
        {
            OutletId = -1;
            CustomerId = -1;
            DateRange = new List<DateModel>();
            CustomListFilter = new CustomListFilters();
        }
    }
    public class CustomerAppSignUpFields
    {
        public CustomerAppSignUpFieldType FieldId { get; set; }
        public bool IsMandatory { get; set; }

        public CustomerAppSignUpFields()
        {
        }
    }
    public class CustomerAppFAQs
    {
        public string Question { get; set; }
        public string Answer { get; set; }
        public CustomerAppFAQs()
        {
            Question = string.Empty;
            Answer = string.Empty;
        }
    }
}
