﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Sonic.Web.Model
{
    public class EchoOperatorLoginModel
    {
        public EchoOperatorLoginModel()
        {
            OrganizationId = -1;
        }
        [Required]
        public string UserName { get; set; }
        [Required]
        public string Password { get; set; }
        [Required]
        public string AppVersion { get; set; }
        public int OrganizationId { get; set; }
        public bool FromFlutter { get; set; }
    }

    public class EchoOperatorModel
    {
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int OperatorId { get; set; }
        public int CustomerTypeId { get; set; }
        public int MainDivisionId { get; set; }
        public string Name { get; set; }
        public string Code { get; set; }
        public string Email { get; set; }
        public string Phone { get; set; }
        public bool Active { get; set; }
        public bool Taxable { get; set; }
        public bool isMultiUser { get; set; }
        public string DivisionIds { get; set; }
        //public string OrganizationIds { get; set; }
        public int RouteEmployeeId { get; set; }
        public int RouteOperatorId { get; set; }
        public int RouteVehicleId { get; set; }
        public int RouteOrganizationId { get; set; }
        public string RouteLoadingWarehouseIds { get; set; }
        public string AppVersion { get; set; }
        public int NumberOfDigit { get; set; } 
        public int NumberOfStockDigits { get; set; } 
        public decimal EchoFirstDiscountCustomerOutlet { get; set; }
        public string CurrencyCode { get; set; }
        public string RouteEmployeeIds { get; set; }
        public string RouteOrganizationIds { get; set; }
        public string RouteVehicleIds { get; set; }
        public string CustomerOutletId { get; set; }
        public string CustomerOutletIds { get; set; }
        public List<ItemOffers> ItemOffers { get; set; }
        public List<OperatorCustomerModel> OperatorCustomers { get; set; }
        public int UnreadNotificationsCount { get; set; }
        public Decimal ICashBalance { get; set; }
        public decimal PointsBalance { get; set; }
        public decimal PointsWeight { get; set; }
        public decimal PointsConversionFactor { get; set; }
        public bool ShowOtherOutlets { get; set; }

        public EchoOperatorModel()
        {
            OperatorCustomers = new List<OperatorCustomerModel>();
            ItemOffers = new List<ItemOffers>();
            CustomerId = -1;
            ShowOtherOutlets = false;
        }

    }
    public class ItemOffers
    {
        public int ItemId { get; set; }
        public string OfferIds { get; set; }
    }
    public class OperatorCustomerModel
    {
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int RouteEmployeeId { get; set; }
        public int MainDivisionId { get; set; }
        public string CustomerName { get; set; }
        public string EmployeeName { get; set; }
        public string SupervisorName { get; set; }
        public string Phone { get; set; }
        public string EmployeePhone { get; set; }
        public string SupervisorPhone { get; set; }
        public string ChannelName { get; set; }
        public string ClassName { get; set; }
        public decimal Longitude { get; set; }
        public decimal Latitude { get; set; }
        public string location { get; set; }
        public string Address { get; set; }
        public decimal Balance { get; set; }
        public decimal CreditLimit { get; set; }
        public string NewPassword { get; set; }
        public string? Email { get; set; }

        public OperatorCustomerModel()
        {

        }
        public OperatorCustomerModel(int customerId, int outletId, int employeeId, int mainDivId)
        {
            CustomerId = customerId;
            OutletId = outletId;
            RouteEmployeeId = employeeId;
            MainDivisionId = mainDivId;
        }

    }
    public class GeneralModel
    {
        public int Id { get; set; }
        public string Code { get; set; }
        public string Name { get; set; }
    }

    public class CustomerDashboardModel
    {
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public List<Dashboard> Dashboards { get; set; }

        public CustomerDashboardModel()
        {
            Dashboards = new List<Dashboard>();
        }
    }

}
