﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class DynamicTemplateModel
    {
        public int TemplateId { get; set; }
        public string Email { get; set; }
        public string Password { get; set; }
        public string ServerAddress { get; set; }
        public string TemplateName { get; set; }
        public int ServerPort { get; set; }
        public bool InActive { get; set; }
        public bool HasAttachment { get; set; }
        public bool EnableSSL { get; set; }
        public bool AllCustomers { get; set; }
        public bool AllEmployees { get; set; }
        public List<int> DistinctLanguages { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public List<TextLanguage> DisplayNameLanguages { get; set; }
        public List<TextLanguage> SubjectLanguages { get; set; }
        public List<TextLanguage> BodyLanguages { get; set; }
        public List<SimpleCustomerModel> DynamicTemplateCustomers { get; set; }
        public List<CustomerGroupModel> DynamicTemplateGroups { get; set; }
        public List<CustomerChannelModel> DynamicTemplateChannels { get; set; }
        public List<EmployeeModel> DynamicTemplateEmployees { get; set; }
        public List<EmployeeModel> DynamicTemplateReceiverEmployees { get; set; }
        public List<SecurityGroupModel> DynamicTemplateSGs { get; set; }
        public List<SecurityGroupModel> DynamicTemplateReceiverSGs { get; set; }
        public List<DynamicTemplateReportTypeModel> EmailTypes { get; set; }
        public List<DynamicTemplateEmployeeReportTypes> EmployeeReports { get; set; }
        public DynamicTemplateEmailTypes DTEmailType { get; set; }
        public List<OrganizationModel> OrganizationsList { get; set; }
        public string EmailTypeDescription { get; set; }
        public string Status { get; set; }
        public int ReportID { get; set; }
        public string ReportDescription { get; set; }
        public string Subject { get; set; }
        public string Body { get; set; }
        public string DisplayName { get; set; }
        public string Description { get; set; }

        public DynamicTemplateModel()
        {
            TemplateId = -1;
            InActive = false;
            HasAttachment = false;
            AllCustomers = false;
            EnableSSL = false;
            DescriptionLanguages = new List<TextLanguage>();
            DisplayNameLanguages = new List<TextLanguage>();
            SubjectLanguages = new List<TextLanguage>();
            BodyLanguages = new List<TextLanguage>();
            DynamicTemplateCustomers = new List<SimpleCustomerModel>();
            DynamicTemplateGroups = new List<CustomerGroupModel>();
            DynamicTemplateChannels = new List<CustomerChannelModel>();
            DynamicTemplateEmployees = new List<EmployeeModel>();
            DynamicTemplateSGs = new List<SecurityGroupModel>();
            EmailTypes = new List<DynamicTemplateReportTypeModel>();
            DistinctLanguages = new List<int>();
            OrganizationsList = new List<OrganizationModel>();
            ReportID = -1;
            Subject = string.Empty;
            Body = string.Empty;
            DisplayName = string.Empty;
            Description = string.Empty;
        }

    }

    public class DynamicTemplateReportTypeModel
    {
        public int ReportTypeId { get; set; }
        public string ReportTypeDescription { get; set; }
        public DynamicTemplateReportTypeModel()
        {
            ReportTypeId = -1;
        }
        public DynamicTemplateReportTypeModel(int ReportTypeId, string ReportTypeDescription)
        {
            this.ReportTypeId = ReportTypeId;
            this.ReportTypeDescription = ReportTypeDescription;
        }
    }
    public class DynamicTemplateEmployeeReportTypes
    {
        public int ReportTypeId { get; set; }
        public int ReportId { get; set; }
        public string ReportTypeDescription { get; set; }
        public string ReportDescription { get; set; }
        public string Query { get; set; }
        public DynamicTemplateEmployeeReportTypes()
        {
            ReportTypeId = -1;
            ReportId = -1;
            ReportTypeDescription = String.Empty;
            ReportDescription = String.Empty;
            Query = String.Empty;
        } 
    }

    public class DynamicTemplateLanguageModel
    {
        public int TemplateId { get; set; }
        public int LanguageId { get; set; }
        public string Description { get; set; }
        public string Subject { get; set; }
        public string Body { get; set; }
        public string DisplayName { get; set; }
        public DynamicTemplateLanguageModel()
        {
            TemplateId = -1;
            LanguageId = -1;
        }

    }

    public class DynamicTemplateReportFileModel
    {
        public int ReportId { get; set; }
        public string ReportTypeId { get; set; }
        public string ReportDescription { get; set; }
        public string FileName { get; set; }
        public string Query { get; set; }
        public string ExchangeQuery { get; set; }
        public DynamicTemplateReportFileModel()
        {
            ReportId = -1;
            Query = string.Empty;
            ExchangeQuery = string.Empty;
        }

    }



}
