﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Sonic.Web.Model
{
    public class EmailTemplateModel
    {
        public int TemplateId { get; set; }
        [Required]
        public int EmailTempId { get; set; }

        [Required]
        public int EmailTypeId { get; set; }

        public string Description { get; set; }

        [Required]
        public string Name { get; set; }

        [Required]
        public string ServerAddress { get; set; }

        [Required]
        public int EmailPort { get; set; }

        [Required]
        public string Email { get; set; }

        [Required]
        public string Password { get; set; }

        [Required]
        public string Subject { get; set; }

        
        public string Body { get; set; }
        public string EmailDestination { get; set; }

        public string Status { get; set; }
        public bool MandatoryAttachement { get; set; }
        public bool EnableSSL { get; set; }
        public bool IsActive { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public List<TextLanguage> SubjectLanguages { get; set; }
        public List<TextLanguage> BodyLanguages { get; set; }
        public int DocumentTypeId { get; set; }
        public int ReceiverEmployeeID { get; set; }
        public EmailTemplateModel()
        {
            TemplateId = -1;
            DescriptionLanguages = new List<TextLanguage>();
            SubjectLanguages = new List<TextLanguage>();
            BodyLanguages = new List<TextLanguage>();
            ReceiverEmployeeID = -1;
        }
    }
    public class EmailTemplateLanguageModel
    {
        public int LanguageId { get; set; }
        public string Description { get; set; }
        public string Subject { get; set; }
        public string Body { get; set; }
    }
    public class EmailTypeModel
    {
        public int LanguageId { get; set; }
        public string Description { get; set; }
        public int EmailTypeID { get; set; }
        public bool IsExcludedTypeCRM { get; set; }
    }
}
