﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class DeviceModel
    {
        public string DeviceName { set; get; }
        public string DeviceSerial { set; get; }
        public string OldDeviceSerial { set; get; }
        public string DeviceNameSerial { set; get; }
        public int OrganizationId { set; get; }
        public bool IsNew { set; get; }
        public bool Inactive { set; get; }
        public bool DisableOrganization { set; get; }
        public int EmployeeId { get; set; }
        public string EmployeeCodeName { get; set; }
        public string ModelNumber { get; set; }
        public string Brand { get; set; }
        public string Remark { get; set; }
        public bool GetFreeDevicesOnly { get; set; }
        public bool AvailableForUsage { get; set; }
        public string OrganizationCodeName { get; set; }
        public DateModel WarrantyExpiryDateModel { get; set; }
        public DateModel PurchaseDateDateModel { get; set; }        
        public DateTime? WarrantyExpiry { get; set; }
        public DateTime? PurchaseDate { get; set; }
        public List<TextLanguage> TextLanguage { get; set; }
        public DeviceModel()
        {
            DeviceName = string.Empty;
            DeviceSerial = string.Empty;
            DeviceNameSerial = string.Empty;
            OrganizationId = -1;
            AvailableForUsage = true;
            Inactive = false;
            Brand = string.Empty;
            ModelNumber = string.Empty;
            Remark = string.Empty;
            DisableOrganization = false;
        }



    }
    public class DeviceFilter
    {
        public DeviceFilter()
        {

        }
        public int OrganizationId { set; get; }
        public int EmployeeId { get; set; }
        public bool GetFreeDevicesOnly { get; set; }


    }
}
