﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Text;

namespace Sonic.Web.Model
{
    public class EmployeeDocumentSequence
    {
        public int EmployeeId { set; get; }
        public int DivisionId { set; get; }
        public string divisionName { set; get; }
        public List<DocumentSequence> DocumentSequenceList { set; get; }


        public EmployeeDocumentSequence()
        {
            EmployeeId = -1;
            DivisionId = -1;
            divisionName = string.Empty;
            DocumentSequenceList = new List<DocumentSequence>();
        }
        public void FillEmployeeDocumentSequence(DataRow documentRow)
        {
            if (documentRow[CoreDataBaseConstants.QueryColumnsNames.DivisionID] != DBNull.Value && !string.IsNullOrEmpty(documentRow[CoreDataBaseConstants.QueryColumnsNames.DivisionID].ToString()))
            {
                DivisionId = Int32.Parse(documentRow[CoreDataBaseConstants.QueryColumnsNames.DivisionID].ToString());
            }
            DocumentSequenceList = new List<DocumentSequence>();
            foreach (var documentType in Enum.GetValues(typeof(DocumentTypes)))
            {
                DocumentSequence documentSequenceObject = new DocumentSequence();
                switch (documentType)
                {
                    case DocumentTypes.Invoice:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxTransactionInvoiceID"]);
                        documentSequenceObject.Key = DocumentTypes.Invoice.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.InvoicePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.Invoice;
                        break;

                    case DocumentTypes.Return:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxTransactionReturnID"]);
                        documentSequenceObject.Key = DocumentTypes.Return.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.ReturnPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.Return;
                        break;

                    case DocumentTypes.Order:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxTransactionOrderID"]);
                        documentSequenceObject.Key = DocumentTypes.Order.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.OrderPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.Order;
                        break;

                    case DocumentTypes.WarhouseTransaction:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxWarehouseTransactionID"]);
                        documentSequenceObject.Key = DocumentTypes.WarhouseTransaction.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.WarehouseTransactionPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.WarehouseTransaction;
                        break;

                    case DocumentTypes.CreditNote:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxTransactionCreditNote"]);
                        documentSequenceObject.Key = DocumentTypes.CreditNote.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.CreditNotePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.CreditNote;
                        break;

                    case DocumentTypes.DebitNote:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxTransactionDebitNote"]);
                        documentSequenceObject.Key = DocumentTypes.DebitNote.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.DebitNotePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.DebitNote;
                        break;

                    case DocumentTypes.Collection:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxTransactionPaymentID"]);
                        documentSequenceObject.Key = DocumentTypes.Collection.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.PaymentPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.Payment;
                        break;

                    case DocumentTypes.Sample:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxTransactionSampleID"]);
                        documentSequenceObject.Key = DocumentTypes.Sample.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.SamplePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.Sample;
                        break;

                    case DocumentTypes.NewCustomerCode:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxNewCustomerCodeID"]);
                        documentSequenceObject.Key = DocumentTypes.NewCustomerCode.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.DocumentPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.NewCustomerCode;
                        break;

                    case DocumentTypes.AppliedPayment:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxAppliedPaymentID"]);
                        documentSequenceObject.Key = DocumentTypes.AppliedPayment.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.ApplyingPaymentsPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.ApplyingPayments;
                        break;

                    case DocumentTypes.Replenish:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxTransactionReplenishID"]);
                        documentSequenceObject.Key = DocumentTypes.Replenish.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.ReplenishPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.Replenish;
                        break;

                    case DocumentTypes.Remove:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxTransactionRemoveID"]);
                        documentSequenceObject.Key = DocumentTypes.Remove.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.RemovePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.Remove;
                        break;

                    case DocumentTypes.Settelment:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxSettelmentID"]);
                        documentSequenceObject.Key = DocumentTypes.Settelment.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.SettlementPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.Settlement;
                        break;

                    case DocumentTypes.OrderInvoice:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxOrderInvoiceID"]);
                        documentSequenceObject.Key = DocumentTypes.OrderInvoice.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.OrderInvoicePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.OrderInvoice;
                        break;

                    case DocumentTypes.ReturnOrder:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxReturnOrderID"]);
                        documentSequenceObject.Key = DocumentTypes.ReturnOrder.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.ReturnOrderPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.ReturnOrder;
                        break;

                    case DocumentTypes.ContractedFOC:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxContractedFOCID"]);
                        documentSequenceObject.Key = DocumentTypes.ContractedFOC.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.ContractedFOCPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.ContractedFOC;
                        break;

                    case DocumentTypes.UnlimitedFOC:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxUnlimitedFOCID"]);
                        documentSequenceObject.Key = DocumentTypes.UnlimitedFOC.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.UnlimitedFOCPrefic;
                        documentSequenceObject.Description = DocumentSequenceDescription.UnlimitedFOC;
                        break;

                    case DocumentTypes.FixedIncentive:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxFixedIncentiveID"]);
                        documentSequenceObject.Key = DocumentTypes.FixedIncentive.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.FixedIncentivePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.FixedIncentive;
                        break;

                    case DocumentTypes.VariableIncentive:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxVariableIncentiveID"]);
                        documentSequenceObject.Key = DocumentTypes.VariableIncentive.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.VariableIncentivePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.VariableIncentive;
                        break;

                    case DocumentTypes.OrgCreditNote:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxOrgCreditNote"]);
                        documentSequenceObject.Key = DocumentTypes.OrgCreditNote.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.OrgCreditNotePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.OrgCreditNote;
                        break;

                    case DocumentTypes.OrgDebitNote:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxOrgDebitNote"]);
                        documentSequenceObject.Key = DocumentTypes.OrgDebitNote.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.OrgDebitNotePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.OrgDebitNote;
                        break;

                    case DocumentTypes.PurchaseOrder:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxPurchaseOrderID"]);
                        documentSequenceObject.Key = DocumentTypes.PurchaseOrder.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.PurchaseOrderPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.PurchaseOrder;
                        break;

                    case DocumentTypes.PrisonExpenses:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxPrisonExpensesID"]);
                        documentSequenceObject.Key = DocumentTypes.PrisonExpenses.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.PrisonExpensesPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.PrisonExpenses;
                        break;

                    case DocumentTypes.GuaranteesExpenses:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxGuaranteesExpensesID"]);
                        documentSequenceObject.Key = DocumentTypes.GuaranteesExpenses.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.GuaranteesExpensesPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.GuaranteesExpenses;
                        break;

                    case DocumentTypes.GiftVoucher:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxGiftVoucherID"]);
                        documentSequenceObject.Key = DocumentTypes.GiftVoucher.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.GiftVoucherPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.GiftVoucher;
                        break;
                    case DocumentTypes.ICashTransaction:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxICashTopUpTransactionID"]);
                        documentSequenceObject.Key = DocumentTypes.ICashTransaction.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.ICashPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.ICashTransaction;
                        break;
                    case DocumentTypes.ICashReversal:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxICashReversalTransactionID"]);
                        documentSequenceObject.Key = DocumentTypes.ICashReversal.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.ICashReversalPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.ICashReversal;
                        break;
                    case DocumentTypes.DeliveryNote:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxDeliveryNoteTransactionID"]);
                        documentSequenceObject.Key = DocumentTypes.DeliveryNote.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.DeliveryNotePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.DeliveryNote;
                        break;
                    case DocumentTypes.Promotion:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxPromotionTransactionID"]);
                        documentSequenceObject.Key = DocumentTypes.Promotion.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.PromotionPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.Promotion;
                        break;
                    case DocumentTypes.CustomerCode:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxCustomerCode"]);
                        documentSequenceObject.Key = DocumentTypes.CustomerCode.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.CustomerCodePrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.MaxCustomerCode;
                        break;
                    case DocumentTypes.CreditNoteRequest:
                        documentSequenceObject.Value = Convert.ToString(documentRow["MaxCreditNoteRequestTransactionID"]);
                        documentSequenceObject.Key = DocumentTypes.CreditNoteRequest.GetHashCode();
                        documentSequenceObject.Prefix = DocumentSequencePrefixes.CreditNoteRequestPrefix;
                        documentSequenceObject.Description = DocumentSequenceDescription.CreditNoteRequest;
                        break;
                }
                DocumentSequenceList.Add(documentSequenceObject);
            }
        }
    }
}
