﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using InCube.Security;

namespace Sonic.Web.Model
{
    public class EmployeeModel
    {
        private string _emplyeeName;
        private int _employeeId = -1;
        public int EmployeeId
        {
            get
            {
                if (_employeeId == -1 && !string.IsNullOrEmpty(EmployeeIdSignature))
                {
                    _employeeId = int.Parse(EncryptionManager.Instance.DecryptData(EmployeeIdSignature));
                }
                return _employeeId;
            }
            set
            {
                _employeeId = value;
                EmployeeIdSignature = EncryptionManager.Instance.EncryptData(_employeeId.ToString());
            }
        }
        public string EmployeeIdSignature { get; set; }
        public string EmployeeName
        {
            get
            {
                return _emplyeeName;
            }

            set
            {
                if (string.IsNullOrEmpty(value))
                    this._emplyeeName = "---";
                else
                    this._emplyeeName = value;
            }
        }
        public string EmployeeCode { get; set; }
        public string EmployeeCodeName { get; set; }
        public string EmployeeName_Code { get; set; }
        public int AccountId { get; set; }
        public AccountModel Account { set; get; }

        public bool IsNewEmployee { set; get; }
        public string Phone { get; set; }
        public string Mobile { get; set; }
        public string Email { get; set; }
        public string NationalIDNumber { get; set; }
        public int OrganizationId { get; set; }
        public string OrganizationName { get; set; }
        public string OrganizationCode { get; set; }
        public string OrganizationCodeName { get; set; }
        public int EmployeeTypeId { get; set; }
        public string EmployeeTypeName { get; set; }
        public string DeviceToken { get; set; }
        public bool OnHold { get; set; }
        public bool Inactive { get; set; }
        public bool EmployeeAccess { get; set; }
        public string Status { get; set; }
        public bool OutSource { get; set; }

        public List<DivisionModel> Divisions { get; set; }
        public int DefaultDivisionId { get; set; }
        public string DeviceSerial { get; set; }
        public int DriverId { get; set; }
        public int HelperId { get; set; }
        public int VehicleId { get; set; }
        public int WarehouseId { get; set; }
        public int TruckId { get; set; }
        public int RelatedEmployeeTypeId { get; set; }
        public int RelatedEmployeeId { get; set; }
        public int OldRelatedEmployeeId { get; set; }
        public int TerritoryId { get; set; }

        public bool IsFrontOfficUser { get; set; }
        public bool IsActiveDirectoryLogin { get; set; }
        public string OperatorName { get; set; }
        public string OrganizationAccess { get; set; }
        public string DivisionAccess { get; set; }
        public string OperatorPassword { get; set; }
        public string ConfirmPassword { get; set; }
        public string OldPassword { get; set; }
        public int OperatorId { get; set; }
        public int ChannelId { get; set; }
        public int ContactCountryId { get; set; }
        public int EmployeeBranchId { get; set; }
        public string EmployeeBranchName { get; set; }
        public int OutletId { get; set; }
        public int CustomerId { get; set; }
        public int RegionId { get; set; }
        public bool IsOperatorLinkedWithOperatorPrivilege { set; get; }
        public bool AllowToChangePassword { set; get; }
        public bool IsBOUser { set; get; }
        public string CustomerID_OutletID  { set; get; }
        public List<SecurityGroupModel> SecurityGroups { get; set; }
        public List<EmployeeDocumentSequence> EmployeeDocumentSequenceList { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public List<OrganizationModel> OrganizationsAccessList { get; set; }
        public List<AccountModel> AccountsDivision { get; set; }
        public DateTime ExpirationDate { get; set; }
        public string NewCustomerCode { get; set; }
        public string MaxCustomerCode { get; set; }
        public int StatusReasonId { get; set; }
        public int OldStatusReasonId { get; set; }
        public bool OldInactiveStatus { get; set; }
        public string ImageUserProfilePath { get; set; }
        public bool IsActive { get; set; }
        public string OrganizationIds { get; set; }
        public bool IsInternetConnected { get; set; }
        public List<SalesDistributionChannelModel> SalesChannelDocumentSequenceList { get; set; }
        public List<ItemListModel> ItemsList { get; set; }


        public EmployeeModel()
        {
            IsOperatorLinkedWithOperatorPrivilege = false;
            OperatorId = -1;
            ChannelId = -1;
            ContactCountryId = -1;
            EmployeeBranchId = -1;
            RegionId = -1;
            CustomerId = -1;
            AccountId = -1;
            _employeeId = -1;
            OrganizationId = -1;
            EmployeeTypeId = -1;
            DriverId = -1;
            HelperId = -1;
            VehicleId = -1;
            WarehouseId = -1;
            TruckId = -1;
            TerritoryId = -1;
            RelatedEmployeeId = -1;
            RelatedEmployeeTypeId = -1;
            Divisions = new List<DivisionModel>();
            SecurityGroups = new List<SecurityGroupModel>();
            EmployeeDocumentSequenceList = new List<EmployeeDocumentSequence>();
            DescriptionLanguages = new List<TextLanguage>();
            Account = new AccountModel();
            AllowToChangePassword = true;
            OrganizationsAccessList = new List<OrganizationModel>();
            AccountsDivision = new List<AccountModel>();
            StatusReasonId = -1;
            OldStatusReasonId = -1;
            OldInactiveStatus = false;
            ImageUserProfilePath = string.Empty;
            OldRelatedEmployeeId = -1;
            IsActive = false;
            IsInternetConnected = false;
            SalesChannelDocumentSequenceList = new List<SalesDistributionChannelModel>();
        }
    }

    public class EmployeeTypeModel
    {
        public string EmployeeTypeName { set; get; }
        public int EmployeeTypeId { set; get; }

        public EmployeeTypeModel()
        {
            EmployeeTypeName = string.Empty;
            EmployeeTypeId = -1;
        }
    }

    public class EmployeeFilter
    {
        public CustomListFilters CustomListFilter { get; set; }
        public int EmployeeTypeId { set; get; }
        public int OrganizationId { set; get; }
        public string MultiOrganizationId { set; get; }
        public int VehicleId { set; get; }
        public int DivisionId { set; get; } 
        public int EmployeeBranchId { set; get; }
        public int EmployeeId { set; get; }
        public int RouteId { set; get; }
        public int RegionId { set; get; }
        public int ChannelId { set; get; }
        public int LanguageId { set; get; }
        public bool FilterOnRoute { get; set; }
        public bool IncludeInactive { set; get; }
        public List<EmployeeTypes> EmployeeTypes { set; get; }
        public string DeviceSerial { set; get; }
        public int SecurityGroupId { set; get; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public bool HasTerritories { get; set; }
        public bool HasVehicles { get; set; }
      public bool IsFOEmployee {get; set;}
        public bool ExcludeOnholdEmployee { get; set;}
        public bool IsAllEmployeesFieldAvailable { get; set; }
        public bool isExceptSelectedEmployees { get; set; }
        public int salesManagerId { get; set; }
        public int supervisorId { get; set; }
        public int TerritoryId { get; set; }
        public EmployeeTypes EmployeeType { get; set; }
        public bool GetEmployeesHavingOrdersFromInvoiced { get; set; }
        public bool GetEmployeesHavingOrdersFromApproved { get; set; }
        public bool GetEmployeesHavingOrdersFromReschedule { get; set; }


        public string TerritoryIds { get; set; }
        public EmployeeFilter()
        {
            EmployeeTypeId = -1;
            OrganizationId = -1;
            EmployeeBranchId = -1;
            VehicleId = -1;
            DivisionId = -1;
            EmployeeId = -1;
            RegionId = -1;
            ChannelId = -1;
            salesManagerId = -1;
            supervisorId = -1;
            TerritoryId = -1;
            IncludeInactive = false;
            EmployeeTypes = new List<EmployeeTypes>();
            CustomListFilter = new CustomListFilters();
            DeviceSerial = string.Empty;
            isExceptSelectedEmployees = false;
            MultiOrganizationId = string.Empty;
            TerritoryIds = string.Empty;
            GetEmployeesHavingOrdersFromInvoiced = false;
            GetEmployeesHavingOrdersFromApproved = false;
            GetEmployeesHavingOrdersFromReschedule = false;
        }
    }

    public class ChattingAssignmentModel
    {
        public int SelectedUserId { get; set; }
        public int AddedUserId { get; set; }
        public int SelectedSecurityGroupId { get; set; }
        public int AddedSecurityGroupId { get; set; }
        //public int DataAction { get; set; } // 1 - Add, 2 - Remove

        public ChattingAssignmentModel()
        {
            SelectedUserId = -1;
            SelectedSecurityGroupId = -1;
            AddedUserId = -1;
            AddedSecurityGroupId = -1;
        }


    }

    public class ContactCountryModel
    {
        public int ContactCountryId { get; set; }
        public string ContactCountryPrefixCode { get; set; }
    }
}