﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class KeyTypeModel
    {
        public EmployeeKeysCreationSources CreationSourceId { get; set; }
        public KeyTypes KeyTypeId { get; set; }
        public bool NotCusotmerRelatedKey { get; set; }
        public string KeyName { get; set; }
        public string KeyDescription { get; set; }
    }

    public class EmployeeKeyModel
    {
        public string ProvidedKey { get; set; }
        public string ProvidedBy { get; set; }
        public string OutletName { get; set; }
        public string Note { get; set; }
        public DateTime ProvidedDate { get; set; }
        public string KeyValue { get; set; }
        public string Description { get; set; }
        public int RouteHistoryId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int EmployeeId { get; set; }
        public string Employee { get; set; }
        public string SecurityGroup { get; set; }
        public int SecurityGroupId { get; set; }
        public string EmployeeName { get; set; }
        public string CustomerName { get; set; }
        public string KeyName { get; set; }
        public bool NotCusotmerRelatedKey { get; set; }
        public bool IsOnline { get; set; }
        public int EmployeeKeysNotifictaionStatus { get; set; }
        public string NotificationId { get; set; }
        public KeyTypes KeyTypeId { get; set; }
        public List<KeyTypeModel> KeyTypes { get; set; }
        public EmployeeKeyModel()
        {
            RouteHistoryId = -1;
            CustomerId = -1;
            OutletId = -1;
            EmployeeId = -1;
            SecurityGroupId = -1;
            Employee = string.Empty;
            SecurityGroup = string.Empty;
            KeyTypes = new List<KeyTypeModel>();
        }
    }

    public class EmployeeKeyFilter : CustomListFilters
    {
        public int EmployeeId { get; set; }
        public EmployeeKeysCreationSources CreationSourcesId { get; set; }
        public string NotificationId { get; set; }
        public KeyTypes? KeyTypeId { get; set; }
        public string keyTypes { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public bool IsOnline { get; set; }

        public EmployeeKeyFilter()
        {
            CustomerId = -1;
            OutletId = -1;
            EmployeeId = -1;
            IsOnline = false;
        }
    }

    public class EmployeeKeysOnline
    {
        public string MessageID { get; set; }
        public string MessageBody { get; set; }
        public string EmployeeName { get; set; }
        public string SendEmployeeKey { get; set; }
        public int CustomerID { get; set; }
        public int KeyTypeID { get; set; }
        public int EmployeeID { get; set; }
        public string SenderDeviceToken { get; set; }
        public int OutletID { get; set; }
        public string OutletName { get; set; }
        public string CustomerName { get; set; }
        public bool IsBOReceiver { get; set; }
        public bool IsBOSender { get; set; }
        public string OutletCode { get; set; }
        public string CustomerCode { get; set; }
        public EditPriceKeyMode EditPriceKeyMode { get; set; }

    }
}
