﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public enum WebFormType
    {
        List = 1,
        Entry = 2
    }
    public enum WebFormColumnType
    {
        Text = 1,
        Integer = 2,
        NumberInDigitsFormat = 3,
        NumberInStockDigitsFormat = 4,
        Date = 5,
        DateTime = 6,
        Boolean = 7
    }
    public enum WebFormFilterType
    {
        Text = 1,
        Date = 2,
        DateRange = 3,
        DropDown = 4,
        MultiSelectDropDown = 5,
        Boolean = 6
    }
    public enum WebFormControlType
    {
        Text = 1,
        DescriptionText = 2,
        Integer = 3,
        NumberOfDigits = 4,
        NumberOfStockDigits = 5,
        Date = 6,
        DateRange = 7,
        DropDown = 8,
        MultiSelectDropDown = 9,
        Boolean = 10,
        SCOPE_IDENTITY = 11,
        Percentage = 12,
        DisabledText = 13,
        TextArea = 14,
    }
    public enum WebFormValidation
    {
        None = 0,
        Required = 1,
        Unique = 2,
        RequiredUnique = 3,
        RequiredNonZero = 4,
        Email = 5,
        RequiredEmail = 6
    }
    public enum WebBuiltInFilters
    {
        None = 0,
        Employee = 1,
        Organization = 2,
        Bank = 3
    }
    public enum DateDefaultValue
    {
        CurrentDay = 1,
        CurrentYear = 2,
        CurrentMonth = 3,
        CurrentWeek = 4,
        MonthToday = 5,
        YearToday = 6,
        WeekToday = 7
    }
}