﻿using System;
using System.Reflection;

namespace Sonic.Web.Model
{
    public class CoreDataBaseConstants
    {
        #region [Queries]

        public static string CustOutAccountOrgAccessFilterQuery = @"  INNER JOIN AccountCust ON {0}.CustomerID = AccountCust.CustomerID
                     INNER JOIN Account ON AccountCust.AccountID = Account.AccountID and Account.OrganizationID in ({1}) ";

        public static string CustAccountOrgAccessFilterQuery = @" INNER JOIN AccountCustOut ON {0}.CustomerID = AccountCustOut.CustomerID and {0}.OutletID = AccountCustOut.OutletID
                     INNER JOIN Account ON AccountCustOut.AccountID = Account.AccountID and Account.OrganizationID in ({1}) ";

        public const string CustOutConfigurationLevelFilterQuery = @"Declare @t table (ConfigurationID int, CustomerID int, OutletID int ,KeyValue nvarchar(10), rowNumber int )
                                         Insert into @t
                                         select cc.ConfigurationID, cc.CustomerID, cc.OutletID, cc.KeyValue,cc.rowNumber from (
                                         select tt.ConfigurationID, tt.CustomerID, tt.OutletID, tt.KeyValue,
                                         row_number ( )  OVER (PARTITION BY tt.customerid,tt.outletid ORDER BY tt.Priority ASC) AS rowNumber from
                                         (
                                         select CCO.ConfigurationID,  CCO.CustomerID ,CCO.OutletID , CCO.KeyValue, 1 Priority from ConfigurationCustOut CCO
                                         INNER JOIN Customer C on C.CustomerID = CCO.CustomerID
                                         INNER JOIN CustomerOutlet CO on CO.CustomerID = CCO.CustomerID AND CO.OutletID = CCO.OutletID
                                         WHERE KeyName = ('{0}')
                                         union
                                         select ConfigurationID,COG.CustomerID, COG.OutletID ,KeyValue, 2 Priority
                                         from ConfigurationCustomerGroup CCG
                                         INNER JOIN CustomerGroup CG on CG.GroupID = CCG.GroupID
                                         INNER JOIN CustomerOutletGroup COG on COG.GroupID = CCG.GroupID
                                         WHERE KeyName = ('{0}')
                                         union
                                         select
                                         CC.ConfigurationID, COG.CustomerID, COG.OutletID ,CC.KeyValue, 3 Priority from ConfigurationChannel CC
                                         INNER JOIN Channel C on CC.ChannelID = C.ChannelID
                                         INNER JOIN SubChannel SC on SC.ChannelID = C.ChannelID AND CC.SubChannelID = SC.SubChannelID
                                         INNER JOIN CustomerGroup CG on CG.SubChannelID = SC.SubChannelID and CG.ChannelID = C.ChannelID
                                         INNER JOIN CustomerOutletGroup COG on COG.GroupID = CG.GroupID
                                         WHERE KeyName = ('{0}')) as tt ) cc
                                         WHERE cc.rowNumber =  1";

        public const string OrgParentsQuery = @"DECLARE @OrgId INT = {0};
                    DECLARE @OrganizationTemp TABLE (OrganizationID INT PRIMARY KEY);
					WHILE @OrgId IS NOT NULL
					BEGIN
			    	INSERT INTO @OrganizationTemp VALUES (@OrgId);
					SET @OrgId = (
       				SELECT ParentOrganizationID
					FROM Organization
					WHERE OrganizationID = @OrgId);
					END";

        public const string OrgChildQuery = @"DECLARE @ParentOrgId INT = {0};
                        DECLARE @ChildOrganizations TABLE (OrganizationID INT PRIMARY KEY);
						INSERT INTO @ChildOrganizations (OrganizationID)
						VALUES (@ParentOrgId);
						DECLARE @RowCount INT = 1;
						WHILE @RowCount > 0
						BEGIN
							INSERT INTO @ChildOrganizations (OrganizationID)
							SELECT o.OrganizationID
							FROM Organization o
							JOIN @ChildOrganizations c ON o.ParentOrganizationID = c.OrganizationID
							WHERE o.ParentOrganizationID IS NOT NULL
							AND o.OrganizationID NOT IN (SELECT OrganizationID FROM @ChildOrganizations);
							SET @RowCount = @@ROWCOUNT;
						END";
        #endregion

        public static bool ForceOrganizationSelectionOnLogin = false;

        public static void CacheCustomerOrganozationQueries()
        {
            try
            {
                if (ForceOrganizationSelectionOnLogin)
                {
                    CustOutAccountOrgAccessFilterQuery = @" INNER JOIN (select {1} As OrganizationID) forceSingleOrg on forceSingleOrg.OrganizationID = {0}.OrganizationID ";
                    CustAccountOrgAccessFilterQuery = @" INNER JOIN (select {1} As OrganizationID) forceSingleOrg on forceSingleOrg.OrganizationID = {0}.OrganizationID ";
                }
                else
                {                    
                    CustAccountOrgAccessFilterQuery = @"  INNER JOIN AccountCust ON {0}.CustomerID = AccountCust.CustomerID
                     INNER JOIN Account ON AccountCust.AccountID = Account.AccountID and Account.OrganizationID in ({1}) ";
                    CustOutAccountOrgAccessFilterQuery = @" INNER JOIN AccountCustOut ON {0}.CustomerID = AccountCustOut.CustomerID and {0}.OutletID = AccountCustOut.OutletID
                     INNER JOIN Account ON AccountCustOut.AccountID = Account.AccountID and Account.OrganizationID in ({1}) ";
                }
            }
            catch (Exception ex)
            {
                //ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public class QueryColumnsNames
        {
            //General COLUMNS
            public const string LanguageID = "LanguageID";
            //<><><><><><><><><><><><><><><><><><><><><><><><><><><>
            //Menu Columns
            public const string MenuID = "MenuID";
            //ECHO NOTIFICATIONS COLUMNS
            public const string NotificationId = "NotificationId";
            //Proof Methods
            public const string ProofMethodID = "ProofMethodID";
            public const string ProofMethodTypeID = "ProofMethodTypeID";
            public const string MaxValue = "MaxValue";
            public const string MinValue = "MinValue";
            public const string CreatedBy = "CreatedBy";
            public const string CreatedDate = "CreatedDate";
            public const string UpdatedBy = "UpdatedBy";
            public const string UpdatedDate = "UpdatedDate";
            public const string DocumentTypeID = "DocumentTypeID";
            public const string IsBeforeSaving = "IsBeforeSaving";
            public const string IsAdded = "IsAdded";
            //CUSTOMER COLUMNS
            public const string OperatorId = "OperatorId";
            public const string OperatorName = "OperatorName";
            public const string OrderID = "OrderID";
            public const string IMEI = "IMEI";
            public const string SerialNumber = "SerialNumber";
            public const string CustomerName = "CustomerName";
            public const string CustomerID = "CustomerID";
            public const string OutletID = "OutletID";
            public const string ExportCustomer = "ExportCustomer";
            public const string CustomerCode = "CustomerCode";
            public const string Barcode = "Barcode";
            public const string OutletCode = "OutletCode";
            public const string Phone = "Phone";
            public const string Number = "Number";
            public const string OutletName = "OutletName";
            public const string OutletCodeName = "OutletCodeName";
            public const string CustomerTypeID = "CustomerTypeID";
            public const string OutletPaymenTermID = "OutletPaymenTermID";
            public const string DivisionPaymenTermID = "DivisionPaymenTermID";
            public const string CustomerClassID = "CustomerClassID";
            public const string CustomerSubClassID = "CustomerSubClassID";
            public const string CreditReleaseID = "CreditReleaseID";
            public const string AssignmentID = "AssignmentID";
            public const string ChangeHistoryID = "ChangeHistoryID";
            //<><><><><><><><><><><><><><><><><><><><><><><><><><><>
            //TRANSACTION COLUMNS
            public const string TransactionID = "TransactionID";
            public const string SalesMode = "SalesMode";
            public const string DivisionID = "DivisionID";
            public const string TransDivisionID = "TransDivisionID";
            public const string WhTransDivisionID = "WhTransDivisionID";
            public const string TransactionMainTypeID = "TransactionMainTypeID";
            public const string TransactionWarehouseID = "TransactionWarehouseID";
            public const string Voided = "Voided";
            public const string NetTotal = "NetTotal";
            public const string CustomerTransactionTypeID = "CustomerTransactionTypeID";
            public const string CurrencyID = "CurrencyID";
            public const string TransactionDate = "TransactionDate";
            public const string AppliedAmount = "AppliedAmount";
            public const string RemainingAmount = "RemainingAmount";
            public const string TransactionTypeID = "TransactionTypeID";
            public const string TransactionRouteHistoryID = "TransactionRouteHistoryID";
            public const string CreationReason = "CreationReason";
            public const string IsTransRemainingAffected = "IsTransRemainingAffected";
            //<><><><><><><><><><><><><><><><><><><><><><><><><><><>
            //WAREHOUSETRANSACTION COLUMNS
            public const string WhTrWarehouseID = "WhTrWarehouseID";
            public const string WarehouseTransactionTypeID = "WarehouseTransactionTypeID";
            public const string RefWarehouseID = "RefWarehouseID";
            public const string WarehouseID = "WarehouseID";
            public const string WarehouseTransactionStatusID = "WarehouseTransactionStatusID";
            public const string WarehouseTransactionDate = "WarehouseTransactionDate";
            public const string PackID = "PackID";
            public const string ItemID = "ItemID";
            public const string ItemDescription = "ItemDescription";
            public const string ItemCode = "ItemCode";
            public const string ItemName = "ItemName";
            public const string PackCode = "PackCode";
            public const string QuantityChange = "QuantityChange";
            public const string InStock = "InStock";
            public const string Quantity = "Quantity";
            public const string AvailableQuantity = "AvailableQuantity";
            public const string BatchNo = "BatchNo";
            public const string ExpiryDate = "ExpiryDate";
            public const string ZoneID = "ZoneID";
            public const string PiecesInPack = "PiecesInPack";
            public const string OriginalInPieces = "OriginalInPieces";
            public const string IsMinusStock = "IsMinusStock";
            public const string PackQuantity = "PackQuantity";
            public const string WhQuantity = "WhQuantity";
            public const string StockStatusID = "StockStatusID";
            public const string RestrictionPriorities = "RestrictionPriorities";
            public const string SalesRestrictionId = "SalesRestrictionId";
            //<><><><><><><><><><><><><><><><><><><><><><><><><><><>
            //ACCOUNT COLUMNS
            public const string AccountID = "AccountID";
            public const string OrganizationID = "OrganizationID";
            public const string AccountName = "AccountName";
            public const string AccountTypeID = "AccountTypeID";
            public const string AccountTypeDescription = "AccountTypeDescription";
            public const string CreditLimit = "CreditLimit";
            public const string Balance = "Balance";
            public const string GL = "GL";
            public const string CurrencyDescription = "CurrencyDescription";
            public const string OrganizationDescription = "OrganizationDescription";
            public const string ParentAccountID = "ParentAccountID";
            //<><><><><><><><><><><><><><><><><><><><><><><><><><><>
            // CUSTOMER COLUMNS
            public const string SubChannelID = "SubChannelID";
            public const string GroupID = "GroupID";
            // Employee data COLUMNS
            public const string HelperID = "HelperID";
            public const string DriverID = "DriverID";
            public const string SupervisorID = "SupervisorID";
            public const string SalesRepID = "SalesRepID";
            public const string EmployeeID = "EmployeeID";
            public const string Description = "Description";
            public const string HeaderDescription = "HeaderDescription";
            public const string BodyDescription = "BodyDescription";
            public const string Email = "Email";
            public const string InActive = "InActive";
            public const string Address = "Address";
            public const string Address2 = "Address2";
            public const string Landmark = "Landmark";
            public const string Employee = "Employee";
            public const string ChannelID = "ChannelID";
            public const string ChannelCode = "ChannelCode";
            public const string TemplateID = "TemplateID";
            public const string TemplateCode = "TemplateCode";
            public const string Uploaded = "Uploaded";
            public const string EmployeeCodeName = "EmployeeCodeName";
            //<><><><><><><><><><><><><><><><><><><><><><><><><><><>
            // Payment COLUMNS
            public const string CustomerPaymentID = "CustomerPaymentID";
            public const string CustomerAccountCurrnecyID = "CustomerAccountCurrnecyID";
            public const string PaymentStatusID = "PaymentStatusID";
            public const string PaymentRouteHistoryID = "PaymentRouteHistoryID";
            public const string PaymentCurrencyID = "PaymentCurrencyID";
            public const string VoucherDate = "VoucherDate";
            public const string PaymentTypeID = "PaymentTypeID";
            public const string SourceTransactionID = "SourceTransactionID";
            public const string PaymentEmployeeID = "PaymentEmployeeID";
            public const string Posted = "Posted";
            public const string PaymentTermID = "PaymentTermID";
            public const string Code = "Code";
            public const string StartDate = "StartDate";
            public const string EndDate = "EndDate";
            public const string Type = "Type";
            public const string Value = "Value";
            public const string Inactive = "Inactive";
            //<><><><><><><><><><><><><><><><><><><><><><><><><><><>
            // Price List COLUMNS
            public const string PriceListCode = "PriceListCode";
            // Discount COLUMNS
            public const string DiscountCode = "DiscountCode";

            // HeaderDiscount COLUMNS
            public const string HeaderDiscountID = "HeaderDiscountID";

            //ItemGroup COLUMNS
            public const string ItemGroupID = "ItemGroupID";

            //LOV COLUMNS
            public const string LOVID = "LOVID";

            //LOVOption COLUMNS
            public const string LOVOptionID = "LOVOptionID";

            // Promotion COLUMNS
            public const string DiscountValue = "DiscountValue";
            public const string PriceValue = "PriceValue";

            // SALES ORDER COLUMNS
            public const string SourceOrderID = "SourceOrderID";
            public const string PaymentReferenceNumber = "PaymentReferenceNumber";
            //<><><><><><><><><><><><><><><><><><><><><><><><><><><>
            // Route COLUMNS
            public const string RouteID = "RouteID";
            public const string Week = "Week";
            public const string Saturday = "Saturday";
            public const string Sunday = "Sunday";
            public const string Monday = "Monday";
            public const string Tuesday = "Tuesday";
            public const string Wednesday = "Wednesday";
            public const string Thursday = "Thursday";
            public const string Friday = "Friday";
            public const string EstimatedStart = "EstimatedStart";
            public const string EstimatedEnd = "EstimatedEnd";
            // Activation Deactivation Reason
            public const string ReasonId = "ReasonId";

            public const string CommissionID = "CommissionID";
            public const string CommissionCode = "CommissionCode"; 
            public const string PlanId = "PlanId"; 
            public const string CommissionCalculationId = "CommissionCalculationId";

            public const string MustSellItemCode = "MustSellItemCode";

            public const string MultiOrdersCaption = "Multi-Orders";
            public const string BrandListCode = "BrandListCode";
            public const string PayerCode = "PayerCode";
            public const string IsAttachmentExists = "IsAttachmentExists";
            //<><><><><><><><><><><><><><><><><><><><><><><><><><><>
            // ZATCA
            public const string ReturnReason = "ReturnReason";
            public const string IsBusinessCustomer = "IsBusinessCustomer";
            public const string SalesTransactionIDS = "SalesTransactionIDS";
            public const string Tax = "Tax";
            public const string Discount = "Discount";
            public const string TaxPercentage = "TaxPercentage";
            public const string BaseTaxPercentage = "BaseTaxPercentage";
            public const string TradeLicenceNumber = "TradeLicenceNumber";
            public const string StreetName = "StreetName";
            public const string BuildingNumber = "BuildingNumber";
            public const string CityName = "CityName";
            public const string PostalCode = "PostalCode";
            public const string AreaName = "AreaName";
            public const string TaxNumber = "TaxNumber";
            public const string Price = "Price";
            public const string PrivateKey = "PrivateKey";
            public const string CSR = "CSR";
            public const string PublicKey = "PublicKey";
            public const string SecretKey = "SecretKey";
            public const string StandardInvoicePIH = "StandardInvoicePIH";
            public const string SimplifiedInvoicePIH = "SimplifiedInvoicePIH";
            public const string MaxStandardInvoiceID = "MaxStandardInvoiceID";
            public const string MaxSimplifiedInvoiceID = "MaxSimplifiedInvoiceID";
            public const string MaxStandardCreditNoteID = "MaxStandardCreditNoteID";
            public const string StandardCreditNotePIH = "StandardCreditNotePIH";
            public const string MaxSimplifiedCreditNoteID = "MaxSimplifiedCreditNoteID";
            public const string SimplifiedCreditNotePIH = "SimplifiedCreditNotePIH";
            public const string ExciseTax = "ExciseTax";

        }
        public class TableNames
        {
            public const string SerialCurrentStatus = "SerialCurrentStatus";
            public const string SerialCurrentStatusArchive = "SerialCurrentStatusArchive";
            public const string EchoNotifications = "EchoNotifications";
            public const string Operator = "Operator";
            public const string Pack = "Pack";
            public const string PromotionOptionDetailGroupTemp = "PromotionOptionDetailGroupTemp";
            public const string PromotionOptionDetailGroup = "PromotionOptionDetailGroup";
            public const string PromotionOptionDetailTemp = "PromotionOptionDetailTemp";
            public const string PromotionOptionDetail = "PromotionOptionDetail";
            public const string PromotionBenefitDetailGroup = "PromotionBenefitDetailGroup";
            public const string PromotionBenefitDetailGroupTemp = "PromotionBenefitDetailGroupTemp";
            public const string VehicleLoadingWh = "VehicleLoadingWh";
            public const string VehicleDamagedWh = "VehicleDamagedWh";
            public const string VehicleOffloadingWh = "VehicleOffloadingWh";
            public const string EmployeeDriver = "EmployeeDriver";
            public const string EmployeeHelper = "EmployeeHelper";
            public const string AccountEmp = "AccountEmp";
            public const string Transaction = "[Transaction]";
            public const string TestTransaction = "TestTransaction";
            public const string TestTransactionDetail = "TestTransactionDetail";
            public const string Route = "[Route]";
            public const string Account = "Account";
            public const string VoidedTransaction = "VoidedTransaction";
            public const string WarehouseStockHistory = "WarehouseStockHistory";
            public const string WarehouseStockHistoryArc = "WarehouseStockHistoryArc";
            public const string TransactionDetail = "TransactionDetail";
            public const string CustomerPayment = "CustomerPayment";
            public const string SalesOrder = "SalesOrder";
            public const string SalesOrderDetail = "SalesOrderDetail";
            public const string SalesOrderNote = "SalesOrderNote";
            public const string Contact = "Contact";
            public const string WhTransDetail = "WhTransDetail";
            public const string RouteCustomer = "RouteCustomer";
            public const string CustOutTerritory = "CustOutTerritory";
            public const string CustomerOutletLanguage = "CustomerOutletLanguage";
            public const string CustomerOutletDivision = "CustomerOutletDivision";
            public const string CustomerPromotion = "CustomerPromotion";
            public const string CustomerPrice = "CustomerPrice";
            public const string CustomerStatus = "CustomerStatus";
            public const string POSCustomerOutlet = "POSCustomerOutlet";
            public const string POSCustomerOutletCapacity = "POSCustomerOutletCapacity";
            public const string RouteHistoryDetail = "RouteHistoryDetail";
            public const string RouteNewCustomer = "RouteNewCustomer";
            public const string EmployeeKeyHistory = "EmployeeKeyHistory";
            public const string CustomerOutletGroup = "CustomerOutletGroup";
            public const string CustomerOutletAccess = "CustomerOutletAccess";
            public const string CustOutExtraInfo = "CustOutExtraInfo";
            public const string SDPreviousVisit = "SDPreviousVisit";
            public const string CustomerUnallocatedPayment = "CustomerUnallocatedPayment";
            public const string AccountLanguage = "AccountLanguage";
            public const string AccountTypeLanguage = "AccountTypeLanguage";
            public const string CurrencyLanguage = "CurrencyLanguage";
            public const string OrganizationLanguage = "OrganizationLanguage";
            public const string Customer = "Customer";
            public const string CustomerGroup = "CustomerGroup";
            public const string CustomerOutlet = "CustomerOutlet";
            public const string CustomerOutletContact = "CustomerOutletContact";
            public const string CustomerLanguage = "CustomerLanguage";
            public const string CustomerClass = "CustomerClass";
            public const string CustomerSubClass = "CustomerSubClass";
            public const string PaymentTerm = "PaymentTerm";
            public const string CreditRelease = "CreditRelease";
            public const string CreditReleaseAssignment = "CreditReleaseAssignment";
            public const string CreditReleaseHistory = "CreditReleaseHistory";
            public const string MachineDefinition = "MachineDefinition";
            public const string PriceList = "PriceList";
            public const string PriceList_Pending = "PriceList_Pending";
            public const string Discount = "Discount";
            public const string HeaderDiscount = "HeaderDiscount";
            public const string EmployeeChannelDefinition = "EmployeeChannelDefinition";
            public const string BarcodeTemplate = "BarcodeTemplate";
            public const string LOV = "LOV";
            public const string LOVOption = "LOVOption";
            public const string RouteVisitPattern = "RouteVisitPattern";
            public const string ActivationReason = "ActivationReason";
            public const string DeactivationReason = "DeactivationReason";
            public const string CustomerPromotionExclusion = "CustomerPromotionExclusion";
            public const string CommissionHeader = "CommissionHeader";
            public const string CommissionPlanHeader = "CommissionPlanHeader";
            public const string CommissionCalculationHeader = "CommissionCalculationHeader";
            public const string MustSellItem = "MustSellItem";
            public const string BrandsList = "BrandsList";
            public const string Payer = "Payer";
            public const string ICashHistory = "ICashHistory";
            public const string ICashBalance = "ICashBalance";
            public const string ICashTransactionDetails = "ICashTransactionDetails";
            public const string AccumulativePromotionsHistory = "AccumulativePromotionsHistory";
            public const string TestAccumulativePromotionsHistory = "TestAccumulativePromotionsHistory";
            public const string PromotionBenefitHistory = "PromotionBenefitHistory";
            public const string TestPromotionBenefitHistory = "TestPromotionBenefitHistory";
            public const string PromPrerequisitesHistory = "PromPrerequisitesHistory";
            public const string TestPromPrerequisitesHistory = "TestPromPrerequisitesHistory";
            public const string CustomerPromotionsAccumulation = "CustomerPromotionsAccumulation";
            public const string ProductDiscountBenefits = "ProductDiscountBenefits";
            public const string TestProductDiscountBenefits = "TestProductDiscountBenefits";
            public const string PromBenefitSequenceDetail = "PromBenefitSequenceDetail";
            public const string TestPromBenefitSequenceDetail = "TestPromBenefitSequenceDetail";
        }
        public class CharactersAndDataTypes
        {
            public const string ISNULLCheck = "isnull";
            public const string HTMLBreakLine = "<br>";
        }
        public class WebMenusConstants
        {
            // ROI Screens
            public const string DamagedStock = "1800-002-01";
            public const string ManufacturingDefects = "1800-002-02";
            public const string Incoming = "1800-002-03";
            public const string IncomingReturns = "1800-002-04";
            public const string IncommingWithoutRef = "1800-002-05";
            public const string IncommingReturnsWithoutRef = "1800-002-06";
        }

        public class ProceduresConstants
        {
            public const string ReplaceWhTransactionBatches = "SP_ReplaceWhTransactionBatches";
            // ROI Procedures
            public const string PostingStockinWeb = "SP_PostingStockinWeb";
            public const string GetROIPrices = "SP_ROIGetPrices";
            public const string SaveROIAfterSaving = "SP_ROIAfterSaving";
            public const string GetROITotalForView = "SP_ROIGetTotalForView";
            // Promotion Procedures
            public const string SaveTargetPromotion = "SP_WebSaveTargetPromotion";
            // Target Achievements Calculations
            public const string ReCalculateAchievements = "SP_ReCalculateAchievements";
            // Forecasting Procedures
            public const string CalculateSuggestGrowthFactorForItems = "SP_CalculateSuggestGrowthFactorForItems";
            public const string FillForecastingDetailsData = "SP_FillForecastingDetailsData";
            public const string ExchangeRouteCustomer = "SP_ExchangeRouteCustomer";
            public const string CalculateSatisfiedPromotions = "SP_CalculateSatisfiedPromotions";
            public const string CalculateTestSatisfiedPromotions = "SP_CalculateTestSatisfiedPromotions";
            public const string CalculateSatisfiedPromotionsAfterReturn = "SP_CalculateSatisfiedPromotionsAfterReturn";
            public const string RetrieveRouteCustomer = "SP_RetrieveRouteCustomer";
            //AppData Procedures
            public const string DeleteOrganizationProcedure = "SP_Web_DeleteOrganization";

            public const string CalculateEmployeeCommission = "SP_CalculateEmployeeCommission";
            public const string InvoiceLocation = "SP_Web_InvoiceLocation";
            public const string CRMItemsWithStockStatus = "SP_CRMItems";
            public const string PostingPaymentAtDownload = "SP_PostingPaymentAtDownload";
            public const string PostingStockAtDownload = "SP_PostingStockAtDownload";
            public const string CalculateUsedBundles = "SP_CalculateUsedBundles";
        }
        public class SheetsConstants
        {
            public const string InvalidSerialSheet = "invalid-serials.xlsx";
            public const string PosStockCountingSheet = "pos-stock-counting.xlsx";
        }
        public class WindowsServicesNames
        {
            public const string FillingCustomerBatchesList = "FillingCustomerBatchesList";
        }
        public class EPaymentLinkType
        {
            public const string SendEPaymentLink = "Send Link";
            public const string UpdateEPaymentLink = "Update Status";
            public const string CancelEPaymentLink = "Cancel Link";
            public const string UpdateEPaymentChargeLink = "Update Status Charge";
        }
    }
}