﻿using System;

namespace Sonic.Web.Model
{
    public class DateModel
    {
        public DateModel()
        {
        }

        public DateModel(DateTime dt)
        {
            this.Year = dt.Year;
            this.Month = dt.Month;
            this.Day = dt.Day;
            this.Hour = dt.Hour;
            this.Minute = dt.Minute;
            this.Second = dt.Second;
        }

        public DateTime Date
        {
            get
            {
                if (IsValidDate())
                    return new DateTime(Year, Month, Day, Hour, Minute, Second);
                else
                    return DateTime.MinValue;
            }
        }

        public int Day { get; set; }
        public int Hour { get; set; }
        public int Minute { get; set; }
        public int Month { get; set; }
        public int Second { get; set; }
        public int Year { get; set; }

        public bool IsValidDate()
        {
            try
            {
                if (Year < DateTime.MinValue.Year || Year > DateTime.MaxValue.Year)
                    return false;
                if (Month < 1 || Month > 12)
                    return false;
                return Day > 0 && Day <= DateTime.DaysInMonth(Year, Month);
            }
            catch (Exception ex)
            {
                return false;
            }
        }

        public void SetDate(DateTime date)
        {
            Year = date.Year;
            Month = date.Month;
            Day = date.Day;
            Hour = date.Hour;
            Minute = date.Minute;
            Second = date.Second;
        }
    }
}