﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Sonic.Web.Model
{
    public class GeneralFilter
    {
        private DateTime _date = DateTime.MinValue;


        #region [Public Properties]

        public bool CheckBoxValue { get; set; }
        public ItemFormProcessMode FormProcessMode { get; set; }
        public TransactionType TransactionType { get; set; }
        public CustomListFilters CustomListFilter { get; set; }
        public string TransactionId { get; set; }
        public string CustomerPaymentId { get; set; }
        public string Code { get; set; }
        public string ICashTransactionType { get; set; }
        public DateModel DateModel { get; set; }
        public List<DateModel> FromToDate { get; set; }
        public DateModel ToDate { get; set; }
        public DateModel FromDate { get; set; }
        public bool IsExecuteMode { get; set; }
        public List<DateModel> TransactionDate { get; set; }
        public bool IzLazyLodingCombo { get; set; }
        public int ReportTypeId { get; set; }
        public bool GetAllItems { get; set; }
        public DateTime Date
        {
            get { return _date; }
            set
            {
                _date = value;
                if (_date != null)
                {
                    DateModel = new DateModel(_date);
                }
            }
        }
        public int paymentTypeId { get; set; }
        public int DiscountTypeId { get; set; }
        public int TypeId { get; set; }
        public int SaleModeId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int EmployeeId { get; set; }
        public int ToEmployeeId { get; set; }
        public int FromEmployeeId { get; set; }
        public int SecurityGroupId { get; set; }
        public int OrganizationId { get; set; }
        public string OrganizationIds { get; set; }
        public int ChannelId { get; set; }
        public int SubChannelId { get; set; }
        public int TemplateId { get; set; }
        public int DivisionId { get; set; }
        public int WarehouseId { get; set; }
        public int VehicleId { get; set; }
        public int PackGroupId { get; set; }
        public int PackId { get; set; }
        public int ItemId { get; set; }
        public string PacksString { get; set; } //1,3,4
        public int groupId { get; set; }
        public int ItemCategoryId { get; set; }
        public bool ShowPacks { get; set; }
        public bool GenerateMoreInfoLink { get; set; }
        public int MoreInfoDashboardId { get; set; }
        public bool Active { get; set; }
        public string channelSubChannel { get; set; }
        public bool IncludeInactive { get; set; }
        public int MandatoryId { get; set; }
        public bool AllCustomersOnly { get; set; }
        public bool IncludeCashPayment { get; set; }
        public bool NewCustomerOnly { get; set; }
        public bool ExcludeOnHold { get; set; }
        public int TerritoryId { get; set; }
        public int RouteId { get; set; }
        public bool FilterOnRoute { get; set; }
        public bool ShowTransWithRemaining { get; set; }
        public bool OOSMode { get; set; }
        public int PriceListTypeId { get; set; }
        public bool IncludeVoided { get; set; }
        public bool IsDefaultCustomer { get; set; }
        public int ProofId { get; set; }
        public bool ExcludeCompetitorItem { get; set; }
        public bool ShowUpperLimitOnly { get; set; }
        public bool GetChattingCustomers { get; set; }
        public bool IsContractedFoc { get; set; }
        public int BrandId { get; set; }
        public int PackTypeId { get; set; }
        public int TypeValue { get; set; }
        public bool ShowInActive { get; set; }
        public bool hasPrivilegeOnPaymentTermDivision { get; set; }
        public bool hasPrivilegeOnOnHoldDivision { get; set; }
        public int AccountId { get; set; }
        public string OutletCode { get; set; }
        public string CustomerOutletId { get; set; }
        public string RequestId { get; set; }
        public bool IncludeTax { get; set; }
        public bool ShowActiveOnly { get; set; }
        public int OperatorId { get; set; }
        public bool HideInactiveTerritories { get; set; }
        public int MasterTerritoryId { get; set; }
        public bool HideInactiveRoutes { get; set; }
        public int SurveyTypeId { get; set; }
        public int FieldId { get; set; }
        public string PromotionIdsString { get; set; }
        public bool AllCustomers { get; set; }
        public bool SetAsDisabled { get; set; }
        public bool IsFromPayerAccount { get; set; }
        public string SDCIdsString { get; set; }
        public string DivisionIdsString { get; set; }
        public string ItemCategoriesIdsString { get; set; }
        public string ItemIdsString { get; set; }
        public string ItemGroupIdsString { get; set; }
        public string ItemCategoryIdsString { get; set; }
        public string BrandIdsString { get; set; }
        public string EmployeeIdsString { get; set; }
        public string SecurityGroupIdsString { get; set; }
        public bool IsFromCollection { get; set; }
        public bool isFromApprovalCyclePromotion { get; set; }
        public bool ShowForOutletOnly { get; set; }
        public bool IsSkipPromotion { get; set; }
        #endregion

        public GeneralFilter()
        {
            paymentTypeId = -1;
            DiscountTypeId = -1;
            TypeId = -1;
            SaleModeId = -1;
            CustomerId = -1;
            OutletId = -1;
            OrganizationId = -1;
            OrganizationIds = string.Empty;
            ChannelId = -1;
            SubChannelId = -1;
            DivisionId = -1;
            EmployeeId = -1;
            FromEmployeeId = -1;
            ToEmployeeId = -1;
            SecurityGroupId = -1;
            VehicleId = -1;
            WarehouseId = -1;
            ItemCategoryId = -1;
            Active = false;
            ShowPacks = false;
            GenerateMoreInfoLink = false;
            _date = DateTime.MinValue;
            TransactionId = string.Empty;
            PackId = -1;
            groupId = -1;
            PackGroupId = -1;
            channelSubChannel = "";
            IncludeInactive = false;
            AllCustomersOnly = false;
            ExcludeOnHold = false;
            RouteId = -1;
            FilterOnRoute = false;
            CheckBoxValue = false;
            PriceListTypeId = -1;
            IzLazyLodingCombo = false;
            IncludeVoided = false;
            NewCustomerOnly = false;
            IsDefaultCustomer = false;
            ToDate = new DateModel();
            FromDate = new DateModel();
            ProofId = -1;
            ExcludeCompetitorItem = false;
            ItemId = -1;
            ShowUpperLimitOnly = false;
            GetChattingCustomers = false;
            BrandId = -1;
            ShowInActive = false;
            hasPrivilegeOnPaymentTermDivision = false;
            hasPrivilegeOnOnHoldDivision = false;
            AccountId = -1;
            OutletCode = string.Empty;
            CustomerOutletId = string.Empty;
            RequestId = string.Empty;
            HideInactiveTerritories = false;
            MasterTerritoryId = -1;
            HideInactiveRoutes = false;
            SurveyTypeId = -1;
            FieldId = -1;
            IncludeCashPayment = false;
            PromotionIdsString = string.Empty;
            AllCustomers = false;
            PackTypeId = -1;
            MandatoryId = -1;
            SetAsDisabled = false;
            IsFromPayerAccount = false;
            EmployeeIdsString = "";
            SecurityGroupIdsString = "";
            IsFromCollection = false;
            isFromApprovalCyclePromotion = false;
            GetAllItems = false;
            IsSkipPromotion = false;
        }
    }
    public class EntryData
    {
        public string TableName { get; set; }
        public string ColumnName { get; set; }
        public string InsertedValue { get; set; }
        public string ExcludedString { get; set; }
        public string ColumnDescription { get; set; }
    }
}