﻿
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Sonic.Web.Model
{
    public class OperatorModel
    {
        #region [Encrepted Properties]

        public string EncryptedOperatorId { set; get; }
        public string EncryptedEmployeeId { set; get; }
        public bool ControlDivLevel { set; get; }


        #endregion

        public int EmployeeId { get; set; }
        public int OrganizationId { get; set; }
        public int SupervisorId { set; get; }
        public int HelperId { set; get; }
        public int SalesManagerId { set; get; }
        public int DriverId { set; get; }
        public int SalesRepId { set; get; }
        public int OperatorId { get; set; }
        public int EmployeeTypeId { get; set; }
        public MenuModel LandingMenu { get; set; }
        public string EmployeeCode { get; set; }
        public string EmployeeName { get; set; }        
        public string Email { get; set; }
        public string OrganizationAccess { get; set; }
        public string OriginalOrganizationAccess { get; set; }
        public string DivisionAccess { get; set; }
        public string OriginalDivisionAccess { get; set; }
        public string password { get; set; }
        public string username { get; set; }
        public string SubordinatesEmployeesAsString { get; set; }
        public bool IsLocked { get; set; }
        public bool Inactive { get; set; }
        public bool ActiveDirectoryLogin { get; set; }
        public string OperatorPassword { get; set; }
        public int NumberOfFailedLogin { get; set; }
        public bool ChangePasswordOnLogin { get; set; }
        public DateTime? PasswordChangeDate { get; set; }
        public int PasswordExpiryDays { get; set; }
        public string CustomerCodeName { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public string OrgGLN { get; set;}
        public OperatorModel()
        {
            OperatorId = -1;
            OrganizationId = -1;
            EmployeeId = -1;
            SupervisorId = -1;
            HelperId = -1;
            DriverId = -1;
            SalesRepId = -1;
            SalesManagerId = -1;
            IsLocked = false;
            Inactive = false;
            ActiveDirectoryLogin = false;
            NumberOfFailedLogin = -1;
            ChangePasswordOnLogin = false;
            PasswordExpiryDays = -1;
            OrgGLN = "";
        }
    }

    public class OperatorForLogin
    {
        [Required]
        public string Username { get; set; }
        [Required]
        public string Password { get; set; }
        public string OldPassword { get; set; }
        public int LanguageId { get; set; }
        public string DeviceInfo { get; set; }
        public string DeviceToken { get; set; }

        public bool RemoveCurrentOperatorSession { get; set; }
        public bool KeepCurrentOperatorSessions { get; set; }
        public int SelectedOrganizationId { get; set; }
        public bool SelectOrganization { get; set; }

        public OperatorForLogin()
        {
            RemoveCurrentOperatorSession = false;
            KeepCurrentOperatorSessions = false;
            SelectedOrganizationId = -1;
            SelectOrganization = true;
        }

    }
    public class OperatorProfileModel
    {
        public bool AllowToChangePassword { get; set; }
        public string OldPassword { get; set; }
        public string NewPassword { get; set; }
        //public IFormFile ImageFile { get; set; }
        public string LandingMenuId { get; set; }
        public string UserName { get; set; }
        public int EmployeeId { get; set; }
    }
    public class CachedGeneralData
    {
        public string DatabaseVersion { get; set; }
        public string AssemblyVersionNumber { get; set; }
        public WebApplication WebApplication { get; set; }
    }

    public class OperatorIDModel
    {
        public string OperatorId { get; set; }
        public string EmployeeId { get; set; }

    }
    public class OperatorLoginFailureModel
    {
        public int OperatorId { get; set; }
        public string OperatorName { get; set; }
        public string LoginType { get; set; }
        public int LoginTypeId { get; set; }
        public string MachineName { get; set; }
        public string IsLocked { get; set; }
        public string IsCleared { get; set; }
        public DateTime? LoginDate { get; set; }

        public OperatorLoginFailureModel()
        {
            OperatorId = -1;
            LoginTypeId = -1;
            IsLocked = string.Empty;
            IsCleared = string.Empty;
            OperatorName = string.Empty;
            LoginType = string.Empty;
        }

    }
}