﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Sonic.Web.Model
{
    public class TransactionCommonData
    {

        #region [Public Properties]

        public int CustomerOrganizationId { get; set; }
        public int CustomerId { get; set; }
        public string CustomerRef { get; set; }
        public int OutletId { get; set; }
        public int EmployeeId { get; set; }
        public int DivisionId { get; set; }
        public int PromotionLevelId { get; set; }
        public string OrderId { get; set; }
        public int EchoPaymentType { get; set; }

        public List<ItemPackModel> SoldItems { get; set; }

        public List<ItemPackModel> PromotedItems { get; set; }

        public List<Promotion> CustomerPromotions { get; set; }
        public List<Promotion> CustomerProductPromotions { get; set; }
        public List<Promotion> PromotionsForAllLevels { get; set; }
        public List<Promotion> TargetCustomerPromotionsForEcho { get; set; }
        public List<PromotionGroupLevelsModel> PromotionGroupLevels { get; set; }
        public List<int> LastInvoicePromotionsList { get; set; }
        public List<int> LoyaltyPromotionsList { get; set; }
        public List<int> UnSatisfiedTargetPromotions { get; set; }
        public List<int> UnSatisfiedDynamicAmountPromotions { get; set; }

        public decimal NetTotal { get; set; }
        public decimal NetTotalBeforFirstUserDiscount { get; set; }
        public decimal CalculatedDiscountTotalBeforFirstUserDiscount { get; set; }
        public decimal CalculatedAchievemnetDiscount { get; set; }

        public decimal CalculatedTotalDiscount { get; set; }
        public decimal CalculatedTotalTax { get; set; }
        public decimal Tax { get; set; }

        public decimal ExciseTax { get; set; }

        public decimal GrossTotal { get; set; }

        public decimal HeaderDiscount { get; set; }

        public decimal ExchangeRate { get; set; }

        public CustomerOutletModel Outlet { get; set; }

        public ItemFormProcessMode ItemFormProcessMode { get; set; }

        public OrderStatus OrderStatus { get; set; }

        public string DeliveryLocation { get; set; }
        public decimal AmountToCheckInCreditLimit { get; set; }

        public bool IsEditMode { get; set; }
        public bool AreDetailsFilled { get; set; }
        public bool IsDeliveryHasRelatedToTarget { get; set; }

        public bool NoDocumentSequance { get; set; }
        public bool DontCheckLastInvoice { get; set; }
        public bool DontCheckLoyalty { get; set; }
        public string DraftTransactionId { get; set; }
        public bool AreAllItemDiscountsAdded { get; set; }

        public Dictionary<PromotionOutputDetailTypes, List<PromotionBenefitDetails>> PromotionBenefitDetails; //Dont put { get; set; } to avoid Not Supported error 
        public string OrderNote { get; set; }
        public List<Promotion> Achivements { get; set; }
        public List<Promotion> EchoAppliedPromotions { get; set; }
        public decimal TotalCalculatedItemPromotedDiscount { get; set; }
        public decimal TotalCalculatedAllItemPromotedDiscount { get; set; }
        public int OrderTypeId { get; set; }
        public string DesiredDeliveryDateString { get; set; }
        public bool OnlyProductDiscount { get; set; }
        public bool IsThereAnyProductDiscountDefined { get; set; }
        public bool IsSecondLevelProductDiscountTaken { get; set; }
        public List<ProductDiscountModel> ProductDiscountFirstLevelList { get; set; }
        public List<ProductDiscountModel> ProductDiscountSecondLevelList { get; set; }
        public int ProductPromotionLevelId { get; set; }
        public int QuanityProductDiscountCount { get; set; }
        public int DiscountOrFreeItemsProductDiscountCount { get; set; }
        public List<int> NotSelectedFirstLevelLastInvoice { get; set; }
        public int RouteId { get; set; }
        public string ReturnId { get; set; }
        public bool IsExchangeInvoice { get; set; }
        public List<PromotionGroupPriorityModel> PromotionsGroupPriorities { get; set; }
        public int SalesMode { get; set; }
        public int SDCId { get; set; }
        public List<AppliedContractedFOCModel> ContractedFOCs { get; set; }
        public bool GetApplicableContractedFOCsOnly { get; set; } // false -> get all FOCS eligible for this customer in current date[regardless of TX total], true -> get all FOCs applicable based on current TX total.
        public bool IsBundle { get; set; }
        public List<ItemPackModel> OrderItems { get; set; }
        public bool IncludeInActive { get; set; }
        public bool IsTest { get; set; }
        #endregion
        public int warehouseId { get; set; }

        public TransactionCommonData()
        {
            SoldItems = new List<ItemPackModel>();
            Outlet = new CustomerOutletModel();
            PromotedItems = new List<ItemPackModel>();
            CustomerPromotions = new List<Promotion>();
            CustomerProductPromotions=new List<Promotion>();
            PromotionsForAllLevels = new List<Promotion>();
            PromotionGroupLevels = new List<PromotionGroupLevelsModel>();
            LastInvoicePromotionsList = new List<int>();
            LoyaltyPromotionsList = new List<int>();
            PromotionBenefitDetails = new Dictionary<PromotionOutputDetailTypes, List<PromotionBenefitDetails>>();
            Achivements = new List<Promotion>();
            EchoAppliedPromotions = new List<Promotion>();
            CustomerId = -1;
            OutletId = -1;
            DivisionId = -1;
            EmployeeId = -1;
            OrderNote = "";
            PromotionLevelId = 1;
            OrderTypeId = -1;
            AreDetailsFilled = true;
            OnlyProductDiscount = true;
            ProductDiscountFirstLevelList = new List<ProductDiscountModel>();
            ProductDiscountSecondLevelList = new List<ProductDiscountModel>();
            IsThereAnyProductDiscountDefined = false;
            IsSecondLevelProductDiscountTaken = false;
            ProductPromotionLevelId = 1;
            QuanityProductDiscountCount = 0;
            DiscountOrFreeItemsProductDiscountCount = 0;
            RouteId = -1;
            ReturnId = string.Empty;
            IsExchangeInvoice = false;
            PromotionsGroupPriorities = new List<PromotionGroupPriorityModel>();
            SalesMode = -1;
            SDCId = -1;
            ContractedFOCs = new List<AppliedContractedFOCModel>();
            GetApplicableContractedFOCsOnly = false;
            IsBundle = false;
            OrderItems = new List<ItemPackModel>();
            IncludeInActive = false;
            IsTest = false;
            CustomerOrganizationId = -1;
            warehouseId = -1;

        }
    }
}
