﻿using System;
using System.Collections.Generic;

namespace Sonic.Web.Model
{
    public class HeaderDiscountModel
    {
        public int CustomerHeaderDiscountId { get; set; }
        public int HeaderDiscountId { get; set; }

        public decimal Value { get; set; }

        public int OrganizationId { get; set; }

        public string OrganizationName { get; set; }

        public int DiscountTypeId { get; set; }

        public string DiscountType { get; set; }

        public int TypeId { get; set; }

        public string TypeIdName { get; set; }

        public int SaleModeId { get; set; }

        public string SalesModeName { get; set; }

        public bool AllCustomers { get; set; }

        public List<SimpleCustomerModel> AppliedCustomers { get; set; }

        public List<CustomerGroupModel> AppliedGroups { get; set; }

        public List<CustomerChannelModel> AppliedChannels { get; set; }

        public List<DateModel> DateModelRange { get; set; }
        public DateTime? StartDate { get; set; }
        public DateTime? EndDate { get; set; }

        public HeaderDiscountModel()
        {
            DiscountTypeId = -1;
            DiscountType = string.Empty;
            CustomerHeaderDiscountId = -1;
            HeaderDiscountId = -1;
            Value = 0;
            TypeId = -1;
            TypeIdName = string.Empty;
            SaleModeId = -1;
            SalesModeName = string.Empty;
            OrganizationId = -1;
            OrganizationName = string.Empty;
            AllCustomers = false;
            AppliedCustomers = new List<SimpleCustomerModel>();
            AppliedGroups = new List<CustomerGroupModel>();
            AppliedChannels = new List<CustomerChannelModel>();
        }
    }

    public class SalesModeModel
    {
        public int SalesModeId { get; set; }
        public string SalesModeName { get; set; }
    }

    public class GenreralHeaderFilter
    {
        private DateTime _date = DateTime.MinValue;


        public DateModel DateModel { get; set; }
        public CustomListFilters CustomListFilter { get; set; }
        public List<DateModel> FromToDate { get; set; }
        public DateModel ToDate { get; set; }
        public DateModel FromDate { get; set; }
        public decimal value { get; set; }
        public int DiscountTypeId { get; set; }
        public int typeId { get; set; }
        public string TypeIdName { get; set; }
        public int SaleModeId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int OrganizationId { get; set; }
        public string OrganizationIds { get; set; }
        public int ChannelId { get; set; }
        public int SubChannelId { get; set; }
        public int groupId { get; set; }
        public bool AllCustomers { get; set; }
        public DateTime Date
        {
            get { return _date; }
            set
            {
                _date = value;
                if (_date != null)
                {
                    DateModel = new DateModel(_date);
                }
            }
        }

        public GenreralHeaderFilter()
        {
            DiscountTypeId = -1;
            typeId = -1;
            TypeIdName = string.Empty;
            SaleModeId = -1;
            CustomerId = -1;
            OutletId = -1;
            OrganizationId = -1;
            OrganizationIds = string.Empty;
            ChannelId = -1;
            SubChannelId = -1;
            groupId = -1;
            value = -1;
            AllCustomers = false;
            ToDate = new DateModel();
            FromDate = new DateModel();
            _date = DateTime.MinValue;
        }
    }
}
