﻿using Sonic.Web.Model;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Sonic.Web.Model
{
    public class BrandImageModel
    {
        public byte[] Image { get; set; }
        public int BrandId { get; set; }
    }
    public class BrandModel
    {
        private string _brandName;
        public int BrandId { get; set; }
        public string BrandName
        {
            get
            {
                return _brandName;
            }
            set
            {
                if (string.IsNullOrEmpty(value))
                    this._brandName = "---";
                else
                    this._brandName = value;
            }
        }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public string BrandCode { get; set; }
        public int OrganizationId { get; set; }
        public List<OrganizationModel> OrganizationsList { get; set; }
        public string organizationCodeName { get; set; }


        public bool HasImage { get; set; }
        public bool ShowInCustomerApp { get; set; }
        public bool IsImageChanged { get; set; }
        public int MinimumNoImages { get; set; }
        public int MaximumNoImages { get; set; }
        public BrandModel()
        {
            BrandId = -1;
            BrandCode = string.Empty;
            DescriptionLanguages = new List<TextLanguage>();
            MinimumNoImages = 0;
            MaximumNoImages = 0;
        }

    }
}