﻿using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.Data;

namespace Sonic.Web.Model
{
    public class CRMSimpleItemPackModel
    {
        public int OrderedQuantity { get; set; }
        public bool ForceDefaultPack { get; set; }
        public string CategoryNameCode { get; set; }
        public int DefaultPackId { get; set; }
        public string PriceString { get; set; }
        public int WarehouseId { get; set; }
        private SalesTransactionTypes _salesTransactionTypeId;
        private DateTime _expiryDate;
        private DateTime _productionDate;
        public decimal PromotionValue { set; get; }
        public string SalesOrderTypeName { set; get; }
        public bool DisableValuesUsed { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public int ItemId { get; set; }
        public int ItemGroupID { get; set; }
        public string ItemGroup { get; set; }
        public decimal Quantity { get; set; }
        public decimal PackQuantity { get; set; }
        public int ItemCategoryId { get; set; }
        public int ModelId { get; set; }
        public int BrandId { get; set; }
        public int ItemTypeId { get; set; }
        public decimal AvailableQtyInPcs { get; set; }
        public decimal OriginalAvailableQty { get; set; }
        public decimal VehicleAvailableQtyInPCs { get; set; }
        public decimal PendingQtyInPcs { get; set; }
        public decimal OnHandQty { get; set; }
        public decimal ReservedQty { get; set; }
        public decimal StockQty { get; set; }
        public decimal BlockedQty { get; set; }
        public decimal WarehouseAvailableQtyInPCs { get; set; }
        public decimal UsedQtyPCs { get; set; }
        public string ItemCode { get; set; }
        public string ItemCodeName { get; set; }
        public bool HasImage { get; set; }
        public string ItemImage { get; set; }
        public bool Inactive { get; set; }
        public bool IsDefaultBatchNo { get; set; }
        public bool IsNew { get; set; }
        public int? ZoneId { get; set; }
        public int VendorId { get; set; }
        public string ImagePath { get; set; }
        public decimal DefaultPrice { get; set; }
        public int TransactionTypeId { get; set; }
        public string PackStatus { get; set; }
        public decimal PriceValue { get; set; }
        public decimal DiscountValue { get; set; }
        public int PromotionID { get; set; }
        public int PromotionOptionDetailTypeId { set; get; }
        public decimal OriginalPrice { get; set; }

        private string _itemName;
        public string ItemName
        {
            get
            {
                return _itemName;
            }
            set
            {
                if (string.IsNullOrEmpty(value))
                    this._itemName = "---";
                else
                    this._itemName = value;
            }
        }
        public string Model { get; set; }
        public string Category { get; set; }
        public string CategoryCode { get; set; }
        public string Brand { get; set; }
        public string PackDefinition { get; set; }
        public string ItemDefinition { get; set; }
        public string DivisionName { get; set; }
        public DateTime ProductionDate
        {
            get { return _productionDate; }
            set
            {
                _productionDate = value;
                ProductionDateModel = new DateModel(_productionDate);
            }
        }
        public DateModel ProductionDateModel { get; set; }
        public int PackStatusId { get; set; }
        public string PackStatusDescription { get; set; }
        public int DivisionId { get; set; }
        public int PackId { get; set; }
        public int PackTypeId { get; set; }
        public decimal PiecesInPack { get; set; }
        public decimal Price { get; set; }
        public decimal RetailPrice { get; set; }
        public decimal RetailTax { get; set; }
        public decimal RetailValue { get; set; }
        public decimal CalculatedRetailTax { get; set; }
        public decimal BasePrice { get; set; }
        public int UsedPriceListId { get; set; }
        public decimal Discount { get; set; }
        public decimal OriginalDiscount { get; set; }
        public decimal BaseDiscount { get; set; }
        public int DiscountTypeId { get; set; }
        public int BaseDiscountTypeId { get; set; }
        public decimal Tax { get; set; }
        public decimal BaseTax { get; set; }
        public decimal Foc { get; set; }
        public string Barcode { get; set; }
        public string BatchNo { get; set; }
        public string Uom { get; set; }
        public string ExpiryDateString { get; set; }
        public decimal TaxableAmount { get; set; }
        public bool ReSellable { get; set; }
        public bool InStock { get; set; } 
        public SalesTransactionTypes SalesTransactionTypeId
        {
            get
            {
                return _salesTransactionTypeId;
            }
            set
            {
                _salesTransactionTypeId = value;
                //if (_salesTransactionTypeId == SalesTransactionTypes.Promotion)
                //{
                //    PriceString = "Promo";
                //}
                //else if (_salesTransactionTypeId == SalesTransactionTypes.FOC)
                //{
                //    PriceString = "FOC";
                //}
                //else
                //{
                //    PriceString = decimal.Round(Price, 3).ToString();
                //}
            }
        }
        public DateTime ExpiryDate
        {
            get { return _expiryDate; }
            set
            {
                _expiryDate = value;
                ExpiryDateModel = new DateModel(_expiryDate);
            }
        }
        public DateModel ExpiryDateModel { get; set; }
        public decimal RequestedQuantity { get; set; }
        public decimal ApprovedQuantity { get; set; }
        public decimal RequiredQty { get; set; }
        public decimal OldRequiredQty { get; set; }
        public decimal ExistingQty { get; set; }
        public decimal NetTotal { get; set; }
        public string NetAmountString { get; set; }
        public decimal GrossTotal { get; set; }
        public decimal CalculatedTax { get; set; }
        public decimal CalculatedBaseTax { get; set; }
        public decimal CalculatedDiscount { get; set; }
        public decimal CalculatedDiscountTotal { get; set; }
        public decimal CalculatedPromotedDiscount { get; set; }
        public decimal FinalDiscountPercentage { get; set; }
        public bool IsMinusStock { get; set; }
        public decimal ActualDeliveredQuantity { get; set; }
        public int FOCTypeId { get; set; }
        public decimal ItemPromotedDiscount { get; set; }
        public decimal CalculatedItemPromotedDiscount { get; set; }
        public decimal AdditionalDiscountPercentage { get; set; }
        public decimal AllItemDiscount { get; set; }
        public decimal OriginalAllItemDiscount { get; set; }
        public decimal CalculatedAllItemPromotedDiscount { get; set; }
        public decimal AdditionalDiscount { get; set; }
        public decimal PromotedDiscount { get; set; }
        public int StockStatusId { get; set; }
        public int Sequence { get; set; }
        public decimal OrderdQuantity { get; set; }
        public int DivisionEmployeeID { get; set; }
        public string Notes { get; set; }
        public string TransactionId { set; get; }
        public DataActions DataAction { get; set; }
        public decimal OriginalQuantity { get; set; }
        public bool IsChecked { get; set; }
        public bool Enabled { get; set; }
        public int ValueType { get; set; }
        public CompetitorModel Competitor { get; set; }
        public int MinPackID { get; set; }
        public decimal MinPackQty { get; set; }
        public int SalesOrderTypeId { get; set; }
        public bool OrderItemIsApproved { get; set; }
        public int OrganizationId { get; set; }
        public string OrganizationCodeName { get; set; }
        public bool AllowFractionInQty { get; set; }
        public decimal MinimumQuantity { get; set; }
        public bool BooleanValue { get; set; }
        public string Color { set; get; }
        public List<CRMSimpleItemPackModel> StockStatusItemsList { get; set; } // [BRF - CRM] (Pack stock status by color details.)
        public decimal MinPrice { get; set; } // [BRF - CRM] 
        public decimal MaxPrice { get; set; } // [BRF - CRM] 
        public decimal ApprovalPrice { get; set; } // [BRF - CRM] 
        public string SalesOrderTypeCodeName { get; set; }
        public string Icon { get; set; }
        public string IconColor { get; set; }
        public List<SalesOrderTypeModel> SalesOrderTypes { get; set; }
        public bool PriceEditable { get; set; } // stock status and sales order type colors BRF
        public bool DisableEditPrice { get; set; } 
        public decimal TaxPercentage { get; set; } // FOR ZATCA
        public decimal BaseTaxPercentage { get; set; } // FOR ZATCA
        public decimal OriginalStockQty { get; set; }
        public bool IsExceedAvailableQty { get; set; }
        public decimal RemainingQuantity { get; set; }
        public bool InLastOrder { get; set; }
        public bool InLast30Days { get; set; }
        public bool InTop5 { get; set; }
        public bool IsSuggested { get; set; }
        public bool InProductMix { get; set; }
        public bool IsNonGreenStock { get; set; }
        public decimal ListPrice { get; set; }
        public int MustSellItemId { get; set; }
        public string MustSellItemCode { get; set; }
        public string MustSellItemName { get; set; }

        public CRMSimpleItemPackModel()
        {
            TransactionId = "";
            DescriptionLanguages = new List<TextLanguage>();
            IsNew = false;
            DisableValuesUsed = false;
            DefaultPackId = -1;
            PromotionValue = 0;
            ItemId = -1;
            ItemGroupID = -1;
            Quantity = -1;
            ItemCategoryId = -1;
            ModelId = -1;
            BrandId = -1;
            ItemTypeId = -1;
            AvailableQtyInPcs = 0;
            UsedQtyPCs = 0;
            _itemName = "";
            ItemCode = "";
            Model = "";
            Category = "";
            Brand = "";
            ItemDefinition = "";
            DivisionName = "";
            PackDefinition = "";
            PackId = -1;
            PackTypeId = -1;
            DiscountTypeId = 1;
            Price = 0;
            BasePrice = 0;
            Discount = 0;
            Tax = 0;
            BaseTax = 0;
            Foc = 0;
            RequiredQty = 0;
            OldRequiredQty = 0;
            Barcode = "";
            Uom = "";
            BatchNo = "";
            ExpiryDateModel = new DateModel();
            DivisionId = -1;
            NetTotal = 0;
            GrossTotal = 0;
            CalculatedTax = 0;
            CalculatedBaseTax = 0;
            CalculatedDiscountTotal = 0;
            CalculatedDiscount = 0;
            CalculatedPromotedDiscount = 0;
            ExpiryDate = new DateTime();
            ProductionDate = new DateTime();
            ExpiryDateModel = new DateModel();
            ProductionDateModel = new DateModel();
            PackStatusId = -1;
            ExistingQty = 0;
            OldRequiredQty = 0;
            DivisionId = -1;
            UsedPriceListId = -1;
            _salesTransactionTypeId = SalesTransactionTypes.None;
            FOCTypeId = -1;
            IsChecked = false;
            TaxableAmount = 0;
            Enabled = false;
            ValueType = 1;
            PriceString = string.Empty;
            VendorId = -1;
            DataAction = DataActions.NoChange;
            OrganizationId = -1;
            OrganizationCodeName = string.Empty;
            AllowFractionInQty = false;
            ReSellable = false;
            InStock = true;
            SalesOrderTypeName = string.Empty;
            MinimumQuantity = 0;
            BooleanValue = false;
            Color = string.Empty;
            StockStatusItemsList = new List<CRMSimpleItemPackModel>();
            SalesOrderTypeCodeName = string.Empty;
            Icon = string.Empty;
            IconColor = string.Empty;
            SalesOrderTypes = new List<SalesOrderTypeModel>();
            DisableEditPrice = false;
            PriceValue = 0;
            DiscountValue = 0;
            PromotionID = 0;
            PromotionOptionDetailTypeId = -1;
            PackQuantity = 0;
            OriginalAvailableQty = 0;
            OriginalStockQty = 0;
            OriginalPrice = 0;
            RemainingQuantity = 0;
        }
    }
    public class CRMOrderModel 
    {
        public CRMOrderModel()
        {
        }
        public string OrderId { set; get; }
        public int CustomerId { set; get; }
        public int OutletId { set; get; }
        public int DivisionId { set; get; }
        public int OrganizationId { set; get; }
        public DateTime OrderDate { set; get; }
        public int EmployeeId { set; get; }
        public string OrderBy { set; get; }
        public decimal OrderNetTotal { set; get; }
        public int OrderStatusId { set; get; }
        public string OrderStatus { set; get; }
        public int OrderSubStatusId { set; get; }
        public string OrderSubStatus { set; get; }
        public string OrderStatusColor { set; get; }
        public bool Synchronized { get; set; }
        public bool AllowEdit { get; set; }
        public List<CRMOrderDetailsModel> OrderDetails { set; get; }
    }
    public class CRMOrderDetailsModel : CRMSimpleItemPackModel
    {
        public CRMOrderDetailsModel()
        {

        }
        public string OrderId { set; get; }
        public int CustomerId { set; get; }
        public int OutletId { set; get; }
        public int OrderOrganizationId { set; get; }
        public DateTime OrderDate { set; get; }
        public int EmployeeId { set; get; }
        public string OrderBy { set; get; }
        public decimal OrderNetTotal { set; get; }
        public int OrderStatusId { set; get; }
        public string OrderStatus { set; get; }
        public string OrderSubStatus { set; get; }
        public int OrderSubStatusId { set; get; }
        public string OrderStatusColor { set; get; }
        public bool DisableCheckBox { set; get; }
        public string BackColor { set; get; }
        public bool Synchronized { get; set; }
        public bool AllowEdit { get; set; }
    }
}