﻿using Sonic.Web.Model;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Sonic.Web.Model
{
    public class CategoryImageModel
    {
        public byte[] Image { get; set; }
        public int ItemCategoryId { get; set; }
        public string ItemCategoryCode { get; set; }
    }
    public class CategoryModel
    {
        private string _divisionName;
        private string _itemCategoryName;
        public int ItemCategoryId { get; set; }

        public string ItemCategoryCode { get; set; }

        public int DivisionId { get; set; }

        public bool Active { get; set; }

        public string ItemCategoryName {
            get
            {
                return _itemCategoryName;
            }
            set
            {
                if (string.IsNullOrEmpty(value))
                    this._itemCategoryName = "---";
                else
                    this._itemCategoryName = value;
            }
        }

        public string DivisionName
        {
            get
            {
                return _divisionName;
            }
            set
            {
                if (string.IsNullOrEmpty(value))
                    this._divisionName = "---";
                else
                    this._divisionName = value;
            }
        }

        public string CategoryNameCode
        {
            get
            {
                return string.Format("{0} {1}", ItemCategoryCode, string.IsNullOrEmpty(_itemCategoryName) ? "" : " - " + _itemCategoryName);
            }
        }

        public List<TextLanguage> DescriptionLanguages { get; set; }

        public string Status { get; set; }
        public string OrganizationName { get; set; }
        public bool HasImage { get; set; }
        public bool IsImageChanged { get; set; }
        public bool ShowInCustomerApp { get; set; }
        public CategoryModel()
        {
            DivisionId = -1;
            ItemCategoryId = -1;
            DescriptionLanguages = new List<TextLanguage>();
        }

    }

    public class ItemCategoryFilter
    {
        public int DivisionId { get; set; }
        public string DivisionIdsString { get; set; }
        public string ItemCategoryIdsString { get; set; }
        public ItemCategoryFilter() 
        {
            DivisionId = -1;
            DivisionIdsString = string.Empty;
            ItemCategoryIdsString = string.Empty;
        }
    }
}