﻿using System;
using System.Collections.Generic;

namespace Sonic.Web.Model
{
    public class DivisionModel
    { 
        private string _description;
        public int DivisionId { get; set; }
        public int OrganizationId { get; set; }
        public string DivisionCode { get; set; }
        public string OrganizationName { get; set; }
        public string DivisionCodeName { get; set; }
        public bool HasImage { get; set; }
        public bool IsImageChanged { get; set; }
        public string Description
        {
            get
            {
                return _description;
            }
            set
            {
                if (string.IsNullOrEmpty(value))
                    this._description = "---";
                else
                    this._description = value;
            }

        }
        public DateTime ExpirationDate { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }

        public DivisionModel()
        {
            DescriptionLanguages = new List<TextLanguage>();
        }
        public bool IsDefault { set; get; }
        public bool Active { get; set; }
        public bool EmployeeAccess { get; set; }
        public bool IsFromStaffEmployeeOrgAccess { get; set; }

    }

    public class DivisionFilter
    {
        public int EmployeeId { get; set; }
        public string DivisionIdsString { get; set; }
        public DivisionFilter() 
        {
            EmployeeId = -1;
            DivisionIdsString = string.Empty;
        }

    }
}