﻿using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.Data;

namespace Sonic.Web.Model
{
    public class ItemMinMaxPack
    {
        public int ItemId { get; set; }
        public int MinPackId { get; set; }
        public int MaxPackId { get; set; }
        public decimal MinPackQTY { get; set; }
        public decimal MaxPackQTY { get; set; }
        public decimal MinPackPrice { get; set; }
        public decimal MaxPackPrice { get; set; }
        public decimal MinPackTax { get; set; }
        public decimal MaxPackTax { get; set; }
        public int MinPackUsedPriceListId { get; set; }
        public int MaxPackUsedPriceListId { get; set; }
    }
    public class ItemAction
    {
        public string ItemIds { get; set; }
        public WebMenuActions SelectedAction { get; set; }
    }
    public class SecondaryPackModel
    {
        public int ItemId { get; set; }
        public int PackId { get; set; }
        public int SecondaryPackId { get; set; }
        public int PackTypeId { get; set; }
        public decimal Quantity { get; set; }
        public decimal ModifiedPrice { get; set; }
        public decimal SecondaryQuantity { get; set; }
        public string PackType { get; set; }
        public decimal RequiredQuantity { get; set; }
        public decimal OriginalPrice { get; set; }
        public string Barcode { get; set; }

    }
    public class BenefitSequenceDetails
    {
        public string TransactionId { get; set; }
        public int PromotionId { get; set; }
        public int ItemId { get; set; }
        public int PackId { get; set; }
        public int Sequence { get; set; }
        public int BenefitPGID { get; set; }
        public decimal Value { get; set; }

    }
    public class ImageGeneralModel
    {
        public byte[] Image { get; set; }
        public int Id { get; set; }
        public string Code { get; set; }
    }
    public class ItemImageModel
    {
        public byte[] Image { get; set; }
        public int ItemId { get; set; }
        public string ItemCode { get; set; }
    }

    public class ItemGroupModel
    {
        public int ItemGroupId { get; set; }
        public string ItemGroupName { get; set; }
        public int MasterItemGroupID { get; set; }

    }

    public class ItemGroupEntryModel
    {
        public int ItemGroupId { get; set; }
        public List<ItemPackModel> itemIdsList { get; set; }
        public List<TextLanguage> languageDescriptions { get; set; }
        public List<OrganizationModel> OrganizationsList { get; set; }
        public bool AllItems { get; set; }
        public int MasterItemGroupID { get; set; }
        public bool HasImage { get; set; }
        public bool IsImageChanged { get; set; }

    }
    public class MasterItemGroupModel
    {
        public int MasterItemGroupID { get; set; }
        public string MasterItemGroupName { get; set; }
        public List<ItemGroupModel> ItemGroups { get; set; }
    }

    public class ExternalItemPackOnlineModel
    {
        public int PackID { get; set; }
        public decimal Quantity { get; set; }
        public decimal Price { get; set; }
        public decimal UsedPriceListID { get; set; }
    }

    public class ItemPackModel
    {
        public int UsedFilterId { get; set; }

        public DateModel isNewExpireDateModel { get; set; }

        public DateTime IsNewExpireDate
        {
            get { return isNewExpireDateModel.Date; }
            set
            {
                isNewExpireDateModel.SetDate(value);
            }
        }
        public List<string> AttachmentList { get; set; }
        public SecondaryPackModel SecondaryPack { get; set; }
        public int SecondaryPackId { get; set; }
        public int SecondaryPackTypeId { get; set; }
        public decimal SecondaryQuantity { get; set; }
        public decimal SecondaryDefinedQuantity { get; set; }
        public decimal CostPrice { get; set; }
        public bool UseBasePrice { get; set; }
        public int OrderedQuantity { get; set; }
        public bool ForceDefaultPack { get; set; }
        public string CategoryNameCode { get; set; }
        public int DefaultPackId { get; set; }
        public string PriceString { get; set; }
        public int WarehouseId { get; set; }
        private SalesTransactionTypes _salesTransactionTypeId;
        private DateTime _expiryDate;
        private DateTime _productionDate;
        // Item LEVEL
        public decimal PromotionValue { set; get; }
        public string SalesOrderTypeName { set; get; }
        public bool DisableValuesUsed { get; set; }
        public List<PackModel> Packs { get; set; }
        public List<SecondaryPackModel> SecondaryPacks { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public List<int> DeletedPacks { get; set; }

        public int ItemId { get; set; }
        public int ItemGroupID { get; set; }
        public string ItemGroup { get; set; }
        public int MasterItemGroupID { get; set; }
        public string MasterItemGroup { get; set; }
        public decimal Quantity { get; set; }
        public decimal PackQuantity { get; set; }
        public decimal IncludedTaxAmount { get; set; }
        public decimal TaxIncludedInPrice { get; set; }
        public int ItemCategoryId { get; set; }
        public GeneralFilter PaginateSetting { get; set; }
        public int TemplateId { get; set; }
        public List<int> TemplateSerialsIndecies { get; set; }
        public List<int> TemplateBatchNoIndecies { get; set; }
        public List<int> TemplateExpiryDateIndecies { get; set; }
        public List<int> TemplateProductionDateIndecies { get; set; }
        public List<int> TemplateGTINIndecies { get; set; }
        public List<int> TemplateGLNIndecies { get; set; }
        public bool ProductionIncludedInTemplate { get; set; }
        public int TotalFieldsLengthOfItemTemplate { get; set; }
        //public int TemplateSerialStartIndex { get; set; }
        //public int TemplateSerialEndIndex { get; set; }
        public string GTIN { get; set; }
        public string GLN { get; set; }
        public int ModelId { get; set; }
        public int BrandId { get; set; }
        public int ItemTypeId { get; set; }
        public int ShelfLifeTime { get; set; }
        public decimal AvailableQtyInPcs { get; set; }
        public decimal OriginalAvailableQty { get; set; }
        public decimal VehicleAvailableQtyInPCs { get; set; }
        public decimal PendingQtyInPcs { get; set; }
        public decimal OnHandQty { get; set; }
        public decimal ReservedQty { get; set; }
        public decimal StockQty { get; set; }
        public decimal BlockedQty { get; set; }
        public decimal LowStockQty { get; set; }
        public decimal WarehouseAvailableQtyInPCs { get; set; }
        public decimal UsedQtyPCs { get; set; }
        public string ItemCode { get; set; }
        public string ItemCodeName { get; set; }
        public bool HasImage { get; set; }
        public bool IsImageChanged { get; set; }
        public string ItemImage { get; set; }
        public bool Inactive { get; set; }
        public bool IsInitiative { get; set; }
        public bool IsBatchPriced { get; set; }
        public bool TemporaryCredit { get; set; }
        public bool IsDefaultBatchNo { get; set; }
        public bool IsPowerSKU { get; set; }
        public bool IsNew { get; set; }
        public bool IsPriceProtected { get; set; }
        public bool IsWeightPriced { get; set; }
        public bool HasSerialNumber { get; set; }
        public bool EnableBatchForSerial { get; set; }
        public bool AutoGenerateSubSerials { get; set; }
        public bool IsAdditionalItem { get; set; }
        public bool HasOffer { get; set; }
        public bool IsBestSeller { get; set; }
        public int? BestSellerSeq { get; set; }
        public int? ZoneId { get; set; }
        public int VendorId { get; set; }
        public bool RequiredByLiter { get; set; }
        public bool ItemCategoryInCustomerApp { get; set; }
        public bool BrandInCustomerApp { get; set; }
        public decimal StartReading { get; set; }
        public decimal EndReading { get; set; }
        public string PalletBarcode { get; set; }
        public string ImagePath { get; set; }
        public decimal DefaultPrice { get; set; }
        public int TransactionTypeId { get; set; }
        public decimal DepositBalance { get; set; }
        public decimal NoneDepositBalance { get; set; }
        public decimal Limit { get; set; }
        public string PackStatus { get; set; }
        public bool IsReturnItem { get; set; }
        public decimal RequiredReturnQty { get; set; }
        public decimal OldRequiredReturnQty { get; set; }
        public decimal PriceValue { get; set; }
        public decimal DiscountValue { get; set; }
        public int PromotionID { get; set; }
        public decimal BundlePrice { get; set; }
        public decimal BundleDiscount { get; set; }
        public int PromotionOptionDetailTypeId { set; get; }

        public decimal RateValue { get; set; }
        public decimal OriginalPrice { get; set; }

        public decimal TotalRateValue { get; set; }

        private string _itemName;
        public string ItemName
        {
            get
            {
                return _itemName;
            }
            set
            {
                if (string.IsNullOrEmpty(value))
                    this._itemName = "---";
                else
                    this._itemName = value;
            }
        }
        public string Model { get; set; }
        public string Category { get; set; }
        public string CategoryCode { get; set; }
        public string Brand { get; set; }
        public string PackDefinition { get; set; }
        public string ItemDefinition { get; set; }
        public string DivisionName { get; set; }
        public bool Balanced { get; set; }
        public DateTime ProductionDate
        {
            get { return _productionDate; }
            set
            {
                _productionDate = value;
                ProductionDateModel = new DateModel(_productionDate);
            }
        }
        public DateModel ProductionDateModel { get; set; }
        public int PackStatusId { get; set; }
        public string PackStatusDescription { get; set; }
        public int DivisionId { get; set; }
        // PACK LEVEL
        public int PackId { get; set; }
        public int ChildPackId { get; set; }
        public int PackTypeId { get; set; }
        public BarcodeValues BarcodeValues { get; set; }
        public decimal PiecesInPack { get; set; }
        public decimal SalesRestrictionQuantity { get; set; }
        public decimal PackQuantityInLevels { get; set; }
        public ItemPackModel ChildPack { get; set; }
        public decimal ChildPackPrice { get; set; }
        public decimal Price { get; set; }
        public decimal ReturnPrice { get; set; }
        public decimal RetailPrice { get; set; }
        public decimal RetailTax { get; set; }
        public decimal RetailValue { get; set; }
        public decimal CalculatedRetailTax { get; set; }
        public decimal CalculatedHeaderDiscount { get; set; }
        public decimal BasePrice { get; set; }
        public decimal ExclusivePrice { get; set; }
        public int UsedPriceListId { get; set; }
        public decimal ReturnUsedPriceListID { get; set; }
        public decimal Discount { get; set; }
        public decimal OriginalDiscount { get; set; }
        public decimal BaseDiscount { get; set; }
        public decimal HeaderDiscount { get; set; }
        public int DiscountTypeId { get; set; }
        public int BaseDiscountTypeId { get; set; }
        public decimal Tax { get; set; }
        public decimal BaseTax { get; set; }
        public decimal Foc { get; set; }
        public string Barcode { get; set; }
        public string BatchNo { get; set; }
        public string Uom { get; set; }
        public string ExpiryDateString { get; set; }
        public string SerialSeparator { get; set; }
        public decimal TaxableAmount { get; set; }
        public decimal PartialQty { get; set; }
        public bool ReSellable { get; set; }
        public bool InStock { get; set; } 
        public bool InSCS { get; set; }
        public bool IsPartiallyPrepared { get; set; }

        public SalesTransactionTypes SalesTransactionTypeId
        {
            get
            {
                return _salesTransactionTypeId;
            }
            set
            {
                _salesTransactionTypeId = value;
                //if (_salesTransactionTypeId == SalesTransactionTypes.Promotion)
                //{
                //    PriceString = "Promo";
                //}
                //else if (_salesTransactionTypeId == SalesTransactionTypes.FOC)
                //{
                //    PriceString = "FOC";
                //}
                //else
                //{
                //    PriceString = decimal.Round(Price, 3).ToString();
                //}
            }
        }
        public DateTime ExpiryDate
        {
            get { return _expiryDate; }
            set
            {
                _expiryDate = value;
                ExpiryDateModel = new DateModel(_expiryDate);
            }
        }

        public DateModel ExpiryDateModel { get; set; }
        public decimal RequestedQuantity { get; set; }
        public decimal ApprovedQuantity { get; set; }
        public decimal RequiredQty { get; set; }
        public decimal OldRequiredQty { get; set; }
        public decimal ExistingQty { get; set; }
        public decimal NetTotal { get; set; }
        public string NetAmountString { get; set; }
        public decimal GrossTotal { get; set; }
        public decimal CalculatedTax { get; set; }
        public decimal CalculatedBaseTax { get; set; }
        public decimal CalculatedDiscount { get; set; }
        public decimal CalculatedDiscountTotal { get; set; }
        public decimal CalculatedPromotedDiscount { get; set; }
        public decimal FinalDiscountPercentage { get; set; }
        public bool IsMinusStock { get; set; }
        public decimal ActualDeliveredQuantity { get; set; }

        public decimal ConsumerPrice { get; set; }
        public int ConsumerPriceListId { get; set; }
        public int FOCTypeId { get; set; }
        public int ReasonId { get; set; }

        // PROMOTIONS
        public decimal ItemPromotedDiscount { get; set; }
        public decimal CalculatedItemPromotedDiscount { get; set; }
        public decimal ExciseContractPromotedDiscount { get; set; }//Percantage
        public decimal RetailCalculatedPromotedDiscount { get; set; }//Amount
        public decimal WholeSalesPromotedDiscount { get; set; }//Percentage
        public decimal WholeSalesCalPromotedDiscount { get; set; }//Amount
        public decimal DynamicPromotedDiscount { get; set; }//Percentage
        public decimal DynamicCalTargetPromotedDiscount { get; set; }//Amount
        public decimal ProductDiscount { get; set; }//Percentage
        public decimal CalculatedProductDiscount { get; set; }//Amount
        public decimal CurrentProductDiscountQuantity { get; set; }
        public decimal TotalProductDiscountQuantity { get; set; }
        public decimal AdditionalDiscountPercentage { get; set; }
        public decimal AllItemDiscount { get; set; }
        public decimal OriginalAllItemDiscount { get; set; }
        public decimal CalculatedAllItemPromotedDiscount { get; set; }
        public decimal AdditionalDiscount { get; set; }
        public decimal PromotedDiscount { get; set; }

        public int StockStatusId { get; set; }
        public int Sequence { get; set; }
        public decimal StockTolerance { get; set; }
        public decimal StorageTolerance { get; set; }
        public decimal WeightTolerance { get; set; }
        public List<ItemStockBatches> ItemStockBatches { get; set; }
        public List<ItemStockBatches> OrderDetailsBatches { get; set; }
        public List<ItemStockBatches> ReturnDetailsBatches { get; set; }
        public List<ItemStockBatches> SelectedBatches { get; set; }
        public List<ItemStockBatches> DeductedBatches;
        public List<ItemStockBatches> DiscrepancyBatches { get; set; }
        public decimal PickerCount { get; set; }
        public decimal FormanCount { get; set; }
        public bool MismatchCounting { get; set; }
        public decimal OrderdQuantity { get; set; }

        public decimal RechargeValue { get; set; } // For ICash Topup
        public decimal RechargeQuantity { get; set; } // For ICash Topup
        public decimal BonusValue { get; set; } // For ICash Topup
        public decimal BonusQuantity { get; set; } // For ICash Topup
        public string SerialNo { get; set; }
        public List<TemplateFieldModel> TemplateFields { get; set; }
        public int MainDivisionId { get; set; }
        public int DivisionEmployeeID { get; set; }
        public List<string> ParentsSerialsList { get; set; }
        public List<string> ChildsSerialsList { get; set; }
        public List<ItemPackModel> NonPackageOpenedChildSerials { get; set; }
        public bool RecalledBySerial { get; set; }
        public bool RecalledByBatch { get; set; }
        public string Notes { get; set; }
        public int SerialStatusId { set; get; }
        public bool IsPackageOpenedSerial { set; get; }
        public string TransactionId { set; get; }
        public DataActions DataAction { get; set; }
        public decimal OriginalQuantity { get; set; }
        public RecallInternalOperationTypes RecallOperation { get; set; }
        public string PartyCodeName { get; set; }
        public string SSCCBarcode { get; set; }
        public int PackTrimSerialStartDigits { get; set; }
        public int PackTrimSerialEndDigits { get; set; }
        public bool PackHasTrimSerialRule { get; set; }
        public bool HasSecondaryPack { get; set; }
        public bool IsChecked { get; set; }
        public bool Enabled { get; set; }
        public int ValueType { get; set; }
        public string Serial { get; set; }
        public CompetitorModel Competitor { get; set; }
        public List<CompetitorModel> CompetitorsList { get; set; }
        public int TargetPackID { get; set; }
        public decimal TargetPackQty { get; set; }
        public int MinPackID { get; set; }
        public decimal MinPackQty { get; set; }
        public decimal PurchaseOrderQty { get; set; }
        public bool AllowCheckUpperLimit { get; set; }
        public decimal SeqFactor { get; set; }
        public int ProductionDateType { get; set; }
        public int ReturnReasonId { get; set; }
        public string CustomerPackBarcode { get; set; }
        public int SalesOrderTypeId { get; set; }
        public bool OrderItemIsApproved { get; set; }
        public decimal CustomerAppQuantity { get; set; }
        public int OrganizationId { get; set; }
        public string OrganizationCodeName { get; set; }
        public bool AllowFractionInQty { get; set; }
        public bool IsCustomerAppMostSelling { get; set; }
        public int CustomerAppMostSellingSequence { get; set; }
        public decimal ReturnDiscountPercentage { get; set; } // Percentage.return
        public decimal ReturnDiscountAmount { get; set; }
        public bool IsFromProductDiscount { get; set; }
        public decimal RelatedToTargetDiscount { get; set; }
        public bool HasReturnReason { get; set; }
        public bool OOSListMode { get; set; }
        public decimal MinimumQuantity { get; set; }
        public bool BooleanValue { get; set; }
        public decimal ProductDiscountPercentage { get; set; }
        public string Color { set; get; }
        public List<ItemPackModel> StockStatusItemsList { get; set; } // [BRF - CRM] (Pack stock status by color details.)
        public decimal MinPrice { get; set; } // [BRF - CRM] 
        public decimal MaxPrice { get; set; } // [BRF - CRM] 
        public decimal ApprovalPrice { get; set; } // [BRF - CRM] 
        public string SalesOrderTypeCodeName { get; set; }
        public string Icon { get; set; }
        public string IconColor { get; set; }
        public List<SalesOrderTypeModel> SalesOrderTypes { get; set; }
        public decimal ShelfIncentiveDiscountAmount { get; set; } // amount
        public decimal ShelfIncentiveDiscount { get; set; } // percentage
        public bool PriceEditable { get; set; } // stock status and sales order type colors BRF
        public bool DisableEditPrice { get; set; } 
        public decimal BundleGrossTotal { get; set; }
        public decimal BundleCalculatedTax { get; set; }
        public decimal BundleNetTotal { get; set; }
        public decimal TaxPercentage { get; set; } // FOR ZATCA
        public decimal BaseTaxPercentage { get; set; } // FOR ZATCA
        public decimal OriginalStockQty { get; set; }
        public bool IsExceedAvailableQty { get; set; }
        public decimal RemainingQuantity { get; set; }
        public bool IsMultiplyRepeatCount { get; set; }

        public ItemPackModel()
        {
            isNewExpireDateModel = new DateModel();
            DefaultPackId = -1;
            PromotionValue = 0;
            TaxIncludedInPrice = 0;
            IncludedTaxAmount = 0;
            ItemId = -1;
            ItemGroupID = -1;
            Quantity = -1;
            ItemCategoryId = -1;
            ModelId = -1;
            BrandId = -1;
            ItemTypeId = -1;
            AvailableQtyInPcs = 0;
            UsedQtyPCs = 0;
            _itemName = "";
            ItemCode = "";
            Model = "";
            Category = "";
            Brand = "";
            ItemDefinition = "";
            DivisionName = "";
            PackDefinition = "";
            PackId = -1;
            PackTypeId = -1;
            DiscountTypeId = 1;
            Price = 0;
            ReturnPrice = 0;
            BasePrice = 0;
            Discount = 0;
            Tax = 0;
            BaseTax = 0;
            Foc = 0;
            RequiredQty = 0;
            OldRequiredQty = 0;
            Barcode = "";
            Uom = "";
            BatchNo = "";
            ExpiryDateModel = new DateModel();
            DivisionId = -1;
            NetTotal = 0;
            GrossTotal = 0;
            CalculatedTax = 0;
            CalculatedBaseTax = 0;
            CalculatedDiscountTotal = 0;
            CalculatedDiscount = 0;
            CalculatedPromotedDiscount = 0;
            ExpiryDate = new DateTime();
            ProductionDate = new DateTime();
            ExpiryDateModel = new DateModel();
            ProductionDateModel = new DateModel();
            //PackStatusId = PackStatus.None.GetHashCode();
            PackStatusId = -1;
            Balanced = false;
            ExistingQty = 0;
            OldRequiredQty = 0;
            DivisionId = -1;
            UsedPriceListId = -1;
            ReturnUsedPriceListID = -1;
            _salesTransactionTypeId = SalesTransactionTypes.None;
            ConsumerPriceListId = -1;
            FOCTypeId = -1;
            ReasonId = -1;
            SerialNo = string.Empty;
            ItemStockBatches = new List<ItemStockBatches>();
            SelectedBatches = new List<ItemStockBatches>();
            DiscrepancyBatches = new List<ItemStockBatches>();
            DeductedBatches = new List<ItemStockBatches>();
            ReturnDetailsBatches = new List<ItemStockBatches>();
            ParentsSerialsList = new List<string>();
            ChildsSerialsList = new List<string>();
            NonPackageOpenedChildSerials = new List<ItemPackModel>();
            SerialSeparator = string.Empty;
            IsChecked = false;
            TaxableAmount = 0;
            Enabled = false;
            ValueType = 1;
            PriceString = string.Empty;
            PalletBarcode = string.Empty;
            VendorId = -1;
            PurchaseOrderQty = 0;
            AllowCheckUpperLimit = false;
            SalesRestrictionQuantity = 0;
            SeqFactor = 1;
            ProductionDateType = ItemProductionDateTypes.None.GetHashCode();
            ReturnReasonId = -1;
            DataAction = DataActions.NoChange;
            CustomerPackBarcode = string.Empty;
            CustomerAppQuantity = 0;
            OrganizationId = -1;
            OrganizationCodeName = string.Empty;
            AllowFractionInQty = false;
            ReSellable = false;
            ProductDiscount = 0;
            CalculatedProductDiscount = 0;
            CurrentProductDiscountQuantity = 0;
            TotalProductDiscountQuantity = 0;
            ReturnDiscountPercentage = 0;
            ReturnDiscountAmount = 0;
            IsFromProductDiscount = false;
            RelatedToTargetDiscount =0;
            IsReturnItem = false;
            RequiredReturnQty = 0;
            OldRequiredReturnQty = 0;
            InSCS = true;
            InStock = true;
            SalesOrderTypeName = string.Empty;
            HasReturnReason = false;
            OOSListMode = false;
            MinimumQuantity = 0;
            BooleanValue = false;
            ChildPackId = -1;
            AttachmentList = new List<string>();
            ProductDiscountPercentage = 0;
            Color = string.Empty;
            StockStatusItemsList = new List<ItemPackModel>();
            SalesOrderTypeCodeName = string.Empty;
            Icon = string.Empty;
            IconColor = string.Empty;
            SalesOrderTypes = new List<SalesOrderTypeModel>();
            ShelfIncentiveDiscountAmount = 0;
            ShelfIncentiveDiscount = 0;
            DisableEditPrice = false;
            PriceValue = 0;
            DiscountValue = 0;
            PromotionID = 0;
            BundlePrice = 0;
            PromotionOptionDetailTypeId = -1;
            BundleDiscount = 0;
            BundleGrossTotal = 0;
            BundleNetTotal = 0;
            BundleCalculatedTax = 0;
            PackQuantity = 0;
            OriginalAvailableQty = 0;
            OriginalStockQty = 0;
            OriginalPrice = 0;
            RemainingQuantity = 0;
            CalculatedHeaderDiscount = 0;
            StockStatusId = -1;
            IsMultiplyRepeatCount = false;
            LowStockQty = -1;
        }
        public ItemPackModel(ItemPackModel itemPack)
        {
            ItemId = itemPack.ItemId;
            PackId = itemPack.PackId;
            DivisionId = itemPack.DivisionId;
            ItemCategoryId = itemPack.ItemCategoryId;
            //ItemTypeId = itemPack.ItemTypeId;
            DefaultPackId = itemPack.DefaultPackId;

            PackTypeId = itemPack.PackTypeId;
            Quantity = itemPack.Quantity;
            RequiredQty = itemPack.RequiredQty;
            OldRequiredQty = itemPack.OldRequiredQty;
            RequestedQuantity = itemPack.RequestedQuantity;
            ExistingQty = itemPack.ExistingQty;
            ApprovedQuantity = itemPack.ApprovedQuantity;
            PiecesInPack = itemPack.PiecesInPack;

            ItemName = itemPack.ItemName;
            ItemCode = itemPack.ItemCode;
            ItemCodeName = itemPack.ItemCodeName;
            Uom = itemPack.Uom;

            ExpiryDate = itemPack.ExpiryDate;
            ExpiryDateModel = itemPack.ExpiryDateModel;
            BatchNo = itemPack.BatchNo;
            HasSerialNumber = itemPack.HasSerialNumber;

            Price = itemPack.Price;
            BasePrice = itemPack.BasePrice;
            PackStatusId= itemPack.PackStatusId;    
            Tax = itemPack.Tax;
            Discount = itemPack.Discount;
            BaseDiscount = itemPack.BaseDiscount;
            DiscountTypeId = itemPack.DiscountTypeId;
            BaseDiscountTypeId = itemPack.BaseDiscountTypeId;
            UsedPriceListId = itemPack.UsedPriceListId;

            Notes = itemPack.Notes;
            RecalledBySerial = itemPack.RecalledBySerial;
            RecalledByBatch = itemPack.RecalledByBatch;

            InSCS = itemPack.InSCS;
            InStock = itemPack.InStock;
            SalesTransactionTypeId = itemPack.SalesTransactionTypeId;
            SSCCBarcode = itemPack.SSCCBarcode;
            FOCTypeId = itemPack.FOCTypeId;
        }
    }

    public class EchoItemModel
    {
        public int ItemId { get; set; }
        public int ItemCategoryId { get; set; }
        public string ItemCode { get; set; }
        public decimal LowStockQty { get; set; }
        public bool IsInitiative { get; set; }
        public bool IsPowerSKU { get; set; }
        public bool IsNew { get; set; }
        public bool HasImage { get; set; }
        public bool IsBestSeller { get; set; }
        public int MainDivisionId { get; set; }
        public int DivisionId { get; set; }
        public int BrandId { get; set; }
        public string Division { get; set; }
        public string Category { get; set; }
        public string Brand { get; set; }
        public bool ItemCategoryInCustomerApp { get; set; }
        public bool BrandInCustomerApp { get; set; }
        public string ItemName { get; set; }
        public string ItemDefinition { get; set; }
        public decimal AvailableQtyInPcs { get; set; }
        public List<ItemPackModel> Packs { get; set; }
        public bool IsCustomerAppMostSelling { get; set; }

        public EchoItemModel()
        {
            ItemId = -1;
            Packs = new List<ItemPackModel>();
            ItemName = "";
        }

    }
    public class CRMItemPackModel
    {
        public string CategoryNameCode { get; set; }
        public int DefaultPackId { get; set; }
        public string PriceString { get; set; }
        public int WarehouseId { get; set; }
        private SalesTransactionTypes _salesTransactionTypeId;
        private DateTime _expiryDate;
        public string SalesOrderTypeName { set; get; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public int ItemId { get; set; }
        public int ItemGroupID { get; set; }
        public string ItemGroup { get; set; }
        public decimal Quantity { get; set; }
        public decimal PackQuantity { get; set; }
        public int ItemCategoryId { get; set; }
        public int BrandId { get; set; }
        public int ItemTypeId { get; set; }
        public decimal AvailableQtyInPcs { get; set; }
        public decimal OriginalAvailableQty { get; set; }
        public decimal ReservedQty { get; set; }
        public decimal StockQty { get; set; }
        public decimal BlockedQty { get; set; }
        public decimal UsedQtyPCs { get; set; }
        public string ItemCode { get; set; }
        public string ItemCodeName { get; set; }
        public bool HasImage { get; set; }
        public string ItemImage { get; set; }
        public bool Inactive { get; set; }
        public string ImagePath { get; set; }
        public int TransactionTypeId { get; set; }
        public int PromotionID { get; set; }
        public int PromotionOptionDetailTypeId { set; get; }
        public decimal OriginalPrice { get; set; }

        private string _itemName;
        public string ItemName
        {
            get
            {
                return _itemName;
            }
            set
            {
                if (string.IsNullOrEmpty(value))
                    this._itemName = "---";
                else
                    this._itemName = value;
            }
        }
        public string Model { get; set; }
        public string Category { get; set; }
        public string CategoryCode { get; set; }
        public string Brand { get; set; }
        public string PackDefinition { get; set; }
        public string ItemDefinition { get; set; }
        public string DivisionName { get; set; }
        public int PackStatusId { get; set; }
        public string PackStatusDescription { get; set; }
        public int DivisionId { get; set; }
        public int PackId { get; set; }
        public int PackTypeId { get; set; }
        public decimal PiecesInPack { get; set; }
        public decimal Price { get; set; }
        public decimal BasePrice { get; set; }
        public int UsedPriceListId { get; set; }
        public decimal Discount { get; set; }
        public decimal BaseDiscount { get; set; }
        public int DiscountTypeId { get; set; }
        public int BaseDiscountTypeId { get; set; }
        public decimal Tax { get; set; }
        public decimal BaseTax { get; set; }
        public string Barcode { get; set; }
        public string BatchNo { get; set; }
        public string Uom { get; set; }
        public SalesTransactionTypes SalesTransactionTypeId
        {
            get
            {
                return _salesTransactionTypeId;
            }
            set
            {
                _salesTransactionTypeId = value;
            }
        }
        public DateTime ExpiryDate
        {
            get { return _expiryDate; }
            set
            {
                _expiryDate = value;
                ExpiryDateModel = new DateModel(_expiryDate);
            }
        }

        public DateModel ExpiryDateModel { get; set; }
        public decimal RequiredQty { get; set; }
        public decimal OldRequiredQty { get; set; }
        public decimal ExistingQty { get; set; }
        public decimal NetTotal { get; set; }
        public decimal GrossTotal { get; set; }
        public decimal CalculatedTax { get; set; }
        public decimal CalculatedBaseTax { get; set; }
        public decimal CalculatedDiscount { get; set; }
        public decimal CalculatedDiscountTotal { get; set; }
        public decimal CalculatedPromotedDiscount { get; set; }
        public decimal ItemPromotedDiscount { get; set; }
        public decimal CalculatedItemPromotedDiscount { get; set; }
        public decimal AllItemDiscount { get; set; }
        public decimal OriginalAllItemDiscount { get; set; }
        public decimal CalculatedAllItemPromotedDiscount { get; set; }
        public decimal AdditionalDiscount { get; set; }
        public decimal PromotedDiscount { get; set; }
        public int StockStatusId { get; set; }
        public int Sequence { get; set; }
        public string Notes { get; set; }
        public string TransactionId { set; get; }
        public int SalesOrderTypeId { get; set; }
        public int OrganizationId { get; set; }
        public string OrganizationCodeName { get; set; }
        public bool BooleanValue { get; set; }
        public string Color { set; get; }
        public List<CRMItemPackModel> StockStatusItemsList { get; set; } // [BRF - CRM] (Pack stock status by color details.)
        public decimal MinPrice { get; set; } // [BRF - CRM] 
        public decimal MaxPrice { get; set; } // [BRF - CRM] 
        public decimal ApprovalPrice { get; set; } // [BRF - CRM] 
        public string Icon { get; set; }
        public string IconColor { get; set; }
        public bool PriceEditable { get; set; } // stock status and sales order type colors BRF
        public bool DisableEditPrice { get; set; }
        public decimal OriginalStockQty { get; set; }
        public bool IsExceedAvailableQty { get; set; }
        public bool InLastOrder { get; set; }
        public bool InLast30Days { get; set; }
        public bool InTop5 { get; set; }
        public decimal ListPrice { get; set; }

        public CRMItemPackModel()
        {
            DefaultPackId = -1;
            ItemId = -1;
            ItemGroupID = -1;
            Quantity = -1;
            ItemCategoryId = -1;
            BrandId = -1;
            ItemTypeId = -1;
            AvailableQtyInPcs = 0;
            UsedQtyPCs = 0;
            _itemName = "";
            ItemCode = "";
            Model = "";
            Category = "";
            Brand = "";
            ItemDefinition = "";
            DivisionName = "";
            PackDefinition = "";
            PackId = -1;
            PackTypeId = -1;
            DiscountTypeId = 1;
            Price = 0;
            BasePrice = 0;
            Discount = 0;
            Tax = 0;
            BaseTax = 0;
            RequiredQty = 0;
            OldRequiredQty = 0;
            Barcode = "";
            Uom = "";
            BatchNo = "";
            ExpiryDateModel = new DateModel();
            DivisionId = -1;
            NetTotal = 0;
            GrossTotal = 0;
            CalculatedTax = 0;
            CalculatedBaseTax = 0;
            CalculatedDiscountTotal = 0;
            CalculatedDiscount = 0;
            CalculatedPromotedDiscount = 0;
            ExpiryDate = new DateTime();
            ExpiryDateModel = new DateModel();
            //PackStatusId = PackStatus.None.GetHashCode();
            PackStatusId = -1;
            ExistingQty = 0;
            OldRequiredQty = 0;
            DivisionId = -1;
            UsedPriceListId = -1;
            _salesTransactionTypeId = SalesTransactionTypes.None;
            PriceString = string.Empty;
            OrganizationId = -1;
            OrganizationCodeName = string.Empty;
            SalesOrderTypeName = string.Empty;
            BooleanValue = false;
            Color = string.Empty;
            Icon = string.Empty;
            IconColor = string.Empty;
            DisableEditPrice = false;
            PromotionID = 0;
            PromotionOptionDetailTypeId = -1;
            PackQuantity = 0;
            OriginalAvailableQty = 0;
            OriginalStockQty = 0;
            OriginalPrice = 0;
        }
        public CRMItemPackModel(ItemPackModel itemPack)
        {
            ItemId = itemPack.ItemId;
            PackId = itemPack.PackId;
            DivisionId = itemPack.DivisionId;
            ItemCategoryId = itemPack.ItemCategoryId;
            ItemTypeId = itemPack.ItemTypeId;
            DefaultPackId = itemPack.DefaultPackId;

            PackTypeId = itemPack.PackTypeId;
            Quantity = itemPack.Quantity;
            RequiredQty = itemPack.RequiredQty;
            OldRequiredQty = itemPack.OldRequiredQty;
            ExistingQty = itemPack.ExistingQty;
            PiecesInPack = itemPack.PiecesInPack;

            ItemName = itemPack.ItemName;
            ItemCode = itemPack.ItemCode;
            ItemCodeName = itemPack.ItemCodeName;
            Uom = itemPack.Uom;

            ExpiryDate = itemPack.ExpiryDate;
            ExpiryDateModel = itemPack.ExpiryDateModel;
            BatchNo = itemPack.BatchNo;
            Price = itemPack.Price;
            Tax = itemPack.Tax;
            Discount = itemPack.Discount;
            BaseDiscount = itemPack.BaseDiscount;
            DiscountTypeId = itemPack.DiscountTypeId;
            BaseDiscountTypeId = itemPack.BaseDiscountTypeId;
            UsedPriceListId = itemPack.UsedPriceListId;

            Notes = itemPack.Notes;
        }
    }
    public class ItemPackModelSimple
    {
        public int ItemId { get; set; }
        public int PackId { get; set; }
        public string ItemCode { get; set; }
        public string ItemName { get; set; }
        public string ItemCodeName { get; set; }
        public string Uom { get; set; }
        public ItemPackModelSimple()
        {
            ItemId = -1;
            PackId = -1;
            ItemCode = string.Empty;
            ItemName = string.Empty;
            ItemCodeName = string.Empty;
            Uom = string.Empty;
        }
    }

    public class ItemCategoryModel
    {
        public ItemCategoryModel()
        {
            ItemsList = new List<ItemPackModel>();
        }

        public string Code { set; get; }
        public int ItemCategoryId { set; get; }
        public string Name { set; get; }
        public List<ItemPackModel> ItemsList { set; get; }
        public int DivisionId { get; set; }

        public string NameCodeString
        {
            get
            {
                return string.Format("{0} - {1}", Code, Name);
            }
        }
    }
    public class CRMItemCategoryModel
    {
        public CRMItemCategoryModel()
        {
            ItemsList = new List<CRMItemPackModel>();
        }

        public string Code { set; get; }
        public int ItemCategoryId { set; get; }
        public string Name { set; get; }
        public List<CRMItemPackModel> ItemsList { set; get; }
        public int DivisionId { get; set; }

        public string NameCodeString
        {
            get
            {
                return string.Format("{0} - {1}", Code, Name);
            }
        }
    }
    public class ItemDiscountModel
    {
        public ItemDiscountModel()
        {
            SalesOrderTypeId = -1;
        }
        public int PackId { set; get; }
        public int DiscountTypeId { set; get; }
        public decimal Discount { set; get; }
        public int SalesOrderTypeId { set; get; }

    }
    public class PackTypeModel
    {
        public int PackTypeId { get; set; }
        public string PackTypeName { get; set; }
        public List<TextLanguage> DescriptionLanguages { set; get; }
        public int ItemId { get; set; }

        public PackTypeModel()
        {
            PackTypeId = -1;
            PackTypeName = string.Empty;
            DescriptionLanguages = new List<TextLanguage>();
            ItemId = -1;
        }
    }
    public class ItemTypeModel
    {
        public int ItemTypeId { get; set; }
        public string ItemTypeName { get; set; }
    }
    public class Item_Model
    {
        public int BrandId { get; set; }
        public int modelId { get; set; }
        public string modelName { get; set; }

        public string modelCodeName { get; set; }
        public Item_Model()
        {
            BrandId = -1;
            modelId = -1;
            modelName = string.Empty;
        }
    }
    public class ItemBrandModel
    {
        public int ItemBrandId { get; set; }
        public string ItemBrandName { get; set; }
    }

    public class ItemListModel
    {
        public int ItemListId { get; set; }
        public string ItemListName { get; set; }
        public string ItemListCode { get; set; }
        public string ItemListType { get; set; }
        public int ItemListTypeId { get; set; }
        public string ItemListCodeName { get; set; }
        public GeneralFilter Filter { get; set; }

        public List<ItemPackModel> items { get; set; }
        public List<int> itemsId { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public List<SimpleCustomerModel> AppliedCustomers { get; set; }
        public List<EmployeeModel> AppliedEmployees { get; set; }
        public List<CustomerGroupModel> AppliedGroups { get; set; }
        public List<CustomerChannelModel> AppliedChannels { get; set; }
        public List<SecurityGroupModel> AppliedSecurityGroups { get; set; }
        public List<OrganizationModel> AppliedOrganizations { get; set; }
        public int OrganizationId { get; set; }
        public string OrganizationCodeName { get; set; }
        public bool AllCustomers { get; set; }
        public bool AllEmployees { get; set; }
        public DateModel StartDateModel { get; set; }
        public DateModel EndDateModel { get; set; }
        private DateTime _startDate = DateTime.Now;
        private DateTime _endDate = DateTime.Now;
        public DateTime StartDate
        {
            get { return _startDate; }
            set
            {
                _startDate = value;
                if (_startDate != null)
                    StartDateModel = new DateModel(_startDate);
            }
        }
        public DateTime EndDate
        {
            get { return _endDate; }
            set
            {
                _endDate = value;
                if (_endDate != null)
                    EndDateModel = new DateModel(_endDate);
            }
        }
        public bool OOSListMode { get; set; }

    }
    public class PackGroupModel
    {
        public int PackGroupId { get; set; }
        public bool HasPromotion { get; set; }
        public string PackGroupName { get; set; }
        public string PackGroupCode { get; set; }
        public string PackGroupCodeName { get; set; }
        public int OrganizationID { get; set; }
        public List<PackModel> Packs { get; set; }
        public bool GetAllItemPacks { get; set; }
        public bool GetGroupsHavingSamePackQuantity { get; set; }
        public bool IncludePacks { get; set; }
        public string SelectedOraganizationIds { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public decimal GroupPackQuantity { get; set; }
        public List<int> AllowedPackGroupIds { get; set; }
        public int MasterPackGroupId { get; set; }
        public string SalesOrderTypeIds { get; set; }
        public string WarehouseIds { get; set; }
        public bool IsCRM { get; set; }
        public int ItemId { get; set; }
        public int PromotionId { get; set; }
        public int PromotionOptionDetailTypeID { get; set; }
        public int PromotionOptionID { get; set; }
        public int PromotionOptionDetailID { get; set; }
        public bool IsSkipPromotion { get; set; }

        public PackGroupModel()
        {
            PackGroupId = -1;
            HasPromotion = false;
            PackGroupName = string.Empty;
            PackGroupCode = string.Empty;
            PackGroupCodeName = string.Empty;
            GroupPackQuantity = 0;
            MasterPackGroupId = -1;
            Packs = new List<PackModel>();
            DescriptionLanguages = new List<TextLanguage>();
            SalesOrderTypeIds = string.Empty;
            WarehouseIds = string.Empty;
            IsCRM = false;
            ItemId = -1;
            PromotionId = -1;
            PromotionOptionDetailTypeID = -1;
            PromotionOptionID = -1;
            PromotionOptionDetailID = -1;
            IsSkipPromotion = false;
        }
    }

    public class MasterPackGroupModel
    {
        public int MasterPackGroupId { get; set; }
        public string MasterPackGroupDescription { get; set; }
        MasterPackGroupModel()
        {
            MasterPackGroupId = -1;
            MasterPackGroupDescription = string.Empty;
        }
    }
    public class PackOperationModel
    {
        public int OperationId { get; set; }
        public string Operation { get; set; }
    }
    public class PackModel
    {
        public bool IsDefaultPack { get; set; }
        public string ItemCodeName { get; set; }
        public string PackTypeName { get; set; }
        public string PackName { get; set; }
        public string PackCode { get; set; }
        public string PackBarcode { get; set; }
        public string SerialSeparator { get; set; }
        public int PackTypeId { get; set; }
        public decimal Quantity { get; set; }
        public int PackId { get; set; }
        public int ItemId { get; set; }
        public bool HasSerialNumber { get; set; }
        public decimal Height { get; set; }
        public decimal Width { get; set; }
        public decimal Dipth { get; set; }
        public decimal Weight { get; set; }
        public decimal EquivalencyFactor { get; set; }
        public bool IsWeightPriced { get; set; }
        public bool  AllowFractionInQty { get; set; }
        public bool HasImage { get; set; }
        public bool IsCalculated { get; set; }
        public List<PackGroupModel> PackGroupsList { get; set; }//PackGroupsId
        public int Price { get; set; }
        public int BasePrice { get; set; }
        public int Discount { get; set; }
        public int PromotedDiscount { get; set; }
        public int ItemPromotedDiscount { get; set; }
        public int AllItemDiscount { get; set; }
        public int DiscountTypeId { get; set; }
        public int Tax { get; set; }
        public int BaseTax { get; set; }
        public int Foc { get; set; }
        public int OldRequiredQty { get; set; }
        public int NetTotal { get; set; }
        public int GrossTotal { get; set; }
        public int CalculatedDiscount { get; set; }
        public int CalculatedPromotedDiscount { get; set; }
        public int CalculatedDiscountTotal { get; set; }
        public int ConsumerPrice { get; set; }
        public int ConsumerPriceListId { get; set; }
        public int FOCTypeId { get; set; }

        public int ReasonId { get; set; }
        public int StockStatusId { get; set; }
        public int SalesTransactionTypeId { get; set; }
        public string DiscountString { get; set; }
        public string BatchNo { get; set; }
        public string ExpiryDateString { get; set; }
        public string PriceString { get; set; }
        public string Uom { get; set; }
        public int TemplateId { get; set; }
        public int PackGroupID { get; set; }
        public DataActions DataAction { get; set; }
        public string GTIN { get; set; }
        public List<PackOperationModel> PackOperationsList { get; set; }
        public int ChildPackId { get; set; }
        public int CompanyPrefix { get; set; }

        public PackModel()
        {
            TemplateId = -1;
            PackGroupID = -1;
            ChildPackId = -1;
            CompanyPrefix = -1;
        }
    }
    public class QueryParameter
    {
        public string ParameterName { set; get; }
        public DbType Type { set; get; }
        public object Value { set; get; }


        public QueryParameter()
        {
        }
    }
    public class ItemsFilter
    {
        public CustomListFilters CustomListFilter { get; set; }
        public int DivisionId { get; set; }
        public int ItemCategoryId { get; set; }
        public int BrandId { get; set; }
        public int ModelId { get; set; }
        public decimal PiecesInPack { get; set; }
        public int ItemId { get; set; }


        public bool IncludeInactive { get; set; }
        public bool IncludePowerSKU { get; set; }
        public bool IncludeNew { get; set; }
        public bool IncludeInitiative { get; set; }
        public bool ItemGroupMode { get; set; }
        public List<int> itemIdsList { get; set; }
        public List<int> excludedItemIdsList { get; set; }
        public int SelectedEmployeeId { get; set; }
        public bool ExcludeCompetitorItem { get; set; }
        public bool IsLazyLodingCombo { get; set; }
        public int SelectItemId { get; set; }
        public bool ShowUpperLimitOnly { get; set; }
        public bool isOosList { get; set; }
        public int StockWarehouseId { get; set; }
        public int DetailsWarehouseId { get; set; }
        public int RefWarehouseId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public TransactionMainTypes TransactionMainTypes { get; set; }
        public ItemFormProcessMode ProcessMode { get; set; }
        public string EditedTransactionId { get; set; }
        public WarehouseTransactionStatus Status { get; set; }
        public bool IncludeTax { get; set; }
        public string EditedTransactionItemIds { get; set; }
        public string EditedTransactionPackIds { get; set; }
        public string OrderSignature { get; set; }
        public int VendorId { get; set; }
        public bool IsQualityControl { get; set; }
        public bool AllowAddingNewItems { get; set; }
        public bool IsExecuteOperation { get; set; }
        public int RequestedBy { get; set; }
        public string SsccBarcode { get; set; }
        public bool IsFullyOffload { get; set; }
        public string ExcludedOrderId { get; set; }
        public bool ShowQuantityInOrder { get; set; }
        public int OrderTypeId { get; set; }
        public int ChildPackId { get; set; }
        public bool RestrictReturnFromInvoices { get; set; }
        public int ItemTypeId { get; set; }
        public int SDCId { get; set; }
        public string ItemCategoryIdsString { get; set; }
        public string ItemIdsString { get; set; }
        public string DivisionIdsString { get; set; }
        public string BrandIdsString { get; set; }
        public string ItemGroupIdsString { get; set; }
        public int PackTypeId { get; set; }
        public bool HasImage { get; set; }

        public bool checkExpireIsNew { get; set; }

        public ItemsFilter()
        {
            CustomListFilter = new CustomListFilters();
            DivisionId = -1;
            ItemCategoryId = -1;
            BrandId = -1;
            ModelId = -1;
            SelectItemId = -1;
            IncludeInactive = false;
            SelectedEmployeeId = -1;
            ExcludeCompetitorItem = false;
            ShowUpperLimitOnly = false;
            isOosList = false;
            ChildPackId = -1;
            RestrictReturnFromInvoices = false;
            ItemTypeId = -1;
            SDCId = -1;
            ItemCategoryIdsString = string.Empty;
            ItemIdsString = string.Empty;
            DivisionIdsString = string.Empty;
            PackTypeId = -1;
            HasImage = false;
            checkExpireIsNew = false;
        }
    }
    public class ItemStatusModel
    {
        private DateTime _expiryDate;
        public DateModel ExpiryDateModel { get; set; }
        public string ItemCodeName { get; set; }
        public string BatchNo { get; set; }
        public string Uom { get; set; }
        public DateTime ExpiryDate
        {
            get { return _expiryDate; }
            set
            {
                _expiryDate = value;
                ExpiryDateModel = new DateModel(_expiryDate);
            }
        }
        public string Status { get; set; }
        public decimal Quantity { get; set; }
        public int ItemId { get; set; }
        public int PackId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int WarehouseId { get; set; }
        public bool HasSerialNumber { get; set; }
    }
    public class ItemPack
    {
        /// <summary>
        /// This Model Using for Send echo order to android device ONLY
        /// </summary>

        public ItemPack()
        {
            ItemID = -1;
            PackID = -1;
            IsDefaultPack = false;
            DivisionID = -1;
            BrandID = -1;
            ItemCategoryID = -1;
            SalesTransactionTypeID = 1;
        }

        #region (Property)

        public int ItemID { get; set; }
        public string ItemDescription { get; set; }
        public string ItemCode { get; set; }
        public string ItemBarcode { get; set; }
        public int PackID { get; set; }
        public string UOM { get; set; }
        public decimal Price { get; set; }
        public decimal BasePrice { get; set; }
        public decimal Tax { get; set; }
        public decimal Discount { get; set; }
        public int UsedPriceList { get; set; }
        public decimal PiecesInPack { get; set; }
        public bool IsDefaultPack { get; set; }
        public int DiscountTypeID { get; set; }
        public int ItemCategoryID { get; set; }
        public int DivisionID { get; set; }
        public int BrandID { get; set; }
        public string ItemCategory { get; set; }
        public string Division { get; set; }
        public string Brand { get; set; }
        public int PackTypeID { get; set; }
        public decimal PromotedDiscount { get; set; }
        public decimal CalculatedDiscount { get; set; }
        public decimal RequiredQuanity { get; set; }
        public decimal RequestedQuantity { get; set; }
        public string ItemImageName { get; set; }
        public string VendorName { get; set; }
        public string CurrencyName { get; set; }
        public int SalesTransactionTypeID { get; set; }
        #endregion
    }
    public class ROIPackModel
    {
        public ROIPackModel()
        {
            PackId = -1;
        }

        #region (Property)

        public int PackId { get; set; }
        public int PriceListID { get; set; }
        public decimal Price { get; set; }
        public decimal Tax { get; set; }
        public bool ShowDiscountOnOperationLevel { get; set; }
        public bool ShowDiscountOnPackLevel { get; set; }

        #endregion
    }

    public class CompetitorModel
    {
        public CompetitorModel()
        {
            CompetitorId = -1;
            ItemId = -1;
        }
        public int CompetitorId { get; set; }
        public int OrganizationId { get; set; }
        public string CompetitorName { get; set; }
        public int ItemId { get; set; }
        public int CompetitorItemId { get; set; }
        public string CompetitorItemName { get; set; }
        public string ItemCodeName { get; set; }
    }

    public class ItemSerialOperations
    {
        public int ItemId { get; set; }
        public string ItemName { get; set; }
        public int ItemCategoryID { get; set; }
        public int DivisionId { get; set; }
        public string DivisionName { get; set; }
        public string ItemCategoryName { get; set; }
        public bool AllowReassign { get; set; }
        public bool AllowReturn { get; set; }
        public bool AllowCheckUpperLimit { get; set; }
        public bool BooleanValue { get; set; }
        public int ValueType { get; set; }
    }

    public class FirstOrderItemAssignment
    {
        public int OrganizationId { get; set; }
        public List<ItemPackModel> ItemPacks { get; set; }
        FirstOrderItemAssignment()
        {
            OrganizationId = -1;
            ItemPacks = new List<ItemPackModel>();
        }
    }

    public class ItemsListFilter
    {
        public int itemListID { get; set; }
        public int itemListType { get; set; }
        public bool oosListMode { get; set; }
    }

    public class SimpleItemPackModel
    {
        public int ItemId { get; set; }
        public int PackId { get; set; }
        public SimpleItemPackModel()
        {
            ItemId = -1;
            PackId = -1;
        }
    }
    public class CRMCustomerModel
    {
        public string CustomerSignature { get; set; }
        public string WarehouseIds { get; set; }
        public int CustomerOrganizationId { get; set; }
    }
    public class CRMPromotionItem
    {
        public int PackId { get; set; }
        public string SalesOrderTypeIDs { get; set; }
        public int ItemId { get; set; }
        public int PromotionId { get; set; }
        public string Description { get; set; }
        public string PromotionIds { get; set; }
        public string PromotionDetailsDescription { get; set; }
        public int PromotionOptionTypeID { get; set; }
        public int PackGroupID { get; set; }
        public int PromotionOptionDetailTypeID { get; set; }
        public int PromotionOptionID { get; set; }
        public int PromotionOptionDetailID { get; set; }
    }

    public class AvaliableItems
    {
        public string ItemCodeName { get; set; }
        public decimal AvailableQtyInPcs { get; set; }
    }
}