﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class ItemStockBatches
    {
        private DateTime _expiryDate;
        public int ItemId { get; set; }
        public int PackId { get; set; }
        public int PackStatusId { get; set; }
        public string BatchNo { get; set; }
        public DateTime ExpiryDate {
            get { return _expiryDate; }
            set
            {
                _expiryDate = value;
                ExpiryDateModel = new DateModel(_expiryDate);
            }
        }
        public DateModel ExpiryDateModel { get; set; }
        public decimal AvailableQtyInPcs { get; set; }

        public decimal PiecesInPack { get; set; }
        public decimal ActualAvailableQtyInPcs { get; set; }
        public decimal VehicleAvailableQtyInPCs { get; set; }
        public decimal PendingQtyInPcs { get; set; }
        public decimal WarehouseAvailableQtyInPCs { get; set; }
        public decimal ReservedQtyInPCs { get; set; }
        public decimal ForemanCount { get; set; }
        public decimal RequiredQty { get; set; }
        public decimal Quantity { get; set; }
        public bool IsNewBatch { get; set; }
        public int WarehouseId { get; set; }
        public decimal StartReading { get; set; }
        public decimal EndReading { get; set; }
        public int SalesTransactionTypeId { get; set; }
        public string SSCCBarcode { get; set; }
        public ItemStockBatches()
        {
            ItemId = -1;
            PackId = -1;
            PackStatusId = -1;
            BatchNo = string.Empty;
            AvailableQtyInPcs = 0;
            ActualAvailableQtyInPcs = 0;
            ForemanCount = 0;
            RequiredQty = 0;
            IsNewBatch = false;
            SalesTransactionTypeId = -1;
            SSCCBarcode = string.Empty;
        }
        public ItemStockBatches(ItemPackModel packModel)
        {
            ItemId = packModel.ItemId;
            PackId = packModel.PackId;
            BatchNo = packModel.BatchNo;
            ExpiryDate = packModel.ExpiryDate;
            RequiredQty = packModel.RequiredQty;
            PackStatusId = packModel.PackStatusId;
            SalesTransactionTypeId = packModel.SalesTransactionTypeId.GetHashCode();
            AvailableQtyInPcs = 0;
            ActualAvailableQtyInPcs = 0;
            ForemanCount = 0;
            IsNewBatch = false;
            WarehouseId = -1;
        }

    }
}
