﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;

namespace Sonic.Web.Model
{
    public class PriceModel
    {
        public int PriceListId{ get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int PackId { get; set; }
        public decimal Price { get; set; }
        public decimal Tax { get; set; }
        public decimal Discount { get; set; }
        public decimal RetailPrice { get; set; }
        public decimal RetailTax { get; set; }
        public decimal RetailValue { get; set; }
    }
    public class PriceListModel
    {
      public  PriceListModel()
        {
            AppliedCustomers = new List<SimpleCustomerModel>();
            NewlyAddedCustomers = new List<SimpleCustomerModel>();
            AppliedGroups = new List<CustomerGroupModel>();
            NewlyAddedGroups = new List<CustomerGroupModel>();
            AppliedChannels = new List<CustomerChannelModel>();
            NewlyAddedChannels = new List<CustomerChannelModel>();
            PriceListDescriptionLanguages = new List<TextLanguage>();
            PriceListItems = new List<PriceListItemsModel>();
            DeletedPriceListItems = new List<PriceListItemsModel>();
            PriceListAuditDetails = new List<PriceAuditDetailsModel>();
            PriceStatusName = string.Empty;
            RejectNote = string.Empty;
            SalesOrderTypeId = -1;
            StockStatusId = -1;
            AppliedSDCs = new List<SalesDistributionChannelModel>();
            NewlyAddedSDCs = new List<SalesDistributionChannelModel>();
            RequestCustomers = new List<PendingPriceListModel>();

        }
        private DateTime? _startDate=DateTime.Now;
        private DateTime? _endDate = DateTime.Now;
        public int OrganizationId { get; set; }
        public string OrganizationName { get; set; }
        public string OrganizationCodeName { get; set; }
        public string CustomerCodeName { get; set; }

        public int PriceListTypeId { get; set; }
        public int StockStatusId { get; set; }
        public int SalesOrderTypeId { get; set; }
        public string PriceListType { get; set; }
        public int PriceListId { get; set; }
        public string PriceListName { get; set; }
        public string PriceListCode { get; set; }
        [JsonIgnore]
        public DateTime? StartDate
        {
            get { return _startDate; }
            set
            {
                _startDate = value;
                if (_startDate != null)
                    StartDateModel = new DateModel(_startDate.Value);
            }
        }
        [JsonIgnore]
        public DateTime? EndDate
        {
            get { return _endDate; }
            set
            {
                _endDate = value;
                if (_endDate != null)
                    EndDateModel = new DateModel(_endDate.Value);
            }
        }
        public DateModel StartDateModel { get; set; }
        public DateModel EndDateModel { get; set; }
        public int Priority { get; set; }
        public List<SimpleCustomerModel> AppliedCustomers { get; set; }

        public List<PendingPriceListModel> RequestCustomers { get; set; }

        public List<SimpleCustomerModel> NewlyAddedCustomers { get; set; }

        public List<CustomerGroupModel> AppliedGroups { get; set; }
        public List<CustomerGroupModel> NewlyAddedGroups { get; set; }

        public List<CustomerChannelModel> AppliedChannels { get; set; }
        public List<CustomerChannelModel> NewlyAddedChannels { get; set; }

        public List<TextLanguage> PriceListDescriptionLanguages { get; set; }
        public List<PriceListItemsModel> PriceListItems { get; set; }
        public List<PriceListItemsModel> DeletedPriceListItems { get; set; }
        public List<PriceAuditDetailsModel> PriceListAuditDetails { get; set; }
        public string PriceStatusName { get; set; }
        public bool IsPending { set; get; }
        public int Status { set; get; }
        public string RejectNote { set; get; }
        public bool IsDeleted { set; get; }
        public bool IsDefault { set; get; }

        public bool ShowApprove { set; get; }
        public bool ShowRequest { set; get; }
        public bool IsApprove { set; get; }
        public bool ShowEdit { set; get; }
        public bool ShowDelete { set; get; }
        public bool IsCreationLevel { set; get; }
        public bool ShowViewOriginal { set; get; }
        public List<SalesDistributionChannelModel> AppliedSDCs { set; get; }
        public List<SalesDistributionChannelModel> NewlyAddedSDCs { set; get; }
    }

    public class PendingPriceListModel {

        public PendingPriceListModel()
        {
            StatusId = -1;
            OutletId = -1;
            CustomerId = -1;
            OrganizationId = -1;


        }

        private DateTime? _requestDate = DateTime.Now;

        public DateTime? RequestDate
        {
            get { return _requestDate; }
            set
            {
                _requestDate = value;
                if (_requestDate != null)
                    RequestDateModel = new DateModel(_requestDate.Value);
            }
        }

        public DateModel RequestDateModel { get; set; }
        public int RequestID { get; set; }

        public int OrganizationId { get; set; }
        public int CustomerId { get; set; }

        public int OutletId { get; set; }

        public int StatusId { get; set; }

        public int UpdateBy { get; set; }

        public string EmployeeName { get; set; }

        public string OrganizationCodeName { get; set; }
        public string CustomerCodeName { get; set; }

        public string StatusDescription { get; set; }

        public string OutletCodeName { get; set; }
        
        public string Reason { get; set; }

        public bool isPending { set; get; }

        public bool isRejected { set; get; }


    }

    public class PriceListAuditModel
    {
        public int PriceListId { get; set; }
        public int PriceListAuditId { get; set; }
        public int ActionId { get; set; }
    }
    public class PriceAuditDetailsModel
    {
        public int AuditId { get; set; }
        public int FieldNumber { get; set; }
        public string FieldName { get; set; }
        public string OldValue { get; set; }
        public string NewValue { get; set; }

    }
    public class PriceListItemsModel
    {
        private DateTime? _expiryDate;
        public string ItemCodeName { get; set; }
        public string ItemName { get; set; }
        public string ItemCode { get; set; }
        public string Uom { get; set; }
        public string CurrencyCodeName { get; set; }
        public int PriceListId { get; set; }
        public int PriceDefinitionId { get; set; }
        public int ItemId { get; set; }
        public int PackId { get; set; }
        public int CurrencyId { get; set; }
        public decimal Price { get; set; }
        public decimal Tax { get; set; }
        public decimal MinPrice { get; set; }
        public decimal MaxPrice { get; set; }
        public decimal NetPrice { get; set; }
        public int QuantityRangeId { get; set; }
        public int OldQuantityRangeId { get; set; }
        public string BatchNo { get; set; }
        public DateTime? ExpiryDate
        {
            get { return _expiryDate; }
            set
            {
                _expiryDate = value;
                if (_expiryDate != null)
                    ExpiryDateModel = new DateModel(_expiryDate.Value);
            }
        }
        public DateModel ExpiryDateModel { get; set; }
        public DataActions DataAction { get; set; }
        public List<PriceAuditDetailsModel> PriceDefinitionAuditDetails { get; set; }
        public List<TaxTypesModel> TaxTypes { get; set; }
    }
    public class PriceListTypesModel
    {
        public int PriceListTypeId { get; set; }
        public string PriceListTypeName { get; set; }
    }

    public class QuantityRange
    {
        public int QuantityRangeId { get; set; }
        public string Range { get; set; }
        public decimal RangeStart { get; set; }
        public decimal RangeEnd { get; set; }

        public QuantityRange()
        {
            QuantityRangeId = -1;
            Range = string.Empty;
            RangeStart = default;
            RangeEnd = default;
        }
    }
}