﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class PriceRangeModel
    {
        public int PriceListId { get; set; }
        public int PackId { get; set; }
        public decimal Quantity { get; set; }
        public decimal Price { get; set; }
        public decimal BasePrice { get; set; }
        public decimal Tax { get; set; }
        public decimal RangeStart { get; set; }
        public decimal RangeEnd { get; set; }
        public bool IsReturnItem { get; set; }
        public decimal TaxIncludedInPrice { get; set; }
        public decimal MinPrice { get; set; }
        public decimal MaxPrice { get; set; }

        public PriceRangeModel()
        {
            PackId = -1;
            PriceListId = -1;
            TaxIncludedInPrice = -1;
            Quantity = default;
            Price = default;
            BasePrice = default;
            Tax = default;
            RangeStart = default;
            RangeEnd = default;
            IsReturnItem = false;
            MinPrice = 0;
            MaxPrice = 0;
        }
    }

}
