﻿using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class KeyLimitModel
    {
        public int ChangeHistoryId { get; set; }
        public int RouteHistoryId { get; set; }
        public int CustomerId { get; set; }
        public string CustomerCodeName { get; set; }
        public string CustomerDescription { get; set; }
        public List<TextLanguage> CustomerName { get; set; }
        public int OutletId { get; set; }
        public string OutletCodeName { get; set; }
        public int DivisionId { get; set; }
        public string TransactionId { get; set; }
        public int ItemId { get; set; }
        public string ItemCodeName { get; set; }
        public int PackId { get; set; }
        public string PackCodeName { get; set; }
        public decimal OldLowerRange { get; set; }
        public decimal OldUpperRange { get; set; }
        public decimal NewRequestedValue { get; set; }
        public decimal NewLowerRange { get; set; }
        public decimal NewUpperRange { get; set; }
        public int StatusId { get; set; }
        public int RequestedBy { get; set; }
        public string EmployeeName { get; set; }
        public int TypeId { get; set; }
        public string Type { get; set; }
        public DateModel RequestedDateModel { get; set; }
        public int ProcessedBy { get; set; }
        public string MessageID { get; set; }
        public string MessageBody { get; set; }
        public string SendEmployeeKey { get; set; }
        public int KeyTypeID { get; set; }
        public int LanguageId { get; set; }
        public string SenderDeviceToken { get; set; }
        public bool IsBOReceiver { get; set; }
        public bool IsBOSender { get; set; }
        public EditPriceKeyMode EditPriceKeyMode { get; set; }
        public EditDiscountKeyMode EditDiscountKeyMode { get; set; }

        public DateTime ProcessedDate { get; set; }
        private DateTime? _requestedDate;
        public DateTime? RequestedDate
        {
            get { return _requestedDate; }
            set
            {
                _requestedDate = value;
                if (_requestedDate != null)
                    RequestedDateModel = new DateModel(_requestedDate.Value);
            }
        }
        public KeyLimitModel()
        {
            RouteHistoryId = -1;
            DivisionId = -1;
        }
    }
}

