﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class Country
    {
        public int CountryId { get; set; }
        public string CountryCode { get; set; }
        public string CountryName { get; set; }
        public List<TextLanguage> Descriptions { get; set; }
        public string CountryPrefixCode { get; set; }
        public string PrefixCode { get; set; }

        public Country()
        {
            Descriptions = new List<TextLanguage>();
            CountryPrefixCode = string.Empty;
            PrefixCode = string.Empty;
        }
    }

    public class State
    {
        public int CountryId { get; set; }
        public int StateId { get; set; }
        public string StateCode { get; set; }
        public string StatessName { get; set; }
        public List<TextLanguage> Descriptions { get; set; }
        public State()
        {
            Descriptions = new List<TextLanguage>();
        }
    }

    public class City
    {
        public int CountryId { get; set; }
        public int StateId { get; set; }
        public int CityId { get; set; }
        public string CityCode { get; set; }
        public string CityName { get; set; }
        public List<TextLanguage> Descriptions { get; set; }
        public City()
        {
            Descriptions = new List<TextLanguage>();
        }
    }

    public class Area
    {
        public int CountryId { get; set; }
        public int StateId { get; set; }
        public int CityId { get; set; }
        public int AreaId { get; set; }
        public string AreaCode { get; set; }
        public string AreaName { get; set; }
        public List<TextLanguage> Descriptions { get; set; }
        public Area()
        {
            Descriptions = new List<TextLanguage>();
        }
    }

    public class Street
    {
        public int CountryId { get; set; }
        public int StateId { get; set; }
        public int CityId { get; set; }
        public int AreaId { get; set; }
        public int StreetId { get; set; }
        public string StreetCode { get; set; }
        public string StreetName { get; set; }
        public List<TextLanguage> Descriptions { get; set; }
        public Street()
        {
            Descriptions = new List<TextLanguage>();
        }
    }

    public class LocationModel
    {
        public int RouteId { get; set; }
        public int CountryId { get; set; }
        public string CountryCode { get; set; }
        public string CountryName { get; set; }
        public string CountryCodeName { get; set; }

        public int StateId { get; set; }
        public string StateCode { get; set; }
        public string StateName { get; set; }
        public string StateCodeName { get; set; }

        public int CityId { get; set; }
        public string CityCode { get; set; }
        public string CityName { get; set; }
        public string CityCodeName { get; set; }

        public int AreaId { get; set; }
        public string AreaCode { get; set; }
        public string AreaName { get; set; }
        public string AreaCodeName { get; set; }

        public string LocationCodeName { get; set; }
    }
}
