﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model.Location
{
    public class LocationHierarchyModel
    {
        public int CountryId { get; set; }
        public int StateId { get; set; }
        public int CityId { get; set; }
        public int AreaId { get; set; }
        public int StreetId { get; set; }
        public string Code { get; set; }
        public bool IsEditMode { get; set; }
        public GeographicalLocationHierarchyLevel GeographicalLocationHierarchyLevel { get; set; }
        public List<TextLanguage> Descriptions { get; set; }
        public string NodeName { get; set; }
        public string NodeCode { get; set; }
        public int NodeId { get; set; }
        public bool IsParent { get; set; }
        public int ParentId { get; set; }
        public string DummyCode { get; set; }
        public List<LocationHierarchyModel> Children { set; get; }



        public LocationHierarchyModel()
        {
            CountryId = -1;
            StateId = -1;
            CityId = -1;
            AreaId = -1;
            StreetId = -1;
            NodeId = -1;
            ParentId = -1;
            IsParent = false;
            IsEditMode = false;
            Code = string.Empty;
            Descriptions = new List<TextLanguage>();
            Children = new List<LocationHierarchyModel>();
        }
    }

    public class LocationHierarchyFilter
    {
        public int? ParentId { get; set; }
        public string SearchFilter { get; set; }
        public GeographicalLocationHierarchyLevel locationHierarchyLevel { get; set; }
    }


}
