﻿using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Sonic.Web.Model
{
	public class NotificationTextLanguage
	{
		public NotificationTextLanguage()
		{
			LanguageId = -1;
			HeaderDescription = string.Empty;
			BodyDescription = string.Empty;
			SenderDescription = string.Empty;
		}
		public string NotificationId { set; get; }
		public string HeaderDescription { get; set; }
		public string BodyDescription { get; set; }
		public string SenderDescription { get; set; }
		public int LanguageId { get; set; }
		public bool IsDefaultLanguage { get; set; }
	}
	public class NotificationModel
	{
		public NotificationModel()
		{
			SenderId = -1;
			ReceiverId = -1;
			TemplateId = -1;
			DeviceToken = string.Empty;
			ReceiversList = new List<int>();
			DeviceTokenList = new List<string>();
			DescriptionsList = new List<NotificationTextLanguage>();
            jsonBody = string.Empty;
        }
		public string NotificationId { set; get; }
		public TransactionModel TransactionModel { set; get; }
		public NotificationTypes NotificationTypeId { set; get; }
		public int TemplateId { set; get; }
		public int SenderId { set; get; }
		public int ReceiverId { set; get; }
		public string DeviceToken { set; get; }
		public string SenderCode { set; get; }
		public bool IsRead { set; get; }
		public bool IsBOUser { set; get; }
		public DateTime NotificationDate { set; get; }
		public DateTime ReadingDate { set; get; }
		public List<int> ReceiversList { set; get; }
		public List<string> DeviceTokenList { set; get; }
		public List<NotificationTextLanguage> DescriptionsList { set; get; }
		public string HeaderDescription { get; set; }
		public string BodyDescription { get; set; }
		public string SenderDescription { get; set; }
		public int LanguageId { get; set; }
		public bool IsDefaultLanguage { get; set; }
		public EmployeeKeysOnline EmployeeKeyModel { get; set; }
		public KeyLimitModel DiscountKeyModel { get; set; }
		public int CustomerId { get; set; }
		public int OutletId { get; set; }
		public int EmployeeId { get; set; }
		public KeyTypes KeyTypeId { get; set; }
        public string jsonBody { get; set; }
    }
	public class NotificationTemplateModel
	{
		public NotificationTemplateModel()
		{
			TemplateId = -1;
			DescriptionsList = new List<TextLanguage>();
			HeaderDescriptionsList = new List<TextLanguage>();
			BodyDescriptionsList = new List<TextLanguage>();
		}
		public int TemplateId { set; get; }
		public string Description { set; get; }
		public string HeaderDescription { set; get; }
		public string BodyDescription { set; get; }
		public NotificationTypes NotificationTypeId { set; get; }
		public string NotificationTypeName { set; get; }
		public bool Inactive { set; get; }
		public string TemplateStatuName { set; get; }
		public List<TextLanguage> DescriptionsList { set; get; }
		public List<TextLanguage> HeaderDescriptionsList { set; get; }
		public List<TextLanguage> BodyDescriptionsList { set; get; }
	}
	public class NotificationTypeModel
	{
		public NotificationTypeModel()
		{
		}
		public NotificationTypes NotificationTypeId { set; get; }
		public string NotificationTypeName { set; get; }
	}
	public class RecallNotificationTextLanguage : NotificationTextLanguage
	{
		public RecallNotificationTextLanguage()
		{
			TransactionId = string.Empty;
			TemplateId = -1;
		}
		public RecallInternalPartyTypes RecallInternalPartyType { set; get; }
		public string TransactionId { set; get; }
		public int TemplateId { set; get; }
	}
	public class SetNotificationAsReadModel
	{
		public SetNotificationAsReadModel()
		{
			ReceiverId = -1;
		}
		public string NotificationId { set; get; }
		public int ReceiverId { set; get; }
		public bool MarkAsRead { set; get; }
	}
	public class NotificationTemplateFilterModel
	{
		public int NotificationTypeId { get; set; }
		public CustomListFilters CustomListFilter { get; set; }
		public bool IncludeInactive { get; set; }
	public NotificationTemplateFilterModel()
		{
			NotificationTypeId = -1;
		}
	}
}
