﻿using System.Collections.Generic;
using InCube.Security;

namespace Sonic.Web.Model
{
    public class OrderListFilter
    {
        public CustomListFilters CustomListFilter { get; set; }
        private string _orderSignature;

        public OrderListFilter()
        {
            CustomListFilter = new CustomListFilters();
            CustomerId = -1;
            OutletId = -1;
            EmployeeId = -1;
            DivisionId = -1;
            DriverId = -1;
            ItemId = -1;
            ExcludeLinkedWithSSCC = false;
            OrderTypeId = -1;
            OrganizationId = -1;
            TerritoryId = -1;
            RouteId = -1;
            CustomerStatusId = -1;
            IsFromStorekeeper = false;
            CustomerConfigurations = new List<ConfigurationModel>();
            IsBundle = false;
            IsVendingMachine = false;
            hasUnlimitedFOC = false;
            IsFromReassignButton = false;
            GetSSCC = false;
            AreaId = -1;
            StreetId = -1;
            WarehouseId = -1;
        }
        public int OrganizationId { get; set; }
        public int WarehouseId { get; set; }
        public int TerritoryId { get; set; }
        public int RouteId { get; set; }
        public int CustomerStatusId { get; set; }
        public string OrderId { get; set; }
        public string ScanByOrderId { get; set; }
        public string EmployeeCode { get; set; }

        public int CustomerId { get; set; }

        public int OutletId { get; set; }

        public int EmployeeId { get; set; }

        public int DivisionId { get; set; }

        public int ItemId { get; set; }

        public int AreaId { get; set; }

        public int StreetId { get; set; }

        public string OrderSignature
        {
            get
            {

                return _orderSignature;
            }
            set
            {
                _orderSignature = value;
                if (!string.IsNullOrEmpty(_orderSignature))
                {
                    var tem = EncryptionManager.Instance.DecryptData(_orderSignature);
                    string[] IDs = tem.Split(EncryptionManager.Instance.SignatureSeparator.ToCharArray());
                    OrderId = IDs[0];
                    CustomerId = int.Parse(IDs[1]);
                    OutletId = int.Parse(IDs[2]);
                    EmployeeId = int.Parse(IDs[3]);
                    DivisionId = int.Parse(IDs[4]);
                }

            }
        }
        public List<DateModel> OrderDateRange { get; set; }
        public List<DateModel> DesiredDeliveryDateRange { get; set; }
        public List<DateModel> AssignmentDateRange { get; set; }
        public List<DateModel> RejectDateRange { get; set; }//reema
        public OrderStatus OrderStatus { get; set; }

        public OrderOperation OrderOperation { get; set; }

        public bool IsViewMode { set; get; }
        public bool IsFromStorekeeper { set; get; }
        public bool GetSSCC { set; get; }
        public int DriverId { get; set; }
        public bool GetAllData { get; set; }
        public bool ExcludeLinkedWithSSCC { get; set; }
        public int OrderTypeId { get; set; }
        public List<ConfigurationModel> CustomerConfigurations { get; set; }
        public bool IsBundle { get; set; }
        public bool IsVendingMachine { get; set; }
        public bool IsFromReassignButton { get; set; }
        public bool hasUnlimitedFOC { get; set; }
        public List<ColumnModel> ExportColumns { get; set; }
        public string TableName { get; set; }
    }
}