﻿using Newtonsoft.Json;
using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using InCube.Security;

namespace Sonic.Web.Model
{
    public class OrderModel
    {
        #region [DECLERATIONS]

        private DateTime _desiredDeliveryDate;
        private DateTime _transactionDate;
        private DateTime _orderDate;
        private DateTime _scheduleDate;
        private DateTime _rejectDate;
        private DateTime _preparedDate;
        public bool IsThereAnyProductDiscountDefined { get; set; }
        public int CollectionMethod { get; set; }
        public bool isSsccGenerated { get; set; }
        public bool IsOrderInPreparation { get; set; }
        public bool IsNewWebOrder { get; set; }
        public int ssccWarehouseId { get; set; }
        public string ValidationMessage { get; set; }
        public string OrderApprovalStatusName { get; set; }
        public string OrderType { get; set; }
        public string deliveryLocation { get; set; }
        public List<AvaliableItems> AvaliableItemsQty { get; set; }
        public bool IsNotWarehouseStock { get; set; }
        public string CustomerRef { get; set; }

        public string RejectReason { get; set; }

        public string RejectNote { get; set; }
        public DateTime RejectDate
        {
            get { return _rejectDate; }
            set
            {
                _rejectDate = value;
                RejectDateModel = new DateModel();
            }
        }
        public DateTime PreparedDate
        {
            get { return _preparedDate; }
            set
            {
                _preparedDate = value;
                PreparedDateModel = new DateModel();
            }
        }


        public DateModel RejectDateModel { get; set; }
        public DateModel PreparedDateModel { get; set; }
        public int RecallId { get; set; }
        public int SalesMode { get; set; }
        public decimal ActualNetTotal { get; set; }
        public decimal IncludedTaxAmount { get; set; }
        public int OrderSourceId { get; set; }
        public string EmployeeCode { get; set; }
        public string ReferenceOrderID { get; set; }
        public int ModifySourceId { get; set; }
        public int ModifyReasonId { get; set; }
        public List<string> Notes { get; set; }
        public string HasUnlimitedFOC { get; set; }
        public string Note { get; set; }
        public List<ItemPackModel> AllItems { get; set; }
        public string ConfirmationSignature { get; set; }
        public int CreatedBy { get; set; }
        public int PreparedBy { get; set; }
        public CreationSource CreationSource { get; set; }
        public TransactionCreationReason CreationReason { get; set; }
        public string CustomerCodeName { get; set; }
        public int CustomerId { get; set; }
        public string CustomerName { get; set; }
        public string CustomerCode { get; set; }
        public string CustomerPhoneNumber { get; set; }
        public string GPSLongitude { get; set; }
        public string GPSLatitude { get; set; }
        public List<Promotion> CustomerPromotions { get; set; }
        public List<Promotion> PromotionsForAllLevels { get; set; }

        public DateTime TransactionDate
        {
            get { return _transactionDate; }
            set
            {
                _transactionDate = value;
                TransactionDateModel = new DateModel(_transactionDate);
            }
        }
        public DateModel TransactionDateModel { get; set; }

        public CustomerValidationsModel CustomerValidations { get; set; }
        public DateTime DesiredDeliveryDate
        {
            get { return _desiredDeliveryDate; }
            set
            {
                _desiredDeliveryDate = value;
                DesiredDeliveryDateModel = new DateModel(_desiredDeliveryDate);
            }
        }

        public DateModel DesiredDeliveryDateModel { get; set; }

        public DateTime ResumeDate
        {
            get { return _resumeDate; }
            set
            {
                _resumeDate = value;
                ResumeDateModel = new DateModel(_resumeDate);
            }
        }
        public DateModel ResumeDateModel { get; set; }
        private DateTime _resumeDate { get; set; }
        public decimal Discount { get; set; }
        public string DivisionCodeName { get; set; }
        public string Division { get; set; }
        public int DivisionId { get; set; }
        public int DriverId { get; set; }

        public string EmployeeCodeName { get; set; }

        public int EmployeeId { get; set; }

        public string EmployeeName { get; set; }
        public string AssignTo { get; set; }

        public decimal ExchangeRate { get; set; }

        public decimal CalculatedRetailTax { get; set; }

        public decimal GrossTotal { get; set; }

        public decimal HeaderDiscount { get; set; }

        public int HelperId { get; set; }

        public bool IsEditMode { get; set; }

        public bool IsPromotionTaken { get; set; }

        public string LPO { get; set; }

        public decimal NetTotal { get; set; }
        public decimal RoundingDifference { get; set; }
        public DateTime OrderDate
        {
            get { return _orderDate; }
            set
            {
                _orderDate = value;
                OrderDateModel = new DateModel(_orderDate);
            }
        }
        public DateModel OrderDateModel { get; set; }

        public DateTime CreatedDate { get; set; }

        public string OrderId { get; set; }
        public bool OrderHasSerialItems { get; set; }
        public  bool EnableSendNotification { get; set; }

        [Required]
        public OrderOperation OrderOperation { get; set; }

        public string OrderSignature
        {
            get
            {
                return EncryptionManager.Instance.EncryptData(
                    OrderId 
                    + EncryptionManager.Instance.SignatureSeparator +
                    CustomerId
                    + EncryptionManager.Instance.SignatureSeparator +
                    OutletId
                    + EncryptionManager.Instance.SignatureSeparator +
                    EmployeeId
                    + EncryptionManager.Instance.SignatureSeparator +
                    DivisionId);
            }
        }

        [EnumDataType(typeof(OrderStatus))]
        public OrderStatus OrderStatus { get; set; }
        public OrderStatus OrderStatusFromUI { get; set; }
        public int SelectedOrderStatusId { get; set; }
        public OrderStatus PreviousOrderStatus { get; set; }
        public string OrderStatusDescription { get; set; }

        public int OrderStatusId
        {
            get
            {
                return (int)OrderStatus;
            }
            set
            {
                if (value != 0)
                    OrderStatus = (OrderStatus)value;
            }
        }

        public OrderTypes OrderTypeId { get; set; }

        public int OrganizationId { get; set; }

        public CustomerOutletModel Outlet { get; set; }

        public string OutletCodeName { get; set; }

        public int OutletId { get; set; }
        public string OutletName { get; set; }
        public decimal PromotedDiscount { get; set; }
        public List<ItemPackModel> PromotedItems { get; set; }
        public int ReferenceWarehouseId { get; set; }
        public int SalesManagerId { get; set; }
        public int SalesRepId { get; set; }
        public DateTime ScheduleDate
        {
            get { return _scheduleDate; }
            set
            {
                _scheduleDate = value;
                ScheduleDateModel = new DateModel(_scheduleDate);
            }
        }

        public DateModel ScheduleDateModel { get; set; }
        public List<ItemPackModel> SoldItems { get; set; }
        public string SourceOrderId { get; set; }
        public int SupervisorId { get; set; }
        public decimal Tax { get; set; }
        public string TransactionId { get; set; }
        public int UpdatedBy { get; set; }

        public int vehicleId { get; set; }
        public int WarehouseId { get; set; }
        public string WarehouseNameCode { get; set; }

        public string WarehouseTransactionId { get; set; }
        public int ZoneId { get; set; }
        public int RecurringTypeId { get; set; }
        public string RecurringValue { get; set; }
        public int RecurringStatusId { get; set; }
        public int RecurringChangedReasonId { get; set; }
        public string RecurringComment { get; set; }
        public int RouteHistoryId { get; set; }
        public string Remarks { get; set; }
        public bool IsTaxeableOutlet { get; set; }
        public DeliveryAssignmentModel DeliveryAssignment { get; set; }
        public bool ShowLoadRequestBtn { get; set; }
        public bool ShowInvoiceBtn { get; set; }

        public bool ShowDeliveryBtn { get; set; }
        public bool ShowCancelBtn { get; set; }
        public bool ShowPartialDeliveryBtn { get; set; }
        public bool ShowVoidBtn { get; set; }
        public bool ShowReassignBtn { get; set; }
        public bool ShowReturnBtn { get; set; }
        public int DeliveryAssignmentId { get; set; }
        public bool AllowRetailTaxOnItems { get; set; }
        public int? DeliveryChargesId { get; set; }
        public decimal? DeliveryValue { get; set; }
        public decimal? DeliveryTax { get; set; }
        public int? PaymentMethodTypeID { get; set; }
        public string PaymentReferenceNumber { get; set; }
        public bool IsNotReturnOrder { get; set; }
        public bool IsRestrictedFromOldInvoices { get; set; }
        public int SDCId { get; set; }
        public List<AppliedContractedFOCModel> ContractedFOCs { get; set; }
        public int ApprovalStatus { get; set; }
        public bool SkipCheckQuantityBeforeApproval { get; set; }
        public bool IsBundle { get; set; }
        public string BundleStatus { get; set; } 
        public bool IsUploaded { get; set; }
        public void  GetOrderDataFromSignature(string orderSignature)
        {
           
                string decryptedString= EncryptionManager.Instance.DecryptData(orderSignature);
            if(!string.IsNullOrEmpty(decryptedString) && decryptedString.Split(EncryptionManager.Instance.SignatureSeparator).Length == 5)
            {
                OrderId = decryptedString.Split(EncryptionManager.Instance.SignatureSeparator)[0];
                CustomerId = int.Parse(decryptedString.Split(EncryptionManager.Instance.SignatureSeparator)[1]);
                OutletId = int.Parse(decryptedString.Split(EncryptionManager.Instance.SignatureSeparator)[2]);
                EmployeeId = int.Parse(decryptedString.Split(EncryptionManager.Instance.SignatureSeparator)[3]);
                DivisionId = int.Parse(decryptedString.Split(EncryptionManager.Instance.SignatureSeparator)[4]);
            }
           

        }
        public string Description { get; set; }
        #endregion [DECLERATIONS]
        public OrderModel()
        {
            SalesMode = SalesModes.None.GetHashCode();
            Remarks = string.Empty;
            OrderDateModel = new DateModel();
            ScheduleDateModel = new DateModel();
            DesiredDeliveryDateModel = new DateModel();
            CustomerPromotions = new List<Promotion>();
            PromotionsForAllLevels = new List<Promotion>();
            TransactionDateModel = new DateModel();

            AllItems = new List<ItemPackModel>();
            PromotedItems = new List<ItemPackModel>();
            SoldItems = new List<ItemPackModel>();
            Outlet = new CustomerOutletModel();
            CustomerValidations = new CustomerValidationsModel();
            RecurringTypeId = -1;
            RouteHistoryId = -1;
            DeliveryAssignment = new DeliveryAssignmentModel();

            deliveryLocation = string.Empty;
            OrderType = string.Empty;
            CustomerRef = string.Empty;
            RejectReason = string.Empty;
            RejectNote = string.Empty;
            RejectDateModel = new DateModel();
            DriverId = -1;
            HelperId = -1;
            SupervisorId = -1;
            SalesManagerId = -1;
            IsNotReturnOrder = false;
            SourceOrderId = string.Empty;
            OrderSourceId = -1;
            IsRestrictedFromOldInvoices = false;
            IsThereAnyProductDiscountDefined = false;
            SDCId = -1;
            ContractedFOCs = new List<AppliedContractedFOCModel>();
            ApprovalStatus = -1;
            SkipCheckQuantityBeforeApproval = false;
            IsUploaded = false;
            WarehouseId = -1;
            PreparedBy = -1;
            CollectionMethod = CollectionMethods.None.GetHashCode();
            RoundingDifference = 0;
            SelectedOrderStatusId = -1;
            IsNotWarehouseStock = true;
        }
    }

    public class OrderOperationModel
    {
        public string Description { get; set; }
        public OrderOperation OperationType { get; set; }
        public bool IsValidOperation { get; set; }
        public string Message { get; set; }

        public bool OnlyShowWarning { get; set; }
    }

    public class OrderSourceModel
    {
        public int SourceId { get; set; }
        public string Name { get; set; }

        public OrderSourceModel()
        {
        }
    }

   

    public class DeliveryChargesModel
    {
        public int DeliveryChargesId { get; set; }
        public decimal DeliveryValue { get; set; }
        public decimal DeliveryTax { get; set; }
        public string Description { get; set; } 
        public int OrderSourceID { get; set; }
        public bool IsDefault { get; set; }
        public DeliveryChargesModel()
        {
            IsDefault = false;
        }
    }

    public class OrderCRMModel
    {
        public string CustomerIdSignature { get; set; }
        public string OutletIdSignature { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int DivisionId { get; set; }
        public DateTime DesiredDeliveryDate
        {
            get { return _desiredDeliveryDate; }
            set
            {
                _desiredDeliveryDate = value;
                DesiredDeliveryDateModel = new DateModel(_desiredDeliveryDate);
            }
        }
        public DateTime ResumeDate
        {
            get { return _resumeDate; }
            set
            {
                _resumeDate = value;
                ResumeDateModel = new DateModel(_resumeDate);
            }
        }
        public DateTime NextDeliveryDate
        {
            get { return _nextDeliveryDate; }
            set
            {
                _nextDeliveryDate = value;
                NextDeliveryDateModel = new DateModel(_nextDeliveryDate);
            }
        }
        public List<Promotion> CustomerPromotions { get; set; }
        public DateModel DesiredDeliveryDateModel { get; set; }
        public DateModel NextDeliveryDateModel { get; set; }
        private DateTime _desiredDeliveryDate { get; set; }
        public DateModel ResumeDateModel { get; set; }
        private DateTime _resumeDate { get; set; }
        private DateTime _nextDeliveryDate { get; set; }
        public List<ItemPackModel> SoldItems { get; set; }
        public List<ItemPackModel> PromotedItems { get; set; }
        public int OrderSourceId { get; set; }
        public int ModifySourceId { get; set; }
        public int ModifyReasonId { get; set; }
        public string Remarks { get; set; }
        public decimal NetTotal { get; set; }
        public decimal GrossTotal { get; set; }
        public decimal Tax { get; set; }
        public decimal CalculatedRetailTax { get; set; }
        public decimal Discount { get; set; }
        public string OrderId { get; set; }
        public int RecurringTypeId { get; set; }
        public string RecurringValue { get; set; }
        public int RecurringStatusId { get; set; }
        public int RecurringChangedReasonId { get; set; }
        public string RecurringComment { get; set; }
        public string EmployeeName { get; set; }
        public bool IsOddWeekNo { get; set; }

        public int? DeliveryChargesId { get; set; }
        public decimal? DeliveryValue { get; set; }
        public decimal? DeliveryTax { get; set; }

        public string SourceOrderId { get; set; }
        public int? PaymentMethodTypeID { get; set; }
        public string PaymentReferenceNumber { get; set; }
        public int WarehouseId { get; set; }
        public int OrganizationId { get; set; }


        public OrderCRMModel()
        {
            OrderId = string.Empty;
            CustomerId = -1;
            OutletId = -1;
            DivisionId = -1;
            WarehouseId = -1;
            OrganizationId = -1;
        }
    }

    public class OnlineOrder
    {
        /// <summary>
        /// This Model Using for Send echo order to android device ONLY
        /// </summary>
        public OnlineOrder()
        {
            CustomerID = -1;
            OutletID = -1;
            EmployeeID = -1;
            DivisionID = -1;
            LanguageID = 1; // English by default 
            paymentMethodTypeID = 0;
            paymentReferenceNumber = string.Empty;
        }
        public int SalesMode { get; set; }
        public int RouteID { get; set; }
        public int paymentMethodTypeID { get; set; }
        public int CreationSource { get; set; }
        public int OrganizationID { get; set; }
        public int CustomerID { get; set; }
        public int OutletID { get; set; }
        public int EmployeeID { get; set; }
        public int DivisionID { get; set; }
        public DateTime OrderDate { get; set; }
        public string OrderDateString { get; set; }
        public DateTime DesiredDeliveryDate { get; set; }
        public string DesiredDeliveryDateString { get; set; }
        public string paymentReferenceNumber { get; set; }
        public string OrderID { get; set; }
        public string CustomerName { get; set; }
        public string CustomerCode { get; set; }
        public string CustomerPhoneNumber{ get; set; }
        public string GPSLongitude { get; set; }
        public string GPSLatitude { get; set; }

        public int? DeliveryChargesId { get; set; }
        public decimal? DeliveryValue { get; set; }
        public decimal? DeliveryTax { get; set; }
        public SalesOrderContainerDetails SalesOrderContainerLimit { get; set; }
        public List<ItemPack> ItemPacks { get; set; }
        public List<PromotionBenefitHistoryModel> PromotionBenifetHistoryData { get; set; }
        public int OrderTypeID { get; set; }
        public decimal NetTotal { get; set; }
        public decimal GrossTotal { get; set; }
        public decimal Tax { get; set; }
        public decimal Discount { get; set; }
        public decimal PromotedDiscount { get; set; }
        public bool CalculateTaxBeforeDiscounts { get; set; }
        public bool ApplyAmountDiscountPerQuantity { get; set; }
        public List<ItemPack> PromotedItems { get; set; }
        public string TempOrderID { get; set; }
        public int LanguageID { get; set; }
        public int NumberOfItems { get; set; }
        public List<string> Notes { get; set; }
        public int CreatedBy { get; set; }
        public int DispatcherID { get; set; }
        public DateTime CreatedDate { get; set; }
        public string CreatedDateString { get; set; }
        public string OrderSourceId { get; set; }
        public int SDCID { get; set; }
        public string LPO { get; set; }
    }
    public class SalesOrderContainerDetails
    {
        /// <summary>
        /// This Model Using for Send echo order to android device ONLY
        /// </summary>
        public decimal returnQuantity { get; set; }
        public int CustomerID { get; set; }
        public int OutletID { get; set; }
        public string OrderID { get; set; }
        public int DivisionID { get; set; }
        public int containerID { get; set; }
        public decimal depositeQuantity { get; set; }
        public decimal nonDepositeQuantity { get; set; }
    }
    public class DocumentOrder
    {
        public string SalesOrderID { get; set; }
        public string ReturnOrderID { get; set; }

        public DocumentOrder()
        {
            SalesOrderID = string.Empty;
            ReturnOrderID = string.Empty;
        }
    }
    public class OrderDateValidationResponse
    {
        public bool IsThereAnyOrders { get; set; }
        public bool ShowEditOrderOption { get; set; }
        public bool ShowEditRecurringOption { get; set; }
        public OrderDateValidationResponse()
        {
            IsThereAnyOrders = false;
            ShowEditOrderOption = false;
            ShowEditRecurringOption = false;
        }
    }
}