﻿using InCube.Security;
using Sonic.Web.Models;
using System;

namespace Sonic.Web.Model
{
    public class PaymentModel
    {
        #region[private members]

        private DateTime _paymentDate;
        private DateTime _voucherDate;
        private string _signature;

        #endregion


        #region[Properties]
        public string ReceiptId { get; set; } // E-payment
        public bool HasError { get; set; }
        public bool AllowCancelEPayment { get; set; }
        public bool AllowCopyEPaymentLink { get; set; }
        public int EmployeeId { get; set; }
        public int CustomerId { get; set; }
        public string TransactionId { get; set; }
        public int OutletId { get; set; }
        public int CreatedBy { get; set; }
        public int OrganizationId { get; set; }
        public int DivisionId { get; set; }
        public int LanguageID { get; set; }

        public string SourceTransactionId { get; set; }
        public string PayerCodeName { get; set; }
        public string CreditNoteId { get; set; }
        public int BankId { get; set; }
        public int BranchId { get; set; }
        public string VoucherNumber { get; set; }
        public string CustomerPaymentId { get; set; }
        public string AppliedPaymentId { get; set; }
        public PaymentStatusTypes PaymentStatusId { get; set; }
        public PaymentTypes PaymentTypeId { get; set; }
        public int AccountId { get; set; }
        public bool ShowVoidBtn { get; set; }
        public DateTime PaymentDate
        {
            get { return _paymentDate; }
            set
            {
                _paymentDate = value;
                if (_paymentDate != null)
                {
                    PaymentDateModel = new DateModel(_paymentDate);
                }
            }
        }
        public DateModel PaymentDateModel { get; set; }
        public DateTime VoucherDate
        {
            get { return _voucherDate; }
            set
            {
                _voucherDate = value;
                if (_voucherDate != null)
                {
                    VoucherDateModel = new DateModel(_voucherDate);
                }
            }
        }
        public string Signature
        {
            get
            {
                return EncryptionManager.Instance.EncryptData(
                   TransactionId + EncryptionManager.Instance.SignatureSeparator
                   + CustomerId + EncryptionManager.Instance.SignatureSeparator
                   + OutletId + EncryptionManager.Instance.SignatureSeparator
                   + EmployeeId + EncryptionManager.Instance.SignatureSeparator
                   + DivisionId + EncryptionManager.Instance.SignatureSeparator
                   + CustomerPaymentId);
            }
            set
            {
                _signature = value;
                if (!string.IsNullOrEmpty(_signature))
                {
                    string[] IDs = EncryptionManager.Instance.DecryptData(_signature).Split(EncryptionManager.Instance.SignatureSeparator.ToCharArray());
                    TransactionId = IDs[0];
                    CustomerId = int.Parse(IDs[1]);
                    OutletId = int.Parse(IDs[2]);
                    EmployeeId = int.Parse(IDs[3]);
                    DivisionId = int.Parse(IDs[4]);
                    CustomerPaymentId = IDs[5];
                }
            }
        }
        public DateModel VoucherDateModel { get; set; }
        public string VoucherOwner { get; set; }
        public decimal RemainingAmount { get; set; }
        public decimal AppliedAmount { get; set; }
        public decimal CollectionDiscount { get; set; }
        public int CurrencyId { get; set; }
        public int SelectedCurrencyId { get; set; }
        public int SecondCurrencyId { get; set; }
        public decimal SecondCurrencyAmount { get; set; }
        public decimal ExchangeRate { get; set; }
        public string Notes { get; set; }
        public bool IsPrinted { get; set; }
        public bool IsTransRemainingAffected { get; set; }
        public bool AutoGeneratedByExchange { get; set; }
        public int RouteHistoryId { get; set; }


        public string DivisionName { get; set; }
        public string CustomerNameCode { get; set; }
        public string OutletNameCode { get; set; }
        public string EmployeeNameCode { get; set; }
        public string CustomerCodeName { get; set; }
        public string OutletCodeName { get; set; }
        public string EmployeeCodeName { get; set; }
        public string PaymentTypeName { get; set; }
        public string PaymentStatusName { get; set; }
        public string BankName { get; set; }
        public string BranchName { get; set; }
        public int HelperId { get; set; }
        public int DriverId { get; set; }
        public int SupervisorId { get; set; }
        public int SalesRepId { get; set; }
        public int SalesManagerId { get; set; }
        public bool Voided { get; set; }
        public bool Posted { get; set; }
        public bool IsCheque { get; set; }
        public string UUID { set; get; }
        public string ThirdPartyTransactionId { get; set; }
        public string PaymentLink { get; set; }
        #endregion

        #region [METHODS]

        public PaymentModel()
        {
            PaymentDateModel = new DateModel();
            VoucherDateModel = new DateModel();
            VoucherNumber = string.Empty;
            BankId = -1;
            BranchId = -1;
            RouteHistoryId = -1;
            CustomerId = -1;
            OutletId = -1;
            OrganizationId = -1;
            AccountId = -1;
            DivisionId = -1;
            EmployeeId = -1;
            CreatedBy = -1;
            Posted = false;
            ShowVoidBtn = false;
        }

        public class PaymentTypeFilterModel
        {
            public PaymentTypeFilterModel()
            {
                this.isDownPayment = false;
                this.customerID = -1;
                this.outletID = -1;
            }

            public bool isDownPayment { get; set; }
            public int customerID { get; set; }
            public int outletID { get; set; }
        }

        #endregion
    }
}
