﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class PaymentTransaction
    {
        #region (Property)

        public bool IsTransRemainingAffected { set; get; }
        public string TransactionId { set; get; }
        public int CreationReason { set; get; }
        public decimal CoveredAmount { set; get; }
        public string AppliedPaymentId { set; get; }
        public int TransactionRouteHistoryId { set; get; }
        public int TransactionEmployeeId { set; get; }
        public decimal AppliedAmount { set; get; }
        public bool Posted { set; get; }
        public int PaymentTypeId { set; get; }
        public SalesModes SalesMode { set; get; }
        public int CurrencyId { set; get; }
        public string SourceTransactionId { set; get; }
        public DateTime TransactionDate { set; get; }
        public DateTime DueDate { set; get; }
        public DateTime PaymentDate { set; get; }
        public bool IsCheque { set; get; }
        public string CustomerPaymentId { get; set; }
        public int OrganizationId { get; set; }
        public int DivisionId { get; set; }
        public string ChequeNo { get; set; }
        public string InvoiceNo { get; set; }
        public decimal RemainingAmount { get; set; }
        public decimal PaidAmount { get; set; }
        public string BankName { get; set; }
        public string BranchName { get; set; }
        public string PaymentType { get; set; }
        public string CustomerNameCode { get; set; }
        public string OutletNameCode { get; set; }
        public string EmployeeName { get; set; }
        public string ChequeDate { get; set; }
        public DateModel VoucherDateModel { get; set; }
        public string TransactionIdInUI { get; set; }

        #endregion

        #region (Constructor)

        public PaymentTransaction()
        {
            CreationReason = 0;
            CoveredAmount = 0;
            TransactionEmployeeId = -1;
            TransactionRouteHistoryId = -1;
            TransactionId = string.Empty;
            AppliedPaymentId = string.Empty;
            IsTransRemainingAffected = false;
            AppliedAmount = 0;
            Posted = false;
            PaymentTypeId = -1;
            SalesMode = SalesModes.None;
            CurrencyId = -1;
            TransactionId = string.Empty;
            SourceTransactionId = string.Empty;
            TransactionDate = DateTime.Now;
            PaymentDate = DateTime.Now;
            IsCheque = false;
            ChequeNo = string.Empty;
        }
        #endregion 
    }
}
