﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Sonic.Web.Model
{
    public class SavePaymentModel
    {
        #region [Properties]

        public List<TransactionModel>TransactionsList { get; set; }
        public List<PaymentModel> PaymentsList { get; set; }
        public bool IsRemainingAmountUpdatedInDB { get; set; }

        
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int DivisionId { get; set; }
        public int EmployeeId { get; set; }
        public ValidationErrors ValidationErrors { get; set; }
        public CustomerContact CustomerContact { get; set; }
        public bool NotifyBySMS { get; set; }
        public bool NotifyByEmail { get; set; }
        #endregion

        public SavePaymentModel()
        {
            CustomerId = -1;
            OutletId = -1;
            DivisionId = -1;
            EmployeeId = -1;
            IsRemainingAmountUpdatedInDB = false;
            TransactionsList = new List<TransactionModel>();
            PaymentsList = new List<PaymentModel>();
            CustomerContact = new CustomerContact();
        }

    }
}
