﻿using System;
namespace Sonic.Web.Model
{
    public class PaymentTermModel
    {
        public DateTime TrasnactionCreationDate { get; set; }

        public int GracePeriodTypeId { get; set; }

        public int GracePeriod { get; set; }

        public int ComplexPeriodId { get; set; }

        public int ComplexPeriodWidth { get; set; }

        public int SimplePeriodId { get; set; }

        public int SimplePeriodWidth { get; set; }

        public int PaymentTermTypeId { get; set; }

        public int PaymentTermId { get; set; }

        public string PaymentTermDescription { get; set; }


        public int GetDays()
        {
            return GetDays(false);
        }
        public int GetDays(bool AddPDCDays)
        {
            int days = 0;
            int graceDays = 0;
            try
            {
                if (PaymentTermTypeId == 1)//simple
                {
                    GetDays(SimplePeriodId, SimplePeriodWidth, ref days);
                    return days;
                }
                else //complex
                {
                    GetDays(GracePeriodTypeId, GracePeriod, ref graceDays);

                    DateTime currentEndStatmentDate = DateTime.Now;
                    ReturnValidDate(DateTime.Now.Year, DateTime.Now.Month, ComplexPeriodWidth, ref currentEndStatmentDate);
                    if(TrasnactionCreationDate >= currentEndStatmentDate)
                    {
                        currentEndStatmentDate = currentEndStatmentDate.AddMonths(1);
                        ReturnValidDate(currentEndStatmentDate.Year, currentEndStatmentDate.Month, ComplexPeriodWidth, ref currentEndStatmentDate);
                        currentEndStatmentDate = currentEndStatmentDate.AddDays(days);
                        currentEndStatmentDate = currentEndStatmentDate.AddDays(graceDays);
                        return currentEndStatmentDate.Subtract(TrasnactionCreationDate).Days;
                    }
                    else
                    {
                        ReturnValidDate(TrasnactionCreationDate.Year, TrasnactionCreationDate.Month, ComplexPeriodWidth, ref currentEndStatmentDate);
                        if (TrasnactionCreationDate > currentEndStatmentDate)
                        {
                            currentEndStatmentDate = TrasnactionCreationDate.AddMonths(1);
                            ReturnValidDate(currentEndStatmentDate.Year, currentEndStatmentDate.Month, ComplexPeriodWidth, ref currentEndStatmentDate);
                        }
                        currentEndStatmentDate = currentEndStatmentDate.AddDays(days);
                        currentEndStatmentDate = currentEndStatmentDate.AddDays(graceDays);
                        return currentEndStatmentDate.Subtract(TrasnactionCreationDate).Days;
                    }
                }
            }
            catch (Exception)
            {
            }
            return days;
        }

        private void GetDays(int periodId, int periodWidth, ref int days)
        {
            try
            {
                switch (periodId)
                {
                    case 1:
                        days += (periodWidth * 1);
                        break;
                    case 2:
                        days += (periodWidth * 7);
                        break;
                    case 3:
                        days += (periodWidth * 30);
                        break;
                    case 4:
                        days += (periodWidth * 365);
                        break;
                }
            }
            catch (Exception)
            {
            }
        }

        private void ReturnValidDate(int year, int month, int day, ref DateTime date)
        {
            try
            {
                DateTime _validDate;
                _validDate = new DateTime(year, month, day);
                date = _validDate;
            }
            catch (Exception)
            {
                ReturnValidDate(year, month, day - 1, ref date);
            }
        }

    }

    public class PaymentTermTypeModel
    {
        public int PaymentTermTypeId { get; set; }
        public string PaymentTermTypeDescription { get; set; }
    }
    public class OutletDivisionPaymentTermModel
    {
        public OutletDivisionPaymentTermModel()
        {
            PaymentTermId = -1;
            DivisionId = -1;
        }
        public int PaymentTermId { get; set; }
        public int DivisionId { get; set; }
        public string DivisionCodeName { get; set; }
        public string PaymentTermDescription { get; set; }
    }
}
