﻿using Newtonsoft.Json;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace Sonic.Web.Model
{
    public class Promotion
    {
        public Promotion()
        {
            PromotionInputs = new List<PromotionOption>();
            PromotionOutputs = new List<PromotionOption>();
            OrganizationsList = new List<OrganizationModel>();
            DescriptionLanguages = new List<TextLanguage>();
            ChannelsList = new List<CustomerChannelModel>();
            GroupsList = new List<CustomerGroupModel>();
            CustomersList = new List<SimpleCustomerModel>();
            ExcludedCustomersList = new List<SimpleCustomerModel>();
            SatisfiedPrerequisitesDetails = new List<SatisfiedPrerequisitesDetails>();
            UnsatisfiedOutputs = new List<int>();
            RelatedToTargetsOptions = new List<RelatedToTargetPromotion>();
            ProductDiscountBenefitList = new List<ProductDiscountBenefitModel>();
            BundleItems = new List<ItemPackModel>();
            FreeGoodsType = FreeGoodsTypes.None;
            OldPromotionId = -1;
            AchievementId = -1;
            AchievementTypeId = -1;
            GiftVoucherMode = -1;
            IsNew = false;
            RelatedToTarget = false;
            OldRelatedToTarget = false;
            ResetLastInvRem = true;
            SendNotification = false;
            SendNotificationToFO = false;
            TargetMode = -1;
            PromotionModeId = -1;
            PromotionId = -1;
            TargetInputSelectionId = -1;
            TargetOutputSelectionId = -1;
            StepInputSelectionDescription = string.Empty;
            StepOutputSelectionDescription = string.Empty;
            BenefitSequenceDtls = new List<BenefitSequenceDetails>();
            PromotionName = string.Empty;
            ImageList = new List<string>();
            PromotionReasonId = -1;
            AttachedFiles = new List<string>();
            DeletedFiles = new List<string>();
            BenefitValue = 0;
            SurveyId = -1;
            Sequence = 1;
            HiddenOrganizations = new List<OrganizationModel>();
            IsPercentageChecked = true;
            MaxLimit = 0;
            Resend = false;
            IsClone = false;
            IsRestrictUpperLimit = false;
            LoyaltyModeDescription = string.Empty;
            FailedSentToAndroid = false;
            FailedSentToEcho = false;
            Priority = -1;
            PromotionGroupId = -1;
            SalesMode = string.Empty;
            NoOfInvoices = 0;
            ShowDeleteBtn = false;
            NetTotal = 0;
            BundleNetTotal = 0;
            PromotionOptionDetailTypeID = -1;
            BundleAvailableQty = 0;
            HasFixedPrice = false;
            UsedQuantity = 0;
        }
        public bool ShowTakePromotionOption { get; set; }
        public bool ShowReadMoreOption { get; set; }
        public List<string> ImageList { get; set; }
        public List<string> AttachedFiles { get; set; }
        public List<BenefitSequenceDetails> BenefitSequenceDtls { get; set; }
        public List<string> DeletedFiles { get; set; }
        public string StepInputSelectionDescription { get; set; }
        public string StepOutputSelectionDescription { get; set; }
        public int PromotionModeId { get; set; }
        public PromotionLevel PromotionLevel { get; set; }
        public List<ProductDiscountBenefitModel> ProductDiscountBenefitList { get; set; }
        public PromotionLevel OldPromotionLevel { get; set; }
        public int AchievementId { set; get; }

        private List<AchievementTargetCustomer> _CustomerTargets;
        public int AchievementTypeId { set; get; }
        public int TargetInputTypeId { set; get; }
        public int TargetInputSelectionId { set; get; }
        public int TargetOutputSelectionId { set; get; }
        public FreeGoodsTypes FreeGoodsType { get; set; }
        public List<SimpleCustomerModel> CustomersList { get; set; }
        public List<CustomerGroupModel> GroupsList { get; set; }
        public List<CustomerChannelModel> ChannelsList { get; set; }
        public List<SalesDistributionChannelModel> SDCSList { get; set; }

        public List<RelatedToTargetPromotion> RelatedToTargetsOptions { set; get; }
        public List<SimpleCustomerModel> ExcludedCustomersList { get; set; }
        private DateTime _startDate = DateTime.Now;
        private DateTime _endDate = DateTime.Now;
        public bool AllowAddPromotionToBasket { get; set; }
        public bool IsStartedTargetPromotion { get; set; }
        public bool IsAmount { get; set; }
        public bool IsPercentageChecked { get; set; }
        public bool IsPromoted { get; set; }
        public bool IsQuantity { get; set; }
        public bool Resend { get; set; }
        public bool FailedSentToEcho { get; set; }
        public bool FailedSentToAndroid { get; set; }
        public List<ItemPackModel> BundleItems { get; set; }
        public int PromotionOptionDetailTypeID { get; set; }
        [JsonIgnore]
        public DateTime StartDate
        {
            get { return _startDate; }
            set
            {
                _startDate = value;
                if (_startDate != null)
                    StartDateModel = new DateModel(_startDate);
            }
        }
        [JsonIgnore]
        public DateTime EndDate
        {
            get { return _endDate; }
            set
            {
                _endDate = value;
                if (_endDate != null)
                    EndDateModel = new DateModel(_endDate);
            }
        }
        public List<AchievementTargetCustomer> CustomerTargets
        {
            get { return _CustomerTargets; }
            set { _CustomerTargets = value; }
        }
        public DateModel StartDateModel { get; set; }
        public DateModel EndDateModel { get; set; }
        public int AchievementPeriodId { get; set; }
        public decimal AmountOfPromotionSteps { get; set; }
        public ArrayList ArChannels { get; set; }
        public bool AssignToAllCustomers { get; set; }
        public bool IsRetail { get; set; }
        public int BenGroupId { get; set; }
        public List<int> UnsatisfiedOutputs { get; set; }
        public int BenItemId { get; set; }
        public long CreatedBy { get; set; }
        public DateTime CreatedDate { get; set; }
        public DateTime DeletedDate { get; set; }
        public int DetailsCount { get; set; }
        public int GiftVoucherMode { get; set; }
        public bool Inactive { get; set; }
        public bool ApplyBundleView { get; set; }
        public string PromotionStatusName { set; get; }
        public int Status { set; get; }
        public bool IsPending { set; get; }
        public bool IsAppliedOnLastInvoice { set; get; } // we used transactionCommonData.lastInvoicePromotionsList instead of this property to check if the promotion is applied as last invoice .
        public bool IsBundle { get; set; }
        public bool IsDeleted { get; set; }
        public bool IsGiftVoucher { get; set; }
        public bool IsLoyaltyPromotion { get; set; }
        public bool IsRedeemPoints { get; set; }
        public bool IsRepeated { get; set; }
        public bool IsTaken { get; set; }
        public bool IsPromotionSelectionForEcho { get; set; }
        public bool IsSatisfied { get; set; }
        public bool IsWholeSaleContract { get; set; }
        public bool IsDynamicSalesAmount { get; set; }
        public int LoyalityWidth { get; set; }
        public int NewRepeatCount { get; set; }
        public int OldPromotionId { get; set; }
        public int OrganizationId { get; set; }
        public List<OrganizationModel> OrganizationsList { get; set; }
        public string organizationCodeName { get; set; }
        public int OriginalRepeatCount { get; set; }
        public int PreGroupId { get; set; }
        public int PreItemId { get; set; }
        public string PromotionCode { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public int PromotionGroupId { get; set; }
        public int PromotionId { get; set; }
        public decimal BenefitValue { get; set; }
        public bool IsNew { get; set; }
        public bool RelatedToTarget { get; set; }
        public bool OldRelatedToTarget { get; set; }
        public bool AppliedAfterPeriod { get; set; }
        public bool AllowOring { get; set; }
        public bool OldAllowOring { get; set; }
        public bool ResetLastInvRem { get; set; }
        public bool SendNotification { get; set; }
        public bool SendNotificationToFO { get; set; }
        public int TargetMode { get; set; }
        public string PromotionName { get; set; }
        public List<PromotionOption> PromotionOutputs { get; set; }
        public List<PromotionOption> PromotionInputs { get; set; }

        public List<SatisfiedPrerequisitesDetails> SatisfiedPrerequisitesDetails { get; set; }
        public PromotionTypes PromotionType { get; set; }
        public PromotionTypes OldPromotionType { get; set; }
        public string PromotionTypeName { get; set; }
        public int SatesfiedDetail { get; set; }
        public int SatisfiedInput { get; set; }
        public decimal TargetBenefitQuantity { get; set; }
        public decimal TotalQuantityfromPackGroup { get; set; }
        public long UpdatedBy { get; set; }
        public DateTime UpdatedDate { get; set; }
        public decimal MinValue { get; set; }
        public int PromotionReasonId { set; get; }
        public bool ShowInCustomerApp { set; get; }
        public string OfferAppliedOptions { get; set; }
        public int BundleLimit { get; set; }
        public decimal AchievementPercantage { get; set; }
        public decimal AchievementReminder { get; set; }
        public int SurveyId { get; set; }
        public int Sequence { get; set; }
        public decimal TotalCalculatedItemPromotedDiscount { get; set; }
        public decimal TotalCalculatedAllItemPromotedDiscount { get; set; }
        public bool EchoShowAchinment { get; set; }
        public List<OrganizationModel> HiddenOrganizations { get; set; }
        public bool IsNeedToCalculateLoyalty { get; set; }
        public int MaxLimit { get; set; }
        public bool IsProductDiscount { get; set; }
        public bool oldIsProductDiscount { get; set; }
        public bool IsClone { get; set; }
        public bool IsRestrictUpperLimit { get; set; }
        public string LoyaltyModeDescription { get; set; }

        public int Priority { get; set; }
        public string SalesMode { get; set; }
        public int NoOfInvoices { get; set; }
        public bool ShowDeleteBtn { get; set; }
        public decimal NetTotal { get; set; }
        public decimal BundleNetTotal { get; set; }
        public decimal BundleAvailableQty { get; set; }
        public decimal UsedQuantity { get; set; }
        public bool HasFixedPrice { get; set; }
    }
    public class PromotionGroupLevelsModel
    {
        public int LevelId { get; set; }
        public List<Promotion> promotions { get; set; }

        public PromotionGroupLevelsModel()
        {
            promotions = new List<Promotion>();
            LevelId = -1;
        }
    }
    public class PromotionFilterModel
    {
        public CustomListFilters CustomListFilter { get; set; }
        public int OrganizationId { get; set; }
        public int PromotionTypeId { get; set; }
        public int CustomerId { set; get; }
        public int OutletId { set; get; }
        public int CustomerGroupId { set; get; }
        public bool IncludeInactive { set; get; }
        public bool IsGiftVoucher { set; get; }
        public bool IsBundle { set; get; }
        public bool IsLoyaltyPromotion { set; get; }
        public DateModel FromDate { get; set; }
        public DateModel ToDate { get; set; }
        public bool IsCustomerApp { get; set; }
        public bool SpecificDate { get; set; }
        public string ChannelSubChannelIds { get; set; }
        public int CustomerClassId { get; set; }
        public int BenefitItemId { get; set; }
        public int BenefitGroupId { get; set; }
        public int PrerequisiteItemId { get; set; }
        public int PrerequisiteGroupId { get; set; }
        public PromotionFilterModel()
        {
            OrganizationId = -1;
            PromotionTypeId = -1;
            CustomerId = -1;
            OutletId = -1;
            IncludeInactive = false;
            IsGiftVoucher = false;
            IsBundle = false;
            IsLoyaltyPromotion = false;
            FromDate = new DateModel();
            ToDate = new DateModel();
            CustomListFilter = new CustomListFilters();
            IsCustomerApp = false;
            SpecificDate = false;
            ChannelSubChannelIds = string.Empty;
            CustomerClassId = -1;
            BenefitItemId = -1;
            BenefitGroupId = -1;
            PrerequisiteItemId = -1;
            PrerequisiteGroupId = -1;
        }
    }
    public class PromotionBenefitHistoryModel
    {
        /// <summary>
        /// This Model Using for Send echo order to android device ONLY
        /// </summary>
        public PromotionBenefitHistoryModel()
        {
            TransactionID = string.Empty;
            PromotionID = -1;
            PromotionOptionID = -1;
            PromotionOptionDetailID = -1;
            PromotionOptionDetailTypeID = -1;
            PackID = -1;
            CustomerID = -1;
            OutletID = -1;
            EmployeeID = -1;
            RouteID = -1;
            RouteHistoryID = -1;
            PackGroupID = -1;
            CreatedDate = string.Empty;
            InvoiceDiscountValue = 0;
            PackDiscountValue = 0;
            PackQuantity = 0;
            TransactionTypeID = -1;
            DivisionID = -1;
            ExpiryDate = string.Empty;
            BatchNo = string.Empty;
            RepeatCount = -1;
        }

        public string TransactionID { get; set; }
        public int PromotionID { get; set; }
        public int PromotionOptionID { get; set; }
        public int PromotionOptionDetailID { get; set; }
        public int PromotionOptionDetailTypeID { get; set; }
        public int PackID { get; set; }
        public int CustomerID { get; set; }
        public int OutletID { get; set; }
        public int EmployeeID { get; set; }
        public int RouteID { get; set; }
        public int RouteHistoryID { get; set; }
        public int PackGroupID { get; set; }
        public string CreatedDate { get; set; }
        public decimal InvoiceDiscountValue { get; set; }
        public decimal PackDiscountValue { get; set; }
        public decimal PackQuantity { get; set; }
        public int TransactionTypeID { get; set; }
        public int DivisionID { get; set; }
        public string ExpiryDate { get; set; }
        public string BatchNo { get; set; }
        public int RepeatCount { get; set; }
    }
    public class PromotionsHistoryModel
    {
        public PromotionsHistoryModel()
        {
            TransactionID = string.Empty;
            PromotionID = -1;
            AchievementId = -1;
            TargetId = -1;
            CustomerID = -1;
            OutletID = -1;
            BenefitValue = 0;
            OldValue = 0;
        }

        public string TransactionID { get; set; }
        public int PromotionID { get; set; }
        public int AchievementId { get; set; }
        public int TargetId { get; set; }
        public int CustomerID { get; set; }
        public int OutletID { get; set; }
        public string LastInvoiceDate { get; set; }
        public decimal BenefitValue { get; set; }
        public decimal OldValue { get; set; }
    }
    public class AccumulativePromotionsHistoryModel
    {
        public AccumulativePromotionsHistoryModel()
        {
            TransactionID = string.Empty;
            PromotionID = -1;
            CustomerID = -1;
            OutletID = -1;
            BenefitValue = 0; 
            OldValue = 0;
        }

        public string TransactionID { get; set; }
        public int PromotionID { get; set; }
        public int CustomerID { get; set; }
        public int OutletID { get; set; }
        public string LastInvoiceDate { get; set; }
        public decimal BenefitValue { get; set; }
        public decimal OldValue { get; set; }
        public decimal BenefitPercentage { get; set; }
        public int PromotionOptionId { get; set; }
        public int InputDetailId { get; set; }
        public int OutputDetailId { get; set; }
        public int InputTypeID { get; set; }
        public int OutputTypeID { get; set; }
    }
    public class PromotionReasonModel
    {
        public int PromotionReasonId { set; get; }
        public string Description { set; get; }
        PromotionReasonModel()
        {
            PromotionReasonId = -1;
        }
    }
    public class PackGroupQuantityModel
    {
        public PackGroupQuantityModel()
        {
            ItemId = -1;
            QtyInPcs = 0;
        }
        public int ItemId { set; get; }
        public decimal QtyInPcs { set; get; }
    }
    public class RelatedToTargetPromotion
    {
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int PromotionId { set; get; }
        public int PromotionOptionDetailId { set; get; }
        public int PromotionOptionDetailTypeId { set; get; } //input
        public int ReferenceOptionId { set; get; }
        public int PackId { set; get; }
        public int PackGroupId { set; get; }
        public int BenefitPackId { set; get; }
        public int BenefitPackGroupId { set; get; }
        public decimal OptionTargetValue { set; get; }
        public decimal AchievedValue { set; get; }
        public decimal BenefitAchievedValue { set; get; }// the achieved value from benefit packgroup
        public decimal AchievedValueAmount { set; get; }
        public decimal TotalAchievedValue { set; get; }
        public DateTime LastInvoiceDate { get; set; }
        public bool IsSatisfied { get; set; }
        public decimal Benefit { get; set; } // discount / qty according to the type of benefit
        public int BenefitOptionDetailTypeID { get; set; } //output
        public string NewBenefitDescription { get; set; }
        public int Result { get; set; }
        public string Msg { get; set; }
        public decimal RemainingValue { get; set; }
       // public decimal CurrentAchievedValue { get; set; }
        public decimal RepeatCount { get; set; }
    }
    public class RelatedToTargetPromotionDetail
    {
        public int PromotionId { set; get; }
        public int PackId { set; get; }
        public int ItemId { set; get; }
        public string ItemCodeName { set; get; }
        public string ItemCode { set; get; }
        public string ItemName { set; get; }
        public string UOM { set; get; }
        public decimal PiecesInPack { get; set; }
        public int PackGroupId { set; get; }
        public DateTime PrevLastInvoiceDate { get; set; } // Calculate promotion benefit from this date.
        public DateTime NextLastInvoiceDate { get; set; } // Calculate promotion benefit to this date.
        public string TransactionId { get; set; }
        public decimal Benefit { get; set; }
        public int BenefitOptionDetailTypeId { get; set; } //output
        public int PromotionOptionId { set; get; }
        public int PromotionOptionDetailId { set; get; }
        public string PromotionDescription { get; set; }
        public decimal OldBenefit { get; set; }
        public string PackGroupDescription { set; get; }
        public decimal PackGroupPiecesInPack{ set; get; }
        public bool IsProductDiscount { set; get; }
        public decimal AchievedBenefitValue { set; get; }
        public int TargetMode { set; get; }
        public decimal PrereqUOMQuantity { set; get; }
        public string PackGroupUOM { set; get; }

        public RelatedToTargetPromotionDetail()
        {
            PromotionId = -1;
            PackId = -1;
            ItemId = -1;
            ItemCodeName = string.Empty;
            UOM = string.Empty;
            PackGroupId = -1;
            TransactionId = string.Empty;
            Benefit = 0;
            OldBenefit = 0;
            BenefitOptionDetailTypeId = -1;
            PromotionOptionId = -1;
            PromotionOptionDetailId = -1;
            PromotionDescription = string.Empty;
            PackGroupDescription = string.Empty;
            PackGroupPiecesInPack = 0;
            PiecesInPack = 0;
            IsProductDiscount = false;
            ItemCode = string.Empty;
            ItemName = string.Empty;
            AchievedBenefitValue = 0;
            TargetMode = -1;
            PrereqUOMQuantity = 0;
            PackGroupUOM = string.Empty;
        }
    }

    public class PromotionGroupPriorityModel
    {
        public int PromotionGroupId { set; get; }
        public int Priority { set; get; }
        public List<SimpleItemPackModel> UsedItemPacks { set; get; }
        public PromotionGroupPriorityModel()
        {
            PromotionGroupId = -1;
            Priority = -1;
            UsedItemPacks = new List<SimpleItemPackModel>();
        }
    }

}