﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class PromotionGroupModel
    {
        public int PromotionGroupId { get; set; }
        public string PromotionGroupCode { get; set; }
        public string PromotionGroupName { get; set; }
        public string PromotionName { get; set; }
        public string PromotionCode { get; set; }
        public int ValueType { get; set; }
        public List<PromotionGroupModel> PromotionIdsList { get; set; }
        public List<TextLanguage> languageDescriptions { get; set; }
        public bool IsChecked { get; set; }
        private DateTime? _startDate;
        private DateTime? _endDate;
        public bool DisableValuesUsed { get; set; }
        public DateModel StartDateModel { get; set; }
        public DateModel EndDateModel { get; set; }
  
        public DateTime? StartDate
        {
            get { return _startDate; }
            set
            {
                _startDate = value;
                if (_startDate != null)
                    StartDateModel = new DateModel(_startDate.Value);
            }
        }
        public DateTime? EndDate
        {
            get { return _endDate; }
            set
            {
                _endDate = value;
                if (_endDate != null)
                    EndDateModel = new DateModel(_endDate.Value);
            }
        }
        public int Priority { get; set; }
        public int PromotionId { get; set; } 
        public List<SimpleCustomerModel> AppliedCustomers { get; set; }
        public List<CustomerGroupModel> AppliedGroups { get; set; }        
        public PromotionGroupModel()
        {
            PromotionGroupId = -1;
            Priority = 0;
            PromotionGroupCode = string.Empty;
            PromotionGroupName = string.Empty;
            ValueType = 1;
            IsChecked = false;
            DisableValuesUsed = true;
        }
    }
  
}
  
