﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Numerics;
using System.Text;

namespace Sonic.Web.Model
{
    public class SerialCurrentStatusModel
    {
        private string _scannedSerial;
        private string _fromSerial;
        private string _toSerial;
        private string _parentSerial;
        private string _fullSerial;
        private DateTime _expiryDate;
        private string _note;
        private int _divisionId;
        private int _selectedDivisionId;

        public SerialCurrentStatusModel()
        {
            RecallId = -1;
            TransactionRecallId = -1;
            TransactionReadingId = -1;
            DivisionId = -1;
            SelectedDivisionId = -1;
            IsValid = false;
            InStock = true;
            InSCS = true;
            UseGS1Standard = false;
            OrderId = string.Empty;
            IsPartiallyPrepared = false;
            _scannedSerial = string.Empty;
            PackStatusId = -1;
            IsSerialInTheSystem = true;
        }
        public string Location { get; set; }
        public string ExistingItem { get; set; }
        public bool InStock { get; set; }
        public bool InSCS { get; set; }
        public bool IsSerialInTheSystem { get; set; }
        public int DivisionId
        {
            get { return _divisionId; }
            set { _divisionId = value; }
        }
        public int SelectedDivisionId
        {
            get { return _selectedDivisionId; }
            set { _selectedDivisionId = value; }
        }
        public string FromSerial
        {
            get { return _fromSerial.Trim().Trim('\r').Trim('\n'); }
            set { _fromSerial = value; }
        }
        public string ScannedSerial
        {
            get { return _scannedSerial.Trim().Trim('\r').Trim('\n'); }
            set { _scannedSerial = value; }
        }
        public long FromSerialNumPart { get; set; }
        public long ToSerialNumPart { get; set; }
        public string StartCharPart { get; set; }
        public string EndCharPart { get; set; }
        public string StartCharPartFromGS1 { get; set; }
        public string EndCharPartFromGS1 { get; set; }
        public int SerialsCount { get; set; }
        public int TemplateId { get; set; }
        public int PackStatusId { get; set; }
        public bool EnableBatchForSerial { get; set; }
        public bool isOrderPreparation { get; set; }
        public string ParentSerial
        {
            get { return _parentSerial != null ? _parentSerial.Trim().Trim('\r').Trim('\n') : _parentSerial; }
            set { _parentSerial = value; }
        }
        public string FullSerial
        {
            get { return _fullSerial != null ? _fullSerial.Trim().Trim('\r').Trim('\n') : _fullSerial; }
            set { _fullSerial = value; }
        }
        public List<string> ParentsList { get; set; }
        public string RejectReason { get; set; }
        public string Note { get; set; }
        public string TransactionId
        {
            get; set;
        }
        public string OldTransactionId
        {
            get; set;
        }
        public string ToSerial
        {
            get { return _toSerial != null ? _toSerial.Trim().Trim('\r').Trim('\n') : _toSerial; }
            set { _toSerial = value; }
        }
        public int RangeId
        {
            get; set;
        }
        public int VehicleId
        {
            get; set;
        }
        public bool IsInVehicle
        {
            get; set;
        }
        public bool IsArchived
        {
            get; set;
        }
        public bool IsRangeSerial { get; set; }
        public bool IsUpdatedInFO { get; set; }
        public bool IsCouponUsed { get; set; }
        public DateTime UpdateDate { get; set; }

        public int WarehouseId { get; set; }
        //   public int DivisionId { get; set; }
        public int CustomerId { get; set; }
        public int CouponUsageTypeId { get; set; }
        public int OutletId { get; set; }
        public int SerialStatusID { get; set; }
        public string SerialStatusName { get; set; }
        public SerialStatus SerialNumberStatus { get; set; }
        public SSCCStatuses SSCCNumberStatus { get; set; }
        public int SSCCStatusId { get; set; }
        public bool IsSSCCBarcode { get; set; }
        public bool IsParentSSCCBarcode { get; set; }
        public bool IsAddBySerial { get; set; }
        public bool ShowIsActivated { get; set; }
        public decimal Price { get; set; }
        public decimal ChildPackPrice { get; set; }
        public DateTime ExpiryDate
        {
            get { return _expiryDate; }
            set
            {
                _expiryDate = value;
                ExpiryDateModel = new DateModel(_expiryDate);
            }
        }
        public string BatchNo { get; set; }
        public DateModel ExpiryDateModel { get; set; }
        public SalesTransactionTypes SalesTransactionTypeId { get; set; }
        public string ItemNameCode { get; set; }
        public bool Downloaded { get; set; }
        public int PackId { get; set; }
        public int ItemId { get; set; }
        public string WarehouseName { get; set; }
        public string WarehouseCode { get; set; }
        public decimal PiecesInPack { get; set; }
        public DateTime InvoiceDate { get; set; }

        public string InvoiceNumber { get; set; }
        public string CustomerName { get; set; }
        public string CustomerCode { get; set; }
        public string CustomerCodeName { get; set; }
        public string VehicleName { get; set; }
        public string VehicleCode { get; set; }
        public string OrganizationName { get; set; }
        public string OrganizationCode { get; set; }
        public string OrganizationCodeName { get; set; }
        public int OrganizationID { get; set; }
        public string SalesmanName { get; set; }
        public string SalesmanCode { get; set; }
        public string UOM { get; set; }
        public string ItemName { get; set; }
        public string ItemCode { get; set; }
        public string GTIN { get; set; }
        public string OutletName { get; set; }
        public string OutletCode { get; set; }
        public string OutletCodeName { get; set; }
        //  public List<ItemSerialRange> NewDividedRanges { get; set; }
        public bool IsDivided { get; set; }
        public ItemFormProcessMode FormProcessMode { get; set; }
        public SerialValidationErrors SerialValidationErrors { get; set; }
        public int PackIDTransTracking { get; set; }
        public SerialStatus ParentStatusID { get; set; }
        public string ErrorString { get; set; }
        public bool IsFromGenerate { get; set; }
        public SerialCurrentStatusDetails details { get; set; }
        public bool IsReserved { get; set; }
        public int RecallId { get; set; }
        public int TransactionRecallId { get; set; }
        public string SSCCBarcode { get; set; }
        public string ParentSSCCBarcode { get; set; }
        public int TransactionReadingId { get; set; }
        public bool IsReservedInSSCC { get; set; }
        public bool ToMainWarehouse { get; set; }
        public bool ToHelloJordan { get; set; }
        public string DivisionName { get; set; }
        public int RequiredQty { get; set; }
        public bool IsValid { get; set; }
        public bool UseGS1Standard { get; set; }
        public string OrderId { get; set; }
        public bool IsPartiallyPrepared { get; set; }
    }

    public class SerialCurrentStatusAndModeModel
    {
        SerialCurrentStatusAndModeModel()
        {
            BlockedSerials = new List<SerialCurrentStatusModel>();
        }
        public List<SerialCurrentStatusModel> BlockedSerials { get; set; }
        public bool IsBackToStoreResetMode { get; set; }
    }
    public class SerialItemFilterModel
    {
        public string itemSerial { get; set; }
        public string batchNo { get; set; }
        public bool filterByBatch { get; set; }
        public DateModel expiryDateModel { get; set; }
        public int PackId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int WarehouseId { get; set; }
        public bool IsCurrentStockMode { get; set; }
        public bool IsVehicle { get; set; }
        public string ssccBarcode { get; set; }
        public string parentSSCCBarcode { get; set; }
        public bool IsParentSSCCBarcode { get; set; }
        public SerialItemFilterModel()
        {
            PackId = -1;
            CustomerId = -1;
            OutletId = -1;
            WarehouseId = -1;
            itemSerial = string.Empty;
            IsCurrentStockMode = false;
            IsVehicle = false;
        }
    }
    public class SerialTransTrackingModel
    {
        public int EmployeeId { get; set; }
        public TransactionType TransactionType { get; set; }
        public bool IsWarehouseTransaction { get; set; }
        public string TransactionId { get; set; }
    }
    public class SerialTrackingHistoryModel
    {
        private DateTime _Date;
        public DateModel DateModel { get; set; }
        public DateTime Date
        {
            get { return _Date; }
            set
            {
                _Date = value;
                DateModel = new DateModel(_Date);
            }
        }
        public string Status { get; set; }
        public string WarehouseVehicleCodeName { get; set; }
        public string EmployeeCodeName { get; set; }
        public string OutletCodeName { get; set; }
        public string TransactionID { get; set; }
        public string OrganizationCodeName { get; set; }
        public string CustomerCodeName { get; set; }
        public string ItemCodeName { get; set; }
        public string OrganizationID { get; set; }
        public bool Voided { get; set; }
        public bool IsWarehouseTransaction { get; set; }
        public int? SalesTransactionTypeID { get; set; }
        public int TransactionType { get; set; }
        public string TransactionTypeName { get; set; }
        public string SSCCBarcode { get; set; }
    }
    public class SerialCurrentStatusDetails
    {
        private DateTime _expiryDate;
        public string VehicleName { get; set; }
        public string VehicleCode { get; set; }
        public string SalesmanName { get; set; }
        public string SalesmanCode { get; set; }
        public string OrganizationName { get; set; }
        public string OrganizationCode { get; set; }
        public string WarehouseName { get; set; }
        public string WarehouseCode { get; set; }
        public string CustomerName { get; set; }
        public string CustomerCode { get; set; }
        public string InvoiceNumber { get; set; }
        public string InvoiceDate { get; set; }
        public string SerialStatus { get; set; }
        public DateTime ExpiryDate
        {
            get { return _expiryDate; }
            set
            {
                _expiryDate = value;
                ExpiryDateModel = new DateModel(_expiryDate);
            }
        }
        public string BatchNo { get; set; }
        public DateModel ExpiryDateModel { get; set; }
        public string SSCCBarcode { get; set; }
    }
    public class AddedSerialRange
    {
        public string FromSerialString { get; set; }
        public BigInteger FromSerial { get; set; }
        public BigInteger ToSerial { get; set; }
        public string ToSerialString { get; set; }
        public int Length { get; set; }
    }

    public class CustomerSerialReassignment
    {
        public CustomerSerialReassignment()
        {
            SourceCustomerCodeName = string.Empty;
            SourceOutletCodeName = string.Empty;
            DestinationCustomerCodeName = string.Empty;
            DestinationOutletCodeName = string.Empty;
            EmployeeName = string.Empty;
            AddedSerialCurrentStatus = new List<SerialCurrentStatusModel>();
            ItemsList = new List<ItemPackModel>();
        }
        public int ReassignmentID { get; set; }
        public int SourceCustomerID { get; set; }
        public int SourceOutletID { get; set; }
        public string SourceCustomerCodeName { get; set; }
        public string SourceOutletCodeName { get; set; }
        public int DestinationCustomerID { get; set; }
        public int DestinationOutletID { get; set; }
        public string DestinationCustomerCodeName { get; set; }
        public string DestinationOutletCodeName { get; set; }
        public DateTime RessignDate { get; set; }
        public string EmployeeName { get; set; }
        public List<SerialCurrentStatusModel> AddedSerialCurrentStatus { get; set; }
        public List<ItemPackModel> ItemsList { get; set; }
    }

    public class CustomerSerialReassignmentFilter
    {
        public CustomListFilters CustomListFilter { get; set; }
        public int SourceCustomerID { get; set; }
        public int SourceOutletID { get; set; }
        public int DestinationCustomerID { get; set; }
        public int DestinationOutletID { get; set; }
        public DateModel RessignDate { get; set; }
    }
    public class InvalidSerialToExportModel
    {
        public InvalidSerialToExportModel()
        {
        }
        public List<SerialCurrentStatusModel> InvalidSerials { set; get; }
    }
    public class SerialDecodeModel
    {
        public SerialDecodeModel()
        {
            GTIN = "";
            BatchNumber = "";
            ExpiryDateString = "";
        }
        public string GTIN { get; set; }
        public string BatchNumber { get; set; }
        public string ExpiryDateString { get; set; }
        public DateTime ExpiryDate { get; set; }
        public DateModel ExpiryDateModel { get; set; }
    }
    public class InvalidSerial {
        public string Serial { get; set; }
        public string SerialToView { get; set; }
        public string InvalidText { get; set; }
        public SerialValidationErrors SerialValidationErrors { get; set; }
        public int ItemId { get; set; }
        public int PackId { get; set; }
        public string ItemName { get; set; }
        public string BatchNo { get; set; }
        public DateTime ExpiryDate { get; set; }
        public bool GetInvalidReasonOnline { get; set; }
    }
}
