﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class ServicesModel
    {
        public DateTime? _timeToRun { get; set; }
        public DateModel TimeToRunModel { get; set; }
        public int ServiceId { get; set; }
        public bool IsCertainTimeRuning { get; set; }
        public bool IsEnabled { get; set; }
        public string ServiceStatus { get; set; }
        public string ServiceName { get; set; }
        public string ServiceTitle { get; set; }
        public string ServiceDefinition { get; set; }
        public int NumberOfMinutesToSleep { get; set; }
        public DateTime? TimeToRun
        {
            get { return _timeToRun; }
            set
            {
                _timeToRun = value;
                if (_timeToRun != null)
                    TimeToRunModel = new DateModel(_timeToRun.Value);
            }
        }
        public bool IsWebService { get; set; }
        public string WebService { get; set; }
        public ServicesModel()
        {
            ServiceId = -1;
            IsCertainTimeRuning = false;
            ServiceName = string.Empty;
            ServiceDefinition = string.Empty;
            NumberOfMinutesToSleep = 0;
            ServiceStatus = string.Empty;
            TimeToRun = DateTime.Now;
            IsWebService = false;
        }
    }

    public class WindowsServiceData
    {
        public WindowsServiceData()
        {
            ServiceID = -1;
            ServiceName = string.Empty;
            IsCertainTimeRuning = false;
            TimeToRun = DateTime.Now;
            NumberOfMinutesToSleep = 0;
        }

        public int ServiceID { get; set; }
        public string ServiceName { get; set; }
        public bool IsCertainTimeRuning { get; set; }
        public DateTime TimeToRun { get; set; }
        public int NumberOfMinutesToSleep { get; set; }
    }
}
