﻿using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class SurveyModel
    {
        public int SurveyId { get; set; }
        public DateTime? _validFrom { get; set; }
        public DateTime? _validTo { get; set; }
        public DateTime? _readingDate { get; set; }
        public DateTime? _readingValidTo { get; set; }
        public DateModel ValidToModel { get; set; }
        public DateModel ValidFromModel { get; set; }
        public DateModel ReadingDateModel { get; set; }
        public DateModel ReadingValidToModel { get; set; }
        public List<SurveyPeriod> ListOfPeriods { get; set; }
        //public List<SurveyPeriod> Test { get; set; }
        public DateTime? ValidFrom
        {
            get { return _validFrom; }
            set
            {
                _validFrom = value;
                if (_validFrom != null)
                    ValidFromModel = new DateModel(_validFrom.Value);
            }
        }
        public DateTime? ValidTo
        {
            get { return _validTo; }
            set
            {
                _validTo = value;
                if (_validTo != null)
                    ValidToModel = new DateModel(_validTo.Value);
            }
        }
        public DateTime? ReadingDate
        {
            get { return _readingDate; }
            set
            {
                _readingDate = value;
                if (_readingDate != null)
                    ReadingDateModel = new DateModel(_readingDate.Value);
            }
        }
         public DateTime? ReadingValidTo
        {
            get { return _readingValidTo; }
            set
            {
                _readingValidTo = value;
                if (_readingValidTo != null)
                    ReadingValidToModel = new DateModel(_readingValidTo.Value);
            }
        }
        public DateModel LoadDateModel { get; set; }
        public int DCFID { get; set; }
        public int NumberOfQuestions { get; set; }
        public int TimeToFill { get; set; }  
        public int SurveySequence { get; set; }
        public int RouteHistoryStatusId { get; set; }
        public int SurveyTypeId { get; set; }
        public int OrganizationID { get; set; }
        public int ForceFillingMode { get; set; }
        public bool ApplyForNewCustomers { get; set; }
        public bool AllSecurityGroups { get; set; }
        public bool InActive { get; set; }
        public bool IsUsed { get; set; }
        public string SurveyName { get; set; }
        public string OrganizationName { get; set; }
        public string OrganizationCodeName { get; set; }
        public string LetterHead { get; set; }
        public List<TextLanguage> SurveyNameDescriptionLanguages { get; set; }
        public List<int> DeletedQuestion { get; set; }
        public List<TextLanguage> LetterHeadDescriptionLanguages { get; set; }
        public List<CreditReleaseAssignmentModel> ApplyTo { get; set; }
        public List<SimpleCustomerModel> AppliedCustomers { get; set; }
        public List<CustomerGroupModel> AppliedGroups { get; set; }
        public List<CustomerChannelModel> AppliedChannels { get; set; }
        public List<SecurityGroupModel> SecurityGroups { get; set; }
        public List<QuestionModel> Questions { get; set; }
        public List<PageGroupQuestionsModel> PageGroupQuestions { get; set; }
        public int SurveyPeriodTypeId { get; set; }
        public List<ItemPackModel> AppliedItems { get; set; }
        public List<EmployeeModel> AppliedInspectors { get; set; }
        public List<EmployeeModel>  AppliedEmployees { get; set; }        public bool AllItems { get; set; }
        public decimal Points { get; set; }
        public int WarehouseId { get; set; }
        public string Warehouse { get; set; }
        public int WarehouseTypeId { get; set; }
        public bool AllCustomers { get; set; }
        public bool AllOrganizationEmployees { get; set; }
        public int ReadingId { get; set; }
        public bool IsFilled { get; set; }
        public bool IsCompletelyFilled { get; set; }
        public string Status { get; set; }
        public bool IsMainMenu { get; set; }
        public string ImageId { get; set; }
        public List<OrganizationModel> OrganizationsList { get; set; }
        public SurveyReadingModel SurveyReadingModel { get; set; }
        public bool LinkedToProm { get; set; }
        public bool AssignedToPromotion { get; set; }
        public bool StartedPromotion { get; set; }
        public bool LinkedToPromotion { get; set; }
        public bool IsClone { get; set; }

        public SurveyModel()
        {
            DeletedQuestion = new List<int>();
            ApplyTo = new List<CreditReleaseAssignmentModel>();
            Questions = new List<QuestionModel>();
            PageGroupQuestions = new List<PageGroupQuestionsModel>();
            OrganizationName = "";
            SurveyName = "";
            LetterHead = "";
            InActive = false;
            AllSecurityGroups = false;
            ApplyForNewCustomers = false;
            ForceFillingMode = 0;
            AllItems = false;
            IsUsed = false;
            TimeToFill = 0;
            RouteHistoryStatusId = 0;
            NumberOfQuestions = -1;
            OrganizationID = -1;
            SurveyId = -1;
            DCFID = -1;
            SurveyTypeId = -1;
            SurveyNameDescriptionLanguages = new List<TextLanguage>();
            LetterHeadDescriptionLanguages = new List<TextLanguage>();
            SurveyPeriodTypeId = -1;
            AppliedItems = new List<ItemPackModel>();

            AppliedInspectors = new List<EmployeeModel>();
            Points = 0;
            WarehouseId = -1;
            Warehouse = string.Empty;
            WarehouseTypeId = -1;
            AllCustomers = false;
            AllOrganizationEmployees = false;
            IsFilled = false;
            IsCompletelyFilled = false;
            ReadingId = -1;
            Status = string.Empty;
            IsMainMenu = false;
            ImageId = string.Empty;
            OrganizationsList = new List<OrganizationModel>();
            SurveyReadingModel = new SurveyReadingModel();
            AppliedEmployees = new List<EmployeeModel>();
            LinkedToProm = false;
            AssignedToPromotion = false;
            StartedPromotion = false;
            LinkedToPromotion = false;
            IsClone = false;
        }
    }
    public class QuestionModel
    {
        public string ActionTypeIdString { get; set; }
        public bool ShowActionOnReading { get; set; }
        public string ActionNote { get; set; }
        public int FieldId { get; set; }
        public int SurveyId { get; set; }
        public int DCFID { get; set; }
        public int FieldGroupId { get; set; }
        public int FieldTypeID { get; set; }
        public int FieldSubTypeID { get; set; }
        public int XLOVID { get; set; }
        public int YLOVID { get; set; }
        public int LOVID { get; set; }
        public int LOVOptionID { get; set; }
        public int DependentQuestion { get; set; }
        public int DependentAnswer { get; set; }
        public string QuestionName { get; set; }
        public string QuestionBody { get; set; }
        public string QuestionTypeName { get; set; }
        public bool IsMatrix { get; set; }
        public bool IsMandatory { get; set; }
        public bool PhotoRequired { get; set; }
        public int Sequence { get; set; }
        public string FieldValue { get; set; }
        public List<LOVModel> QuestionOptions { get; set; }
        public List<TextLanguage> QuestionNameDescriptionLanguages { get; set; }
        public List<TextLanguage> QuestionBodyDescriptionLanguages { get; set; }
        public List<SurveyActionsTypesModel> ActionTypeId { get; set; }
        public decimal MinValue { get; set; }
        public decimal MaxValue { get; set; }
        public decimal YesScore { get; set; }
        public bool IsBarcode { get; set; }
        public int NumberOfAttachments { get; set; }
        public int AfterNumberOfDays { get; set; }
        public bool YesNo { get; set; }
        public string DynamicField { get; set; }
        public DateTime? _minDate { get; set; }
        public DateTime? _maxDate { get; set; }
        public DateModel MinDateModel { get; set; }
        public DateModel MaxDateModel { get; set; }
        public DateTime? MinDate
        {
            get { return _minDate; }
            set
            {
                _minDate = value;
                if (_minDate != null)
                    MinDateModel = new DateModel(_minDate.Value);
            }
        }
        public DateTime? MaxDate
        {
            get { return _maxDate; }
            set
            {
                _maxDate = value;
                if (_maxDate != null)
                    MaxDateModel = new DateModel(_maxDate.Value);
            }
        }
        public QuestionModel()
        {
            FieldId = -1;
            SurveyId = -1;
            DCFID = -1;
            FieldGroupId = -1;
            FieldTypeID = -1;
            FieldSubTypeID = -1;
            XLOVID = -1;
            YLOVID = -1;
            LOVID = -1;
            LOVOptionID = -1;
            DependentQuestion = -1;
            DependentAnswer = -1;
            QuestionBody = "";
            QuestionName = "";
            QuestionTypeName = "";
            IsMatrix = false;
            IsMandatory = false;
            PhotoRequired = false;
            Sequence = -1;
            FieldValue = "";
            QuestionOptions = new List<LOVModel>();
            QuestionNameDescriptionLanguages = new List<TextLanguage>();
            QuestionBodyDescriptionLanguages = new List<TextLanguage>();
            ActionTypeId = new List<SurveyActionsTypesModel>();
            MinValue = 0;
            MaxValue = 0;
            ActionTypeIdString = string.Empty;
            ShowActionOnReading = false;
            YesScore = -1;
            IsBarcode = false;
            NumberOfAttachments = 0;
            AfterNumberOfDays = 0;
            DynamicField = string.Empty;
        }

    }
    public class SurveyTemplateModel
    {
        public int Id { get; set; }
        public string Name { get; set; }
        public string Description { get; set; }
        public int IsUsed { get; set; }
        public bool IsQuery { get; set; }
        public string DynamicField { get; set; }
    }
    public class FieldGroupModel
    {
        public int GroupId { get; set; }
        public string GroupName { get; set; }
    }
    public class FieldTypeModel
    {
        public int FieldTypeId { get; set; }
        public string FieldTypeName { get; set; }
    }
    public class FieldSubTypeModel
    {
        public int FieldTypeId { get; set; }
        public int FieldSubTypeId { get; set; }
        public string FieldSubTypeName { get; set; }
    }
    public class SurveyPeriodTypeModel
    {
        public int periodTypeId { get; set; }
        public string periodTypeName { get; set; }

        public SurveyPeriodTypeModel()
        {
            periodTypeId = -1;
            periodTypeName = string.Empty;
        }
    }
    public class SurveyPeriod
    {
        public SurveyPeriod()
        {

        }
        public SurveyPeriod(DateModel fromDateModel, DateModel toDateModel)
        {
            this.FromDateModel = fromDateModel;
            this.ToDateModel = toDateModel;
        }
        public DateModel FromDateModel { get; set; }
        public DateModel ToDateModel { get; set; }
        //private DateTime? _fromDate { get; set; }
        //private DateTime? _toDate { get; set; }
        //public DateTime? FromDate
        //{
        //    get { return _fromDate; }
        //    set
        //    {
        //        _fromDate = value;
        //        if (_fromDate != null)
        //            FromDateModel = new DateModel(_fromDate.Value);
        //    }
        //}
        //public DateTime? ToDate
        //{
        //    get { return _toDate; }
        //    set
        //    {
        //        _toDate = value;
        //        if (_toDate != null)
        //            ToDateModel = new DateModel(_toDate.Value);
        //    }
        //}
    }
    //public class SurveyPeriod
    //{
    //    public SurveyPeriod(DateModel fromDateModel, DateModel toDateModel)
    //    {
    //        this.fromDateModel = fromDateModel;
    //        this.toDateModel = toDateModel;
    //    }
    //    public DateModel fromDateModel { get; set; }
    //    public DateTime? fromDate { get; set; }
    //    public DateModel _FromDateModel { get; set; }
    //    public DateTime? ValidFromDate
    //    {
    //        get { return fromDate; }
    //        set
    //        {
    //            fromDate = value;
    //            if (fromDate != null)
    //                _FromDateModel = new DateModel(fromDate.Value);
    //        }
    //    }
    //    public DateModel toDateModel { get; set; }
    //    public DateTime? toDate { get; set; }
    //    public DateModel _ToDateModel { get; set; }
    //    public DateTime? ValidTo
    //    {
    //        get { return fromDate; }
    //        set
    //        {
    //            toDate = value;
    //            if (toDate != null)
    //                _ToDateModel = new DateModel(toDate.Value);
    //        }
    //    }
    //}
    public class SurveyActionsTypesModel
    {
        public int actionTypeId { get; set; }
        public string actionTypeName { get; set; }

        public SurveyActionsTypesModel()
        {
            actionTypeId = -1;
            actionTypeName = string.Empty;
        }
    }
    public class LOVOptionModel
    {
        public int Id { get; set; }
        public List<LOVLanguageModel> OptionName { get; set; }
        public decimal OptionScore { get; set; }
        public LOVOptionModel()
        {
            Id = -1;
            OptionName = new List<LOVLanguageModel>();
            OptionScore = -1;
        }
    }
    public class LOVDynamicModel
    { 
        public int LOVID { get; set; }
        public List<LOVLanguageModel> LOVName { get; set; }
        public List<LOVLanguageModel> LOVDescription { get; set; }
        public string LOVQuery { get; set; }
        public List<LOVOptionModel> LOVOptionList { get; set; }
        public bool IsDynamic { get; set; }
        public string DynamicField { get; set; }

        public LOVDynamicModel()
        {
            LOVID = -1;
            LOVName = new List<LOVLanguageModel>();
            LOVDescription = new List<LOVLanguageModel>();
            LOVQuery = "";
            LOVOptionList = new List<LOVOptionModel>();
            IsDynamic = true;
            DynamicField = string.Empty;
        }
    }
    public class LOVModel
    {
        public int FieldID { get; set; }
        public int LOVOptionID { get; set; }
        public int LOVID { get; set; }
        public string LOVName { get; set; }
        public string LOVOptionName { get; set; }
    }
    public class PageGroupQuestionsModel
    {
        public int FieldGroupID { get; set; }
        public List<QuestionModel> Questions { get; set; }
    }
    public class QuestionModels
    {
        public int FieldID { get; set; }
        public string QuestionNames { get; set; }
    }
    public class LOVLanguageModel //change it name and use it in LOVDynamic model instead of string
    {
        public string Description { get; set; }
        public int LanguageId { get; set; }
    }
    public class AnswerModel
    {
        public int AnswerID { get; set; }
        public int DCFID { get; set; }
        public int SurveyID { get; set; }
        public int FieldTypeID { get; set; }
        public int LOVID { get; set; }
        public string AnswerName { get; set; }
    }
    public class FilterModel
    {
        public DateTime? ValidTo { get; set; }
        public bool Active { get; set; }
        public string SurveyName { get; set; }
        public int SurveyTypeId { get; set; }
    }
    public class SurveyReadingDetailsModel
    {
        public int SurveyId { get; set; }
        public int ItemId { get; set; }
        public List<ItemPackModel> AppliedItems { get; set; }
        public int FieldId { get; set; }
        public int FieldTypeId { get; set; }
        public int LOVId { get; set; }
        public string FieldValue { get; set; }
   
        private DateTime? _dateValue;
        public DateModel DateValueModel { get; set; }
        public DateTime? DateValue
        {
            get { return _dateValue; }
            set
            {
                _dateValue = value;
                if (_dateValue != null)
                    DateValueModel = new DateModel(_dateValue.Value);
            }
        }
        public string AcceptableValueNote { get; set; }
        public SurveyReadingDetailsModel()
        {

            ItemId = -1;
            FieldId = -1;
            FieldTypeId = -1;
            LOVId = -1;
            FieldValue = string.Empty;
            AppliedItems = new List<ItemPackModel>();
            AcceptableValueNote = string.Empty;
        }
    }
    public class SurveyReadingModel
    {
        public int ReadingId { get; set; }
        public int SurveyId { get; set; }
        public string SurveyName { get; set; }
        public int WarehouseId { get; set; }
        public int VehicleId { get; set; }
        public int DamagedWarehouseId { get; set; }
        public int InspectorId { get; set; }
        private DateTime? _startDate;
        private DateTime? _endDate;
        private DateTime? _validTo;
        public DateModel StartDateModel { get; set; }
        public DateModel EndDateModel { get; set; }
        public DateModel ValidToModel { get; set; }
        public DateTime? StartDate
        {
            get { return _startDate; }
            set
            {
                _startDate = value;
                if (_startDate != null)
                    StartDateModel = new DateModel(_startDate.Value);
            }
        }
        public DateTime? EndDate
        {
            get { return _endDate; }
            set
            {
                _endDate = value;
                if (_endDate != null)
                    EndDateModel = new DateModel(_endDate.Value);
            }
        }
        public DateTime? ValidTo
        {
            get { return _validTo; }
            set
            {
                _validTo = value;
                if (_validTo != null)
                    ValidToModel = new DateModel(_validTo.Value);
            }
        }
        public List<SurveyReadingDetailsModel> FieldsAnswers { get; set; }
        public int WarehouseTransactionOperationId { get; set; }
        public List<SurveyReadingActionsModel> Actions { get; set; }
        public List<SurveyReadingResultModel> ResultList { get; set; }
        public List<ItemPackModel> AppliedItems { get; set; }
        public string FilledItems { get; set; }
        public bool IsCompletelyFilled { get; set; }
        public bool AllItems { get; set; }
        public int SurveyPeriodTypeId { get; set; }
        public SurveyReadingModel()
        {
            ReadingId = -1;
            SurveyId = -1;
            SurveyName = string.Empty;
            WarehouseId = -1;
            VehicleId = -1;
            DamagedWarehouseId = -1;
            InspectorId = -1;
            FieldsAnswers = new List<SurveyReadingDetailsModel>();
            WarehouseTransactionOperationId = -1;
            Actions = new List<SurveyReadingActionsModel>();
            ResultList = new List<SurveyReadingResultModel>();
            FilledItems = string.Empty;
            IsCompletelyFilled = false;
            AllItems = false;
            AppliedItems = new List<ItemPackModel>();
            SurveyPeriodTypeId = -1;
        }
    }
    public class SurveyReadingActionsModel
    {
        public string OperationHeader { get; set; }
        public int ActionTypeId { get; set; }
        public List<ItemPackModel> AppliedItems { get; set; }
        public int WarehouseTransactionOperationId { get; set; }
        public bool IsCollapsed { get; set; }
        public SurveyReadingActionsModel()
        {
            OperationHeader = string.Empty;
            ActionTypeId = -1;
            AppliedItems = new List<ItemPackModel>();
            WarehouseTransactionOperationId = -1;
            IsCollapsed = true;
        }
    }
    public class SurveyReadingResultModel
    {
        public string Field { get; set; }
        public string Answer { get; set; }
        public string AcceptableValueNote { get; set; }
        public SurveyReadingResultModel()
        {
            Field = string.Empty;
            Answer = string.Empty;
            AcceptableValueNote = string.Empty;
        }
    }
    public class SurveyDataForPDF
    {
        public string Field { get; set; }
        public string Answer { get; set; }
        public SurveyDataForPDF()
        {
            Field = string.Empty;
            Answer = string.Empty;
        }
    }
    public class SurveyPeriodTest
    {
        public string FromDate { get; set; }
        public string ToDate { get; set; }
    }
    public class SurveyHeaderForPDF
    {
        public string SurveyName { get; set; }
        public string EmployeeCodeName { get; set; }
        public string CurrentDate { get; set; }
        public string WarehouseCodeName { get; set; }
        public string ItemCodeName { get; set; }
        public string vehicleWarehouse = string.Empty;
        public SurveyHeaderForPDF()
        {
            SurveyName = string.Empty;
            EmployeeCodeName = string.Empty;
            CurrentDate = string.Empty;
            WarehouseCodeName = string.Empty;
            ItemCodeName = string.Empty;
            vehicleWarehouse = string.Empty;
        }
    }
    public class SurveyMenu
    {
        public string Path { get; set; }
        public string ImageName { get; set; }
        public bool IsChecked { get; set; }
        public SurveyMenu()
        {
            Path = string.Empty;
            IsChecked = false;
            ImageName = string.Empty;
        }
    }

    public class SurveyFilter
    {
        public int SurveyTypeId { get; set; }
        public int SurveyId { get; set; }
        public SurveyFilter() 
        {
            SurveyTypeId = -1;
            SurveyId = -1;
        }

    }
}
    
